/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class MatrixUtils {
    private AxisAngle4f orient;
    private AxisAngle4d orientd;
    private float[] tempMat3 = new float[9];
    private float[] tempMat4 = new float[16];
    private float[] resMat4 = new float[16];
    private double[] tempMat3d = new double[9];
    private double[] tempMat4d = new double[16];
    private Matrix4d matrix4d = new Matrix4d();

    public void lookAt(Point3f point3f, Point3f point3f2, Vector3f vector3f, Matrix4f matrix4f) {
        double d;
        double d2;
        double d3;
        double d4 = point3f.x - point3f2.x;
        double d5 = point3f.y - point3f2.y;
        double d6 = point3f.z - point3f2.z;
        double d7 = d4 * d4 + d5 * d5 + d6 * d6;
        if (d7 != 1.0) {
            if (d7 == 0.0) {
                matrix4f.setIdentity();
                matrix4f.m03 = point3f.x;
                matrix4f.m13 = point3f.y;
                matrix4f.m23 = point3f.z;
                return;
            }
            d7 = 1.0 / Math.sqrt(d7);
            d4 *= d7;
            d5 *= d7;
            d6 *= d7;
        }
        double d8 = vector3f.x;
        double d9 = vector3f.y;
        double d10 = vector3f.z;
        d7 = vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z;
        if (d7 != 1.0) {
            if (d7 == 0.0) {
                throw new IllegalArgumentException("Up vector is all zeroes");
            }
            d7 = 1.0 / Math.sqrt(d7);
            d8 *= d7;
            d9 *= d7;
            d10 *= d7;
        }
        if ((d7 = (d3 = d9 * d6 - d5 * d10) * d3 + (d2 = d10 * d4 - d8 * d6) * d2 + (d = d8 * d5 - d9 * d4) * d) != 1.0) {
            if (d7 == 0.0) {
                this.lookAtFallback(point3f, (float)d4, (float)d5, (float)d6, matrix4f);
                return;
            }
            d7 = 1.0 / Math.sqrt(d7);
            d3 *= d7;
            d2 *= d7;
            d *= d7;
        }
        d8 = d5 * d - d2 * d6;
        d9 = d6 * d3 - d4 * d;
        d10 = d4 * d2 - d5 * d3;
        matrix4f.m00 = (float)d3;
        matrix4f.m01 = (float)d2;
        matrix4f.m02 = (float)d;
        matrix4f.m03 = -point3f.x * matrix4f.m00 - point3f.y * matrix4f.m01 - point3f.z * matrix4f.m02;
        matrix4f.m10 = (float)d8;
        matrix4f.m11 = (float)d9;
        matrix4f.m12 = (float)d10;
        matrix4f.m13 = -point3f.x * matrix4f.m10 - point3f.y * matrix4f.m11 - point3f.z * matrix4f.m12;
        matrix4f.m20 = (float)d4;
        matrix4f.m21 = (float)d5;
        matrix4f.m22 = (float)d6;
        matrix4f.m23 = -point3f.x * matrix4f.m20 - point3f.y * matrix4f.m21 - point3f.z * matrix4f.m22;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m32 = 0.0f;
        matrix4f.m33 = 1.0f;
    }

    public void lookAt(Point3d point3d, Point3d point3d2, Vector3d vector3d, Matrix4d matrix4d) {
        double d;
        double d2;
        double d3;
        double d4 = point3d.x - point3d2.x;
        double d5 = point3d.y - point3d2.y;
        double d6 = point3d.z - point3d2.z;
        double d7 = d4 * d4 + d5 * d5 + d6 * d6;
        if (d7 != 1.0) {
            if (d7 == 0.0) {
                matrix4d.setIdentity();
                matrix4d.m03 = point3d.x;
                matrix4d.m13 = point3d.y;
                matrix4d.m23 = point3d.z;
                return;
            }
            d7 = 1.0 / Math.sqrt(d7);
            d4 *= d7;
            d5 *= d7;
            d6 *= d7;
        }
        double d8 = vector3d.x;
        double d9 = vector3d.y;
        double d10 = vector3d.z;
        d7 = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        if (d7 != 1.0) {
            if (d7 == 0.0) {
                throw new IllegalArgumentException("Up vector is all zeroes");
            }
            d7 = 1.0 / Math.sqrt(d7);
            d8 *= d7;
            d9 *= d7;
            d10 *= d7;
        }
        if ((d7 = (d3 = d9 * d6 - d5 * d10) * d3 + (d2 = d10 * d4 - d8 * d6) * d2 + (d = d8 * d5 - d9 * d4) * d) != 1.0) {
            if (d7 == 0.0) {
                this.lookAtFallback(point3d, d4, d5, d6, matrix4d);
                return;
            }
            d7 = 1.0 / Math.sqrt(d7);
            d3 *= d7;
            d2 *= d7;
            d *= d7;
        }
        d8 = d5 * d - d2 * d6;
        d9 = d6 * d3 - d4 * d;
        d10 = d4 * d2 - d5 * d3;
        matrix4d.m00 = d3;
        matrix4d.m01 = d2;
        matrix4d.m02 = d;
        matrix4d.m03 = -point3d.x * matrix4d.m00 - point3d.y * matrix4d.m01 - point3d.z * matrix4d.m02;
        matrix4d.m10 = d8;
        matrix4d.m11 = d9;
        matrix4d.m12 = d10;
        matrix4d.m13 = -point3d.x * matrix4d.m10 - point3d.y * matrix4d.m11 - point3d.z * matrix4d.m12;
        matrix4d.m20 = d4;
        matrix4d.m21 = d5;
        matrix4d.m22 = d6;
        matrix4d.m23 = -point3d.x * matrix4d.m20 - point3d.y * matrix4d.m21 - point3d.z * matrix4d.m22;
        matrix4d.m30 = 0.0;
        matrix4d.m31 = 0.0;
        matrix4d.m32 = 0.0;
        matrix4d.m33 = 1.0;
    }

    public void setEuler(Vector3f vector3f, Matrix4f matrix4f) {
        this.setEuler(vector3f.x, vector3f.y, vector3f.z, matrix4f);
    }

    public void setEuler(float f, float f2, float f3, Matrix4f matrix4f) {
        float f4 = (float)Math.cos(f);
        float f5 = (float)Math.sin(f);
        float f6 = (float)Math.cos(f2);
        float f7 = (float)Math.sin(f2);
        float f8 = (float)Math.cos(f3);
        float f9 = (float)Math.sin(f3);
        float f10 = f4 * f7;
        float f11 = f5 * f7;
        matrix4f.m00 = f6 * f8;
        matrix4f.m01 = -f6 * f9;
        matrix4f.m02 = f7;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = f11 * f8 + f4 * f9;
        matrix4f.m11 = -f11 * f9 + f4 * f8;
        matrix4f.m12 = -f5 * f6;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = -f10 * f8 + f5 * f9;
        matrix4f.m21 = f10 * f9 + f5 * f8;
        matrix4f.m22 = f4 * f6;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m33 = 1.0f;
        matrix4f.m32 = 0.0f;
    }

    public void rotateX(float f, Matrix4f matrix4f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        matrix4f.m00 = 1.0f;
        matrix4f.m01 = 0.0f;
        matrix4f.m02 = 0.0f;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = 0.0f;
        matrix4f.m11 = f2;
        matrix4f.m12 = -f3;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = 0.0f;
        matrix4f.m21 = f3;
        matrix4f.m22 = f2;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m33 = 1.0f;
        matrix4f.m32 = 0.0f;
    }

    public void rotateY(float f, Matrix4f matrix4f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        matrix4f.m00 = f2;
        matrix4f.m01 = 0.0f;
        matrix4f.m02 = f3;
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = 0.0f;
        matrix4f.m11 = 1.0f;
        matrix4f.m12 = 0.0f;
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = -f3;
        matrix4f.m21 = 0.0f;
        matrix4f.m22 = f2;
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m33 = 1.0f;
        matrix4f.m32 = 0.0f;
    }

    public boolean inverse(Matrix4f matrix4f, Matrix4f matrix4f2) {
        float f = matrix4f.determinant();
        if (Math.abs(f) < 5.0E-7f) {
            matrix4f2.setIdentity();
            return false;
        }
        if (f > Float.MAX_VALUE || f < Float.MIN_VALUE) {
            this.inversed(matrix4f);
        } else {
            f = 1.0f / f;
            this.tempMat4[0] = matrix4f.m00;
            this.tempMat4[1] = matrix4f.m01;
            this.tempMat4[2] = matrix4f.m02;
            this.tempMat4[3] = matrix4f.m03;
            this.tempMat4[4] = matrix4f.m10;
            this.tempMat4[5] = matrix4f.m11;
            this.tempMat4[6] = matrix4f.m12;
            this.tempMat4[7] = matrix4f.m13;
            this.tempMat4[8] = matrix4f.m20;
            this.tempMat4[9] = matrix4f.m21;
            this.tempMat4[10] = matrix4f.m22;
            this.tempMat4[11] = matrix4f.m23;
            this.tempMat4[12] = matrix4f.m30;
            this.tempMat4[13] = matrix4f.m31;
            this.tempMat4[14] = matrix4f.m32;
            this.tempMat4[15] = matrix4f.m33;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int n = 1 - (i + j) % 2 * 2;
                    this.submatrix(i, j);
                    this.resMat4[i + j * 4] = this.determinant3x3() * (float)n * f;
                }
            }
        }
        matrix4f2.m00 = this.resMat4[0];
        matrix4f2.m01 = this.resMat4[1];
        matrix4f2.m02 = this.resMat4[2];
        matrix4f2.m03 = this.resMat4[3];
        matrix4f2.m10 = this.resMat4[4];
        matrix4f2.m11 = this.resMat4[5];
        matrix4f2.m12 = this.resMat4[6];
        matrix4f2.m13 = this.resMat4[7];
        matrix4f2.m20 = this.resMat4[8];
        matrix4f2.m21 = this.resMat4[9];
        matrix4f2.m22 = this.resMat4[10];
        matrix4f2.m23 = this.resMat4[11];
        matrix4f2.m30 = this.resMat4[12];
        matrix4f2.m31 = this.resMat4[13];
        matrix4f2.m32 = this.resMat4[14];
        matrix4f2.m33 = this.resMat4[15];
        return true;
    }

    private void inversed(Matrix4f matrix4f) {
        this.matrix4d.set(matrix4f);
        double d = this.matrix4d.determinant();
        d = 1.0 / d;
        this.tempMat4d[0] = this.matrix4d.m00;
        this.tempMat4d[1] = this.matrix4d.m01;
        this.tempMat4d[2] = this.matrix4d.m02;
        this.tempMat4d[3] = this.matrix4d.m03;
        this.tempMat4d[4] = this.matrix4d.m10;
        this.tempMat4d[5] = this.matrix4d.m11;
        this.tempMat4d[6] = this.matrix4d.m12;
        this.tempMat4d[7] = this.matrix4d.m13;
        this.tempMat4d[8] = this.matrix4d.m20;
        this.tempMat4d[9] = this.matrix4d.m21;
        this.tempMat4d[10] = this.matrix4d.m22;
        this.tempMat4d[11] = this.matrix4d.m23;
        this.tempMat4d[12] = this.matrix4d.m30;
        this.tempMat4d[13] = this.matrix4d.m31;
        this.tempMat4d[14] = this.matrix4d.m32;
        this.tempMat4d[15] = this.matrix4d.m33;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = 1 - (i + j) % 2 * 2;
                this.submatrixd(i, j);
                this.resMat4[i + j * 4] = (float)(this.determinant3dx3d() * (double)n * d);
            }
        }
    }

    private void submatrix(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = i + (i >= n ? 1 : 0);
                int n4 = j + (j >= n2 ? 1 : 0);
                this.tempMat3[i * 3 + j] = this.tempMat4[n3 * 4 + n4];
            }
        }
    }

    private void submatrixd(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = i + (i >= n ? 1 : 0);
                int n4 = j + (j >= n2 ? 1 : 0);
                this.tempMat3d[i * 3 + j] = this.tempMat4d[n3 * 4 + n4];
            }
        }
    }

    private float determinant3x3() {
        return this.tempMat3[0] * (this.tempMat3[4] * this.tempMat3[8] - this.tempMat3[7] * this.tempMat3[5]) - this.tempMat3[1] * (this.tempMat3[3] * this.tempMat3[8] - this.tempMat3[6] * this.tempMat3[5]) + this.tempMat3[2] * (this.tempMat3[3] * this.tempMat3[7] - this.tempMat3[6] * this.tempMat3[4]);
    }

    private double determinant3dx3d() {
        return this.tempMat3d[0] * (this.tempMat3d[4] * this.tempMat3d[8] - this.tempMat3d[7] * this.tempMat3d[5]) - this.tempMat3d[1] * (this.tempMat3d[3] * this.tempMat3d[8] - this.tempMat3d[6] * this.tempMat3d[5]) + this.tempMat3d[2] * (this.tempMat3d[3] * this.tempMat3d[7] - this.tempMat3d[6] * this.tempMat3d[4]);
    }

    private void lookAtFallback(Point3f point3f, float f, float f2, float f3, Matrix4f matrix4f) {
        float f4 = f2;
        float f5 = -f;
        float f6 = 0.0f;
        float f7 = f * f + f2 * f2 + f3 * f3;
        if (f7 != 0.0f || f7 != 1.0f) {
            f7 = 1.0f / (float)Math.sqrt(f7);
            f *= f7;
            f2 *= f7;
            f3 *= f7;
        }
        float f8 = -f3;
        float f9 = (float)Math.acos(f8);
        if (this.orient == null) {
            this.orient = new AxisAngle4f(f4, f5, f6, f9);
        } else {
            this.orient.set(f4, f5, f6, f9);
        }
        matrix4f.set(this.orient);
        matrix4f.m03 = point3f.x;
        matrix4f.m13 = point3f.y;
        matrix4f.m23 = point3f.z;
    }

    private void lookAtFallback(Point3d point3d, double d, double d2, double d3, Matrix4d matrix4d) {
        double d4 = d2;
        double d5 = -d;
        double d6 = 0.0;
        double d7 = d * d + d2 * d2 + d3 * d3;
        if (d7 != 0.0 || d7 != 1.0) {
            d7 = 1.0 / Math.sqrt(d7);
            d *= d7;
            d2 *= d7;
            d3 *= d7;
        }
        double d8 = -d3;
        double d9 = Math.acos(d8);
        if (this.orientd == null) {
            this.orientd = new AxisAngle4d(d4, d5, d6, d9);
        } else {
            this.orientd.set(d4, d5, d6, d9);
        }
        matrix4d.set(this.orientd);
        matrix4d.m03 = point3d.x;
        matrix4d.m13 = point3d.y;
        matrix4d.m23 = point3d.z;
    }
}

