/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

class ImageGenerator
implements ImageConsumer {
    private Object holder = new Object();
    private ColorModel colorModel;
    private Hashtable properties;
    private WritableRaster raster;
    private int width = -1;
    private int height = -1;
    private BufferedImage image;
    private int[] intBuffer;
    private boolean loadComplete = false;

    ImageGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageComplete(int n) {
        if (n == 3 || n == 4 || n == 1) {
            Object object = this.holder;
            synchronized (object) {
                this.loadComplete = true;
                this.holder.notify();
            }
        } else {
            System.err.println("Some other value passed to complete");
        }
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.createImage();
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.createImage();
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.loadComplete) {
            return;
        }
        if (this.intBuffer == null || byArray.length > this.intBuffer.length) {
            this.intBuffer = new int[byArray.length];
        }
        int n7 = byArray.length;
        while (--n7 >= 0) {
            this.intBuffer[n7] = byArray[n7] & 0xFF;
        }
        this.raster.setPixels(n, n2, n3, n4, this.intBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.loadComplete) {
            return;
        }
        this.image.setRGB(n, n2, n3, n4, nArray, n5, n6);
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        this.createImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage getImage() {
        Object object = this.holder;
        synchronized (object) {
            if (!this.loadComplete) {
                try {
                    this.holder.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.holder;
        synchronized (object) {
            this.holder.notify();
        }
        this.loadComplete = false;
        this.colorModel = null;
        this.raster = null;
        this.properties = null;
        this.image = null;
        this.width = -1;
        this.height = -1;
    }

    private void createImage() {
        if (this.image != null || this.width == -1 || this.colorModel == null || this.loadComplete) {
            return;
        }
        this.raster = this.colorModel.createCompatibleWritableRaster(this.width, this.height);
        boolean bl = this.colorModel.isAlphaPremultiplied();
        this.image = new BufferedImage(this.colorModel, this.raster, bl, this.properties);
    }
}

