/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.j3d.loaders.InvalidFormatException;
import org.j3d.loaders.stl.STLASCIIParser;
import org.j3d.loaders.stl.STLBinaryParser;
import org.j3d.loaders.stl.STLParser;

public class STLFileReader {
    private STLParser itsParser;

    public STLFileReader(File file) throws InvalidFormatException, IOException {
        this(file.toURL());
    }

    public STLFileReader(String string) throws InvalidFormatException, IOException {
        this(new URL(string));
    }

    public STLFileReader(URL uRL) throws InvalidFormatException, IOException {
        STLASCIIParser sTLASCIIParser = new STLASCIIParser();
        if (sTLASCIIParser.parse(uRL)) {
            this.itsParser = sTLASCIIParser;
        } else {
            STLBinaryParser sTLBinaryParser = new STLBinaryParser();
            sTLBinaryParser.parse(uRL);
            this.itsParser = sTLBinaryParser;
        }
    }

    public STLFileReader(URL uRL, Component component) throws InvalidFormatException, IOException {
        STLASCIIParser sTLASCIIParser = new STLASCIIParser();
        if (sTLASCIIParser.parse(uRL, component)) {
            this.itsParser = sTLASCIIParser;
        } else {
            STLBinaryParser sTLBinaryParser = new STLBinaryParser();
            sTLBinaryParser.parse(uRL, component);
            this.itsParser = sTLBinaryParser;
        }
    }

    public STLFileReader(File file, Component component) throws InvalidFormatException, IOException {
        this(file.toURL(), component);
    }

    public STLFileReader(String string, Component component) throws InvalidFormatException, IOException {
        this(new URL(string), component);
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws InvalidFormatException, IOException {
        return this.itsParser.getNextFacet(dArray, dArray2);
    }

    public String[] getObjectNames() {
        return this.itsParser.getObjectNames();
    }

    public int[] getNumOfFacets() {
        return this.itsParser.getNumOfFacets();
    }

    public int getNumOfObjects() {
        return this.itsParser.getNumOfObjects();
    }

    public void close() throws IOException {
        if (this.itsParser != null) {
            this.itsParser.close();
        }
    }
}

