/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.InvalidFormatException;
import org.j3d.loaders.stl.STLParser;

class STLASCIIParser
extends STLParser {
    private static final String FOUND_ON_LINE = " found on line ";
    private static final String UNKNOWN_KEYWORD_BASE = "STL ASCII format file contains an unknown keyword ";
    private static final String EMPTY_FILE_MSG = "The ASCII file format header was found, but there was no content defined in the file.";
    private BufferedReader itsReader;
    private StreamTokenizer itsTokenizer;

    public void close() throws IOException {
        if (this.itsReader != null) {
            this.itsReader.close();
        }
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws IOException {
        int n = this.itsTokenizer.nextToken();
        if (n == -1) {
            this.close();
            throw new IOException("Unexpected EOF");
        }
        if (n == -3) {
            if (this.itsTokenizer.sval.indexOf("s") >= 0) {
                this.skipObjectName(this.itsTokenizer);
                n = this.itsTokenizer.nextToken();
                if (n == -1) {
                    this.close();
                } else {
                    this.skipObjectName(this.itsTokenizer);
                }
            } else {
                this.itsTokenizer.pushBack();
            }
            this.readVector(this.itsTokenizer, dArray);
            for (int i = 0; i < 3; ++i) {
                this.readVector(this.itsTokenizer, dArray2[i]);
            }
        } else {
            this.close();
            throw new InvalidFormatException("Unexpected data found");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(URL uRL, Component component) throws InterruptedIOException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw iOException;
        }
        inputStream = new ProgressMonitorInputStream(component, "analyzing " + uRL.toString(), inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        try {
            bl = this.parse(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
        if (bl) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                inputStream.close();
                throw iOException;
            }
            inputStream = new ProgressMonitorInputStream(component, "parsing " + uRL.toString(), inputStream);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                this.configureTokenizer(bufferedReader);
            }
            catch (IOException iOException) {
                bufferedReader.close();
                throw iOException;
            }
            this.itsReader = bufferedReader;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw iOException;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        try {
            bl = this.parse(bufferedReader);
        }
        catch (InterruptedIOException interruptedIOException) {
            interruptedIOException.printStackTrace();
        }
        finally {
            bufferedReader.close();
        }
        if (bl) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                inputStream.close();
                throw iOException;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                this.configureTokenizer(bufferedReader);
            }
            catch (IOException iOException) {
                bufferedReader.close();
                throw iOException;
            }
            this.itsReader = bufferedReader;
        }
        return bl;
    }

    private boolean parse(BufferedReader bufferedReader) throws IOException, InvalidFormatException {
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        ArrayList<String> arrayList2 = new ArrayList<String>(10);
        boolean bl = true;
        String string = bufferedReader.readLine();
        int n4 = 1;
        if (!string.startsWith("solid")) {
            return false;
        }
        if ((string = string.trim()).length() > 6) {
            arrayList2.add(string.substring(6));
        } else {
            arrayList2.add(null);
        }
        string = bufferedReader.readLine();
        if (string == null) {
            throw new InvalidFormatException(EMPTY_FILE_MSG);
        }
        while (string != null) {
            ++n4;
            if (string.indexOf("facet") >= 0) {
                ++n3;
                for (n = 0; n < 6; ++n) {
                    bufferedReader.readLine();
                }
                n4 += 6;
            } else if (string.indexOf("endsolid") >= 0 || string.indexOf("end solid") >= 0) {
                arrayList.add(new Integer(n3));
                n3 = 0;
                ++n2;
            } else if (string.indexOf("solid") >= 0) {
                if ((string = string.trim()).length() > 6) {
                    arrayList2.add(string.substring(6));
                }
            } else {
                String string2 = UNKNOWN_KEYWORD_BASE + string + FOUND_ON_LINE + n4;
                throw new InvalidFormatException(string2);
            }
            string = bufferedReader.readLine();
        }
        this.itsNumOfObjects = n2;
        this.itsNumOfFacets = new int[n2];
        this.itsNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            Integer n5 = (Integer)arrayList.get(n);
            this.itsNumOfFacets[n] = n5;
            this.itsNames[n] = (String)arrayList2.get(n);
        }
        return true;
    }

    private void configureTokenizer(BufferedReader bufferedReader) throws IOException {
        bufferedReader.readLine();
        this.itsTokenizer = new StreamTokenizer(bufferedReader);
        this.itsTokenizer.resetSyntax();
        this.itsTokenizer.wordChars(48, 57);
        this.itsTokenizer.wordChars(69, 69);
        this.itsTokenizer.wordChars(43, 43);
        this.itsTokenizer.wordChars(45, 45);
        this.itsTokenizer.wordChars(46, 46);
        this.itsTokenizer.wordChars(115, 115);
        this.itsTokenizer.whitespaceChars(0, 32);
        this.itsTokenizer.whitespaceChars(97, 114);
        this.itsTokenizer.whitespaceChars(116, 122);
    }

    private void readVector(StreamTokenizer streamTokenizer, double[] dArray) throws IOException {
        for (int i = 0; i < 3; ++i) {
            int n = streamTokenizer.nextToken();
            if (n == -3) {
                try {
                    dArray[i] = Double.parseDouble(streamTokenizer.sval);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Unexpected data found");
                }
            }
            if (n == -1) {
                throw new IOException("Unexpected EOF");
            }
            throw new IOException("Unexpected data found.");
        }
    }

    private void skipObjectName(StreamTokenizer streamTokenizer) throws IOException {
        this.itsTokenizer.eolIsSignificant(true);
        int n = 0;
        while (n != 10) {
            n = this.itsTokenizer.nextToken();
        }
        this.itsTokenizer.eolIsSignificant(false);
    }
}

