/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.c3d;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.loaders.c3d.C3DParameter;

public class C3DParameterGroup {
    private static final String LOCKED_GROUP_MSG = "This group is locked and cannot be modified";
    private static final String NOT_PARENT_ID_MSG = "The ID of the parameter does not match that of this group";
    private static final String HAS_SAME_NAME_MSG = "A parameter with this name is already a child of this group.";
    private String name;
    private boolean locked;
    private int id;
    private String description;
    private ArrayList parameters;
    private HashMap parameterMap;

    public C3DParameterGroup(String string, boolean bl, int n, String string2) {
        this.name = string;
        this.locked = bl;
        this.id = n;
        this.description = string2;
        this.parameters = new ArrayList();
        this.parameterMap = new HashMap();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("C3DParameterGroup: ");
        stringBuffer.append(this.name);
        stringBuffer.append(" ID: ");
        stringBuffer.append(this.id);
        stringBuffer.append(" locked? ");
        stringBuffer.append(this.locked ? "Yes" : "No");
        stringBuffer.append("\n Description: ");
        if (this.description != null) {
            // empty if block
        }
        stringBuffer.append(this.description);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException(LOCKED_GROUP_MSG);
        }
        this.description = string;
    }

    public void addParameter(C3DParameter c3DParameter) throws IllegalStateException, IllegalArgumentException {
        if (this.locked) {
            throw new IllegalStateException(LOCKED_GROUP_MSG);
        }
        if (c3DParameter.id != -this.id) {
            throw new IllegalArgumentException(NOT_PARENT_ID_MSG);
        }
        String string = c3DParameter.getName();
        for (int i = 0; i < this.parameters.size(); ++i) {
            C3DParameter c3DParameter2 = (C3DParameter)this.parameters.get(i);
            if (!string.equals(c3DParameter2.getName())) continue;
            throw new IllegalArgumentException(HAS_SAME_NAME_MSG);
        }
        this.parameters.add(c3DParameter);
    }

    void addParameterUnlocked(C3DParameter c3DParameter) throws IllegalArgumentException {
        if (c3DParameter.id != -this.id) {
            throw new IllegalArgumentException(NOT_PARENT_ID_MSG);
        }
        String string = c3DParameter.getName();
        for (int i = 0; i < this.parameters.size(); ++i) {
            C3DParameter c3DParameter2 = (C3DParameter)this.parameters.get(i);
            if (!string.equals(c3DParameter2.getName())) continue;
            throw new IllegalArgumentException(HAS_SAME_NAME_MSG);
        }
        this.parameters.add(c3DParameter);
        this.parameterMap.put(c3DParameter.getName(), c3DParameter);
    }

    public void removeParameter(C3DParameter c3DParameter) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException(LOCKED_GROUP_MSG);
        }
        if (c3DParameter.id != -this.id) {
            return;
        }
        this.parameters.remove(c3DParameter);
        this.parameterMap.remove(c3DParameter.getName());
    }

    public C3DParameter getParameter(String string) {
        return (C3DParameter)this.parameterMap.get(string);
    }

    public C3DParameter[] getParameters() {
        C3DParameter[] c3DParameterArray = new C3DParameter[this.parameters.size()];
        this.parameters.toArray(c3DParameterArray);
        return c3DParameterArray;
    }
}

