/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.c3d;

import org.j3d.loaders.c3d.C3DParameter;

public class C3DFloatParameter
extends C3DParameter {
    public C3DFloatParameter(String string, boolean bl, int n) {
        super(1, string, bl, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("C3DFloatParameter: ");
        stringBuffer.append(this.name);
        stringBuffer.append(" ID: ");
        stringBuffer.append(this.id);
        stringBuffer.append(" locked? ");
        stringBuffer.append(this.locked ? "Yes" : "No");
        stringBuffer.append("\n Dimensions: ");
        stringBuffer.append(this.dimensions.length);
        stringBuffer.append(" (");
        if (this.dimensions.length > 0) {
            stringBuffer.append(this.dimensions[0]);
            for (int i = 1; i < this.dimensions.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.dimensions[i]);
            }
        }
        stringBuffer.append(")");
        stringBuffer.append("\n Description: ");
        if (this.description != null) {
            // empty if block
        }
        stringBuffer.append(this.description);
        return stringBuffer.toString();
    }

    public void setValue(float f) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = null;
        this.data = new Float(f);
    }

    public void setValue(float[] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][][][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][][][][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][][][][][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }

    public void setValue(float[][][][][][][] fArray, int[] nArray) throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("This parameter is locked and cannot be modified");
        }
        this.dimensions = nArray;
        this.data = fArray;
    }
}

