/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.hanim;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.geom.hanim.HAnimJoint;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.geom.hanim.HAnimObjectParent;
import org.j3d.geom.hanim.HAnimSegment;
import org.j3d.geom.hanim.HAnimSite;
import org.j3d.util.ErrorReporter;

public abstract class HAnimHumanoid
extends HAnimObject
implements HAnimObjectParent {
    private static final String MIN_ARRAY_SIZE_MSG = "The source array is either null or not long enough for HAnimHumanoid::";
    private static final String INVALID_CHILD_TYPE_MSG = "Invalid child type supplied. Must be one of Joint or Site";
    private static final Matrix4f IDENTITY_MATRIX = new Matrix4f();
    protected float[] bboxCenter;
    protected float[] bboxSize;
    private float[] center;
    private float[] rotation;
    private float[] scale;
    private float[] scaleOrientation;
    private float[] translation;
    protected float[] skinCoords;
    protected int numSkinCoords;
    protected float[] skinNormals;
    protected int numSkinNormals;
    protected Object outputCoords;
    protected Object outputNormals;
    protected Object[] viewpoints;
    protected int numViewpoints;
    private String version;
    private String[] info;
    private HAnimSite[] sites;
    private int numSites;
    private HAnimJoint[] joints;
    private int numJoints;
    protected HAnimObject[] skeleton;
    protected int numSkeleton;
    private HAnimSegment[] segments;
    private int numSegments;
    protected Matrix4f localMatrix;
    protected HAnimJoint rootJoint;
    protected boolean hasChildUpdates;
    protected boolean matrixChanged;
    private ArrayList updatedChildren;
    protected boolean skeletonChanged;
    protected int objectCount;

    public HAnimHumanoid() {
        IDENTITY_MATRIX.setIdentity();
        this.center = new float[3];
        this.rotation = new float[4];
        this.scale = new float[]{1.0f, 1.0f, 1.0f};
        this.scaleOrientation = new float[4];
        this.translation = new float[3];
        this.bboxCenter = new float[3];
        this.bboxSize = new float[3];
        this.rotation[2] = 1.0f;
        this.scaleOrientation[2] = 1.0f;
        this.localMatrix = new Matrix4f();
        this.localMatrix.setIdentity();
        this.updatedChildren = new ArrayList();
        this.hasChildUpdates = false;
        this.matrixChanged = false;
        this.skeletonChanged = false;
    }

    public void childUpdateRequired(HAnimObject hAnimObject) {
        if (hAnimObject == this.rootJoint) {
            this.skeletonChanged = true;
        } else {
            this.updatedChildren.add(hAnimObject);
        }
        this.hasChildUpdates = true;
    }

    public synchronized int requestNextObjectIndex() {
        return this.objectCount++;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        for (int i = 0; i < this.numSkeleton; ++i) {
            this.skeleton[i].setErrorReporter(this.errorReporter);
        }
    }

    public void getCenter(float[] fArray) {
        fArray[0] = this.center[0];
        fArray[1] = this.center[1];
        fArray[2] = this.center[2];
    }

    public void setCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::center");
        }
        this.center[0] = fArray[0];
        this.center[1] = fArray[1];
        this.center[2] = fArray[2];
        this.matrixChanged = true;
    }

    public void getScale(float[] fArray) {
        fArray[0] = this.scale[0];
        fArray[1] = this.scale[1];
        fArray[2] = this.scale[2];
    }

    public void setScale(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::scale");
        }
        this.scale[0] = fArray[0];
        this.scale[1] = fArray[1];
        this.scale[2] = fArray[2];
        this.matrixChanged = true;
    }

    public void getTranslation(float[] fArray) {
        fArray[0] = this.translation[0];
        fArray[1] = this.translation[1];
        fArray[2] = this.translation[2];
    }

    public void setTranslation(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::translation");
        }
        this.translation[0] = fArray[0];
        this.translation[1] = fArray[1];
        this.translation[2] = fArray[2];
        this.matrixChanged = true;
    }

    public void getScaleOrientation(float[] fArray) {
        fArray[0] = this.scaleOrientation[0];
        fArray[1] = this.scaleOrientation[1];
        fArray[2] = this.scaleOrientation[2];
        fArray[3] = this.scaleOrientation[3];
    }

    public void setScaleOrientation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::scaleOrientation");
        }
        this.scaleOrientation[0] = fArray[0];
        this.scaleOrientation[1] = fArray[1];
        this.scaleOrientation[2] = fArray[2];
        this.scaleOrientation[3] = fArray[3];
        this.matrixChanged = true;
    }

    public void getRotation(float[] fArray) {
        fArray[0] = this.rotation[0];
        fArray[1] = this.rotation[1];
        fArray[2] = this.rotation[2];
        fArray[3] = this.rotation[3];
    }

    public void setRotation(float[] fArray) {
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::rotation");
        }
        this.rotation[0] = fArray[0];
        this.rotation[1] = fArray[1];
        this.rotation[2] = fArray[2];
        this.rotation[3] = fArray[3];
        this.matrixChanged = true;
    }

    public void getBboxCenter(float[] fArray) {
        fArray[0] = this.bboxCenter[0];
        fArray[1] = this.bboxCenter[1];
        fArray[2] = this.bboxCenter[2];
    }

    public void setBboxCenter(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::bboxCenter");
        }
        this.bboxCenter[0] = fArray[0];
        this.bboxCenter[1] = fArray[1];
        this.bboxCenter[2] = fArray[2];
    }

    public void getBboxSize(float[] fArray) {
        fArray[0] = this.bboxSize[0];
        fArray[1] = this.bboxSize[1];
        fArray[2] = this.bboxSize[2];
    }

    public void setBboxSize(float[] fArray) {
        if (fArray == null || fArray.length < 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::bboxSize");
        }
        this.bboxSize[0] = fArray[0];
        this.bboxSize[1] = fArray[1];
        this.bboxSize[2] = fArray[2];
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public int numInfo() {
        return this.info == null ? 0 : this.info.length;
    }

    public void getInfo(String[] stringArray) {
        System.arraycopy(this.info, 0, stringArray, 0, this.numInfo());
    }

    public void setInfo(String[] stringArray, int n) {
        if (this.info == null || this.info.length != n) {
            this.info = new String[n];
        }
        System.arraycopy(stringArray, 0, this.info, 0, n);
    }

    public int numSkinCoord() {
        return this.numSkinCoords / 3;
    }

    public void getSkinCoord(float[] fArray) {
        System.arraycopy(this.skinCoords, 0, fArray, 0, this.numSkinCoords);
    }

    public void setSkinCoord(float[] fArray, int n) {
        if (fArray == null || fArray.length < n * 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::skinCoord");
        }
        if (this.skinCoords == null || this.skinCoords.length < n * 3) {
            this.skinCoords = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.skinCoords, 0, n * 3);
        this.numSkinCoords = n * 3;
        if (this.rootJoint != null) {
            this.rootJoint.updateSources(this.skinCoords, n, this.skinNormals, this.numSkinNormals / 3, this.outputCoords, this.outputNormals);
        }
    }

    public int numSkinNormal() {
        return this.numSkinNormals / 3;
    }

    public void getSkinNormal(float[] fArray) {
        System.arraycopy(this.skinNormals, 0, fArray, 0, this.numSkinNormals);
    }

    public void setSkinNormal(float[] fArray, int n) {
        if (fArray == null || fArray.length < n * 3) {
            throw new IllegalArgumentException("The source array is either null or not long enough for HAnimHumanoid::skinNormal");
        }
        if (this.skinNormals == null || this.skinNormals.length < n * 3) {
            this.skinNormals = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.skinNormals, 0, n * 3);
        this.numSkinNormals = n * 3;
        if (this.rootJoint != null) {
            this.rootJoint.updateSources(this.skinCoords, this.numSkinCoords / 3, this.skinNormals, n, this.outputCoords, this.outputNormals);
        }
    }

    public int numViewpoints() {
        return this.numViewpoints;
    }

    public void getViewpoints(Object[] objectArray) {
        System.arraycopy(this.viewpoints, 0, objectArray, 0, this.numViewpoints);
    }

    public void setViewpoints(Object[] objectArray, int n) {
        if (this.viewpoints == null || this.viewpoints.length < n) {
            this.viewpoints = new Object[n];
        }
        if (n != 0) {
            System.arraycopy(objectArray, 0, this.viewpoints, 0, n);
        }
        for (int i = n; i < this.numViewpoints; ++i) {
            this.viewpoints[i] = null;
        }
        this.numViewpoints = n;
    }

    public int numJoints() {
        return this.numJoints;
    }

    public void getJoints(HAnimJoint[] hAnimJointArray) {
        System.arraycopy(this.joints, 0, hAnimJointArray, 0, this.numJoints);
    }

    public void setJoints(HAnimJoint[] hAnimJointArray, int n) {
        if (this.joints == null || this.joints.length < n) {
            this.joints = new HAnimJoint[n];
        }
        if (n != 0) {
            System.arraycopy(hAnimJointArray, 0, this.joints, 0, n);
        }
        for (int i = n; i < this.numJoints; ++i) {
            this.joints[i] = null;
        }
        this.numJoints = n;
    }

    public int numSkeleton() {
        return this.numSkeleton;
    }

    public void getSkeleton(HAnimObject[] hAnimObjectArray) {
        System.arraycopy(this.skeleton, 0, hAnimObjectArray, 0, this.numSkeleton);
    }

    public void setSkeleton(HAnimObject[] hAnimObjectArray, int n) {
        int n2;
        if (this.skeleton == null || this.skeleton.length < n) {
            this.skeleton = new HAnimObject[n];
        }
        this.rootJoint = null;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(hAnimObjectArray[n2] instanceof HAnimJoint) && !(hAnimObjectArray[n2] instanceof HAnimSite)) {
                throw new IllegalArgumentException(INVALID_CHILD_TYPE_MSG);
            }
            this.skeleton[n2] = hAnimObjectArray[n2];
            if (hAnimObjectArray[n2] instanceof HAnimJoint) {
                if (this.rootJoint == null) {
                    this.rootJoint = (HAnimJoint)hAnimObjectArray[n2];
                }
                ((HAnimJoint)hAnimObjectArray[n2]).setParent(this, this.skinCoords, this.numSkinCoords / 3, this.skinNormals, this.numSkinNormals / 3, this.outputCoords, this.outputNormals);
                continue;
            }
            ((HAnimSite)hAnimObjectArray[n2]).setParent(this);
        }
        for (n2 = n; n2 < this.numSkeleton; ++n2) {
            this.skeleton[n2] = null;
        }
        this.numSkeleton = n;
    }

    public int numSites() {
        return this.numSites;
    }

    public void getSites(HAnimObject[] hAnimObjectArray) {
        System.arraycopy(this.sites, 0, hAnimObjectArray, 0, this.numSites);
    }

    public void setSites(HAnimSite[] hAnimSiteArray, int n) {
        if (this.sites == null || this.sites.length < n) {
            this.sites = new HAnimSite[n];
        }
        if (n != 0) {
            System.arraycopy(hAnimSiteArray, 0, this.sites, 0, n);
        }
        for (int i = n; i < this.numSites; ++i) {
            this.sites[i] = null;
        }
        this.numSites = n;
    }

    public int numSegments() {
        return this.numSegments;
    }

    public void getSegments(HAnimObject[] hAnimObjectArray) {
        System.arraycopy(this.segments, 0, hAnimObjectArray, 0, this.numSegments);
    }

    public void setSegments(HAnimSegment[] hAnimSegmentArray, int n) {
        if (this.segments == null || this.segments.length < n) {
            this.segments = new HAnimSegment[n];
        }
        if (n != 0) {
            System.arraycopy(hAnimSegmentArray, 0, this.segments, 0, n);
        }
        for (int i = n; i < this.numSegments; ++i) {
            this.segments[i] = null;
        }
        this.numSegments = n;
    }

    public void updateSkeleton() {
        if (!this.hasChildUpdates && !this.matrixChanged) {
            return;
        }
        if (this.matrixChanged) {
            HAnimHumanoid.updateMatrix(this.center, this.rotation, this.scale, this.scaleOrientation, this.translation, this.localMatrix);
            if (this.rootJoint != null) {
                this.rootJoint.updateSkeleton(IDENTITY_MATRIX, false);
                this.skeletonChanged = false;
            }
        }
        if (this.rootJoint != null && this.skeletonChanged) {
            this.rootJoint.updateSkeleton(IDENTITY_MATRIX, false);
            this.skeletonChanged = false;
        }
        int n = this.updatedChildren.size();
        for (int i = 0; i < n; ++i) {
            HAnimSite hAnimSite = (HAnimSite)this.updatedChildren.get(i);
            hAnimSite.updateLocation(this.localMatrix, this.matrixChanged);
        }
        this.updatedChildren.clear();
        this.hasChildUpdates = false;
        this.matrixChanged = false;
    }
}

