/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.texture;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture2D;
import org.j3d.util.ImageUtils;

public class TextureCreateUtils {
    private static final double LOG_2 = Math.log(2.0);

    public Texture2D createTexture2D(RenderedImage renderedImage) {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        n = this.nearestPowerTwo(n, true);
        n2 = this.nearestPowerTwo(n2, true);
        RenderedImage renderedImage2 = this.scaleTexture(renderedImage, n, n2);
        ImageComponent2D imageComponent2D = this.create2DImageComponent(renderedImage2);
        Texture2D texture2D = new Texture2D(1, this.getTextureFormat((ImageComponent)imageComponent2D), n, n2);
        texture2D.setImage(0, (ImageComponent)imageComponent2D);
        return texture2D;
    }

    public int getTextureFormat(ImageComponent imageComponent) {
        int n = 6;
        switch (imageComponent.getFormat()) {
            case 10: {
                n = 2;
                break;
            }
            case 7: 
            case 8: {
                n = 4;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                n = 5;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    public RenderedImage scaleTexture(RenderedImage renderedImage, int n, int n2) {
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        if (n3 == n && n4 == n2) {
            return renderedImage;
        }
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        RenderedImage renderedImage2 = renderedImage;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            ColorModel colorModel = bufferedImage.getColorModel();
            if (colorModel.hasAlpha()) {
                renderedImage2 = affineTransformOp.filter((BufferedImage)renderedImage, null);
            } else {
                renderedImage2 = new BufferedImage(n, n2, ((BufferedImage)renderedImage).getType());
                affineTransformOp.filter((BufferedImage)renderedImage, (BufferedImage)renderedImage2);
            }
        } else {
            System.out.println("Can't rescale RenderedImage.");
        }
        return renderedImage2;
    }

    public ImageComponent2D create2DImageComponent(Object object) {
        if (!(object instanceof ImageProducer || object instanceof BufferedImage || object instanceof Image)) {
            throw new IllegalArgumentException("Not a valid image type " + object);
        }
        BufferedImage bufferedImage = null;
        bufferedImage = object instanceof ImageProducer ? ImageUtils.createBufferedImage((ImageProducer)((ImageProducer)object)) : (object instanceof BufferedImage ? (BufferedImage)object : ImageUtils.createBufferedImage((Image)((Image)object)));
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha();
        int n = 2;
        switch (bufferedImage.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 12: {
                n = 1;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n = 2;
                break;
            }
            case 10: 
            case 11: {
                n = 10;
                break;
            }
            case 13: {
                if (bl) {
                    n = 2;
                    break;
                }
                n = 1;
                break;
            }
            case 9: {
                n = 3;
                break;
            }
            case 8: {
                n = 3;
            }
        }
        ImageComponent2D imageComponent2D = new ImageComponent2D(n, bufferedImage, true, false);
        return imageComponent2D;
    }

    public int nearestPowerTwo(int n, boolean bl) {
        int n2 = bl ? (int)Math.ceil(Math.log(n) / LOG_2) : (int)Math.floor(Math.log(n) / LOG_2);
        return (int)Math.pow(2.0, n2);
    }

    private int computeLog(int n) {
        int n2 = 0;
        if (n == 0) {
            return -1;
        }
        while (n != 1) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }
}

