/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;
import org.j3d.renderer.java3d.overlay.Overlay;
import org.j3d.renderer.java3d.overlay.OverlayUtilities;
import org.j3d.renderer.java3d.overlay.ScreenComponent;
import org.j3d.renderer.java3d.overlay.SubOverlay;
import org.j3d.renderer.java3d.overlay.UpdateManager;

public abstract class OverlayBase
implements Overlay,
ScreenComponent,
ComponentListener {
    private static final double CONSOLE_Z = (double)2.1f;
    private static final double DEFAULT_FOV = 0.785398;
    protected static final int DIRTY_VISIBLE = 0;
    protected static final int DIRTY_POSITION = 1;
    protected static final int DIRTY_ACTIVE_BUFFER = 2;
    protected static final int DIRTY_SIZE = 3;
    protected static final int DEFAULT_INSET = 5;
    protected int leftInset;
    protected int rightInset;
    protected int topInset;
    protected int bottomInset;
    protected int backgroundMode = 1;
    private BufferedImage backgroundImage;
    private boolean hasAlpha;
    private boolean visible;
    private boolean antialiased;
    private int numBuffers;
    private final int minDivSize;
    protected Rectangle overlayBounds;
    protected Dimension componentSize;
    protected double fieldOfView;
    private UpdateManager updateManager;
    private Canvas3D canvas3D;
    protected BufferedImage canvas;
    protected Color backgroundColor;
    protected SubOverlay[] subOverlay;
    protected int activeBuffer = -1;
    protected BranchGroup consoleBG;
    private BranchGroup blankBG;
    protected BranchGroup overlayTexGrp;
    protected TransformGroup consoleTG;
    private RenderingAttributes renderAttributes;
    private PolygonAttributes polygonAttributes;
    private TextureAttributes textureAttributes;
    private TransparencyAttributes transparencyAttributes;
    private Material material;
    private boolean[] dirtyCheck = new boolean[4];
    protected final boolean fixedSize;
    private boolean painting = false;
    private boolean initComplete;

    protected OverlayBase(Canvas3D canvas3D, Dimension dimension) {
        this(canvas3D, dimension, true, false, null);
    }

    protected OverlayBase(Canvas3D canvas3D, Dimension dimension, UpdateManager updateManager) {
        this(canvas3D, dimension, true, false, updateManager);
    }

    protected OverlayBase(Canvas3D canvas3D, Dimension dimension, boolean bl, boolean bl2) {
        this(canvas3D, dimension, bl, bl2, null);
    }

    protected OverlayBase(Canvas3D canvas3D, Dimension dimension, boolean bl, boolean bl2, UpdateManager updateManager) {
        this(canvas3D, dimension, bl, bl2, updateManager, 2);
    }

    protected OverlayBase(Canvas3D canvas3D, Dimension dimension, boolean bl, boolean bl2, UpdateManager updateManager, int n) {
        Object object;
        this.numBuffers = n;
        this.initComplete = false;
        this.leftInset = 5;
        this.rightInset = 5;
        this.topInset = 5;
        this.bottomInset = 5;
        this.canvas3D = canvas3D;
        if (dimension == null) {
            this.fixedSize = false;
            this.minDivSize = 1;
            if (canvas3D != null) {
                this.overlayBounds = canvas3D.getBounds();
                this.componentSize = canvas3D.getSize();
                object = canvas3D.getView();
                this.fieldOfView = object == null ? 0.785398 : object.getFieldOfView();
            } else {
                this.overlayBounds = new Rectangle();
                this.componentSize = new Dimension();
                this.fieldOfView = 0.785398;
            }
        } else {
            this.fixedSize = true;
            this.minDivSize = 8;
            this.overlayBounds = new Rectangle(0, 0, dimension.width, dimension.height);
            if (this.canvas3D != null) {
                this.componentSize = canvas3D.getSize();
                object = canvas3D.getView();
                this.fieldOfView = object == null ? 0.785398 : object.getFieldOfView();
            } else {
                this.componentSize = new Dimension(dimension);
                this.fieldOfView = 0.785398;
            }
        }
        this.visible = true;
        this.antialiased = true;
        boolean bl3 = this.hasAlpha = bl || bl2;
        if (this.overlayBounds.width != 0 && this.overlayBounds.height != 0) {
            this.canvas = OverlayUtilities.createBufferedImage(dimension, this.hasAlpha);
        }
        if (this.canvas3D != null && !this.fixedSize) {
            this.canvas3D.addComponentListener((ComponentListener)this);
        }
        this.blankBG = new BranchGroup();
        this.blankBG.setCapability(17);
        this.consoleBG = new BranchGroup();
        this.consoleBG.setCapability(13);
        this.consoleBG.setCapability(17);
        this.overlayTexGrp = new BranchGroup();
        this.overlayTexGrp.setCapability(17);
        this.consoleTG = new TransformGroup();
        this.consoleTG.setCapability(18);
        this.overlayTexGrp.addChild((Node)this.consoleTG);
        this.consoleBG.addChild((Node)this.overlayTexGrp);
        this.updateManager = updateManager;
        this.renderAttributes = new RenderingAttributes();
        if (bl) {
            this.renderAttributes.setAlphaTestFunction(3);
            this.renderAttributes.setAlphaTestValue(0.0f);
        }
        this.renderAttributes.setDepthBufferEnable(false);
        this.renderAttributes.setDepthBufferWriteEnable(false);
        this.renderAttributes.setIgnoreVertexColors(true);
        this.renderAttributes.setCapability(5);
        this.renderAttributes.setCapability(6);
        this.polygonAttributes = new PolygonAttributes();
        this.polygonAttributes.setBackFaceNormalFlip(false);
        this.polygonAttributes.setCullFace(0);
        this.polygonAttributes.setPolygonMode(2);
        this.textureAttributes = new TextureAttributes();
        this.textureAttributes.setTextureMode(5);
        this.textureAttributes.setPerspectiveCorrectionMode(0);
        this.material = new Material();
        this.material.setLightingEnable(false);
        if (this.hasAlpha) {
            this.transparencyAttributes = new TransparencyAttributes(2, 1.0f);
            this.textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 1.0f));
        }
        object = OverlayUtilities.subdivide(this.componentSize.width, this.componentSize.height, this.minDivSize, 256);
        this.subOverlay = new SubOverlay[object.size()];
        int n2 = object.size();
        for (int i = 0; i < n2; ++i) {
            Rectangle rectangle = (Rectangle)object.get(i);
            this.subOverlay[i] = new SubOverlay(rectangle, n, this.hasAlpha, this.polygonAttributes, this.renderAttributes, this.textureAttributes, this.transparencyAttributes, this.material);
            this.consoleTG.addChild((Node)this.subOverlay[i].getShape());
        }
        this.dirtyCheck[0] = true;
        this.dirtyCheck[1] = true;
        this.dirtyCheck[2] = true;
    }

    public void initialize() {
        this.initComplete = true;
    }

    public void setComponentDetails(Dimension dimension, double d) {
        this.componentSize.setSize(dimension);
        this.fieldOfView = d;
        if (this.fixedSize) {
            this.dirty(1);
        } else {
            this.dirty(3);
        }
    }

    public void setLocation(int n, int n2) {
        if (this.overlayBounds.x != n || this.overlayBounds.y != n2) {
            this.overlayBounds.x = n;
            this.overlayBounds.y = n2;
            this.dirty(1);
        }
    }

    public void setSize(int n, int n2) {
        if (this.overlayBounds.width != n || this.overlayBounds.height != n2) {
            this.overlayBounds.width = n;
            this.overlayBounds.height = n2;
            this.dirty(3);
        }
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets.left, insets.top, insets.right, insets.bottom);
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.leftInset = n;
        this.topInset = n2;
        this.rightInset = n3;
        this.bottomInset = n4;
    }

    public BranchGroup getRoot() {
        return this.consoleBG;
    }

    public void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
            this.repaint();
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty(0);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setBackgroundMode(int n) {
        if (this.backgroundMode != n) {
            this.backgroundMode = n;
            this.repaint();
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
        if (this.updateManager == null) {
            return;
        }
        for (int i = 0; i < this.dirtyCheck.length; ++i) {
            if (!this.dirtyCheck[i]) continue;
            this.updateManager.updateRequested(this);
            break;
        }
    }

    public void update() {
        if (this.dirtyCheck[3]) {
            this.syncSize();
        }
        if (this.dirtyCheck[1]) {
            this.syncPosition();
        }
        if (this.dirtyCheck[0]) {
            this.syncVisible();
        }
        if (this.dirtyCheck[2]) {
            this.syncActiveBuffer();
        }
    }

    public Rectangle getBounds() {
        return this.overlayBounds;
    }

    public boolean contains(Point point) {
        return this.overlayBounds.contains(point);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.canvas3D != null) {
            this.componentSize = this.canvas3D.getSize();
            View view = this.canvas3D.getView();
            if (view != null) {
                this.fieldOfView = view.getFieldOfView();
            }
        }
        if (this.fixedSize) {
            this.dirty(1);
        } else {
            this.dirty(3);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.dirty(1);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (this.overlayBounds.width == 0 || this.overlayBounds.height == 0) {
            return;
        }
        this.updateBackgroundColor();
    }

    public BufferedImage getBackgroundImage() {
        if (this.backgroundImage == null) {
            this.backgroundImage = OverlayUtilities.createBufferedImage(this.overlayBounds.getSize(), this.hasAlpha);
        }
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage bufferedImage) {
        if (this.backgroundImage != bufferedImage) {
            this.backgroundImage = bufferedImage;
            this.repaint();
        }
    }

    protected void dirty(int n) {
        if (!this.initComplete) {
            return;
        }
        this.dirtyCheck[n] = true;
        if (this.updateManager != null) {
            this.updateManager.updateRequested(this);
        }
    }

    protected void setActiveBuffer(int n) {
        this.activeBuffer = n;
        this.dirty(2);
    }

    protected Graphics2D getGraphics() {
        if (this.backgroundMode == 1 && this.backgroundImage != null) {
            this.canvas.setData(this.backgroundImage.getRaster());
        }
        Graphics2D graphics2D = (Graphics2D)this.canvas.getGraphics();
        if (this.antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public void paint(Graphics2D graphics2D) {
    }

    public void repaint() {
        if (!this.painting && this.initComplete) {
            this.painting = true;
            Graphics2D graphics2D = this.getGraphics();
            this.paint(graphics2D);
            graphics2D.dispose();
            this.updateBuffer(this.canvas, -1);
            this.setActiveBuffer(-1);
            this.painting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuffer(BufferedImage bufferedImage, int n) {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            for (int i = this.subOverlay.length - 1; i >= 0; --i) {
                this.subOverlay[i].updateBuffer(bufferedImage, n);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void updateBackgroundColor() {
        int[] nArray = new int[this.overlayBounds.width * this.overlayBounds.height];
        int n = this.backgroundColor.getRGB();
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = n;
        }
        this.getBackgroundImage().setRGB(0, 0, this.overlayBounds.width, this.overlayBounds.height, nArray, 0, this.overlayBounds.width);
        this.repaint();
    }

    private void syncVisible() {
        this.renderAttributes.setVisible(this.visible);
        this.dirtyCheck[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncActiveBuffer() {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            for (int i = this.subOverlay.length - 1; i >= 0; --i) {
                this.subOverlay[i].setActiveBufferIndex(this.activeBuffer);
            }
            this.dirtyCheck[2] = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPosition() {
        Rectangle rectangle = this.overlayBounds;
        synchronized (rectangle) {
            if (this.componentSize.width == 0 || this.componentSize.height == 0 || this.overlayBounds.width == 0 || this.overlayBounds.height == 0) {
                return;
            }
            if (this.canvas == null) {
                Dimension dimension = this.overlayBounds.getSize();
                this.canvas = OverlayUtilities.createBufferedImage(dimension, this.hasAlpha);
            }
            if (this.backgroundColor != null) {
                this.updateBackgroundColor();
            }
            double d = (double)4.2f * Math.tan(this.fieldOfView * 0.5);
            double d2 = d / (double)this.componentSize.width;
            double d3 = (double)this.componentSize.height * d2;
            float f = this.overlayBounds.x;
            float f2 = this.componentSize.height - this.overlayBounds.height - this.overlayBounds.y;
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d(-d / 2.0 + (double)f * d2, -d3 / 2.0 + (double)f2 * d2, (double)-2.1f);
            transform3D.setTranslation(vector3d);
            transform3D.setScale(d2);
            this.consoleTG.setTransform(transform3D);
            this.dirtyCheck[1] = false;
        }
    }

    private void syncSize() {
        if (!this.fixedSize && this.canvas3D != null) {
            this.overlayBounds = this.canvas3D.getBounds();
        }
        if (this.overlayBounds.width != 0 && this.overlayBounds.height != 0) {
            this.overlayTexGrp = new BranchGroup();
            this.overlayTexGrp.setCapability(17);
            this.consoleTG = new TransformGroup();
            this.consoleTG.setCapability(18);
            this.overlayTexGrp.addChild((Node)this.consoleTG);
            List list = OverlayUtilities.subdivide(this.overlayBounds.getSize(), this.minDivSize, 256);
            this.backgroundImage = null;
            this.canvas = null;
            this.subOverlay = new SubOverlay[list.size()];
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Rectangle rectangle = (Rectangle)list.get(i);
                this.subOverlay[i] = new SubOverlay(rectangle, this.numBuffers, this.hasAlpha, this.polygonAttributes, this.renderAttributes, this.textureAttributes, this.transparencyAttributes, this.material);
                this.consoleTG.addChild((Node)this.subOverlay[i].getShape());
            }
            this.consoleBG.setChild((Node)this.overlayTexGrp, 0);
        } else {
            this.overlayTexGrp = null;
            this.consoleTG = null;
            this.subOverlay = new SubOverlay[0];
            this.canvas = null;
            this.consoleBG.setChild((Node)this.blankBG, 0);
        }
        this.dirtyCheck[3] = false;
        this.syncPosition();
    }
}

