/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.loaders;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.j3d.loaders.vterrain.BTHeader;
import org.j3d.loaders.vterrain.BTParser;
import org.j3d.renderer.java3d.loaders.BinaryLoader;
import org.j3d.renderer.java3d.loaders.HeightMapLoader;
import org.j3d.renderer.java3d.loaders.ManagedLoader;

public class BTLoader
extends HeightMapLoader
implements BinaryLoader,
ManagedLoader {
    private BufferedInputStream input;
    private BTParser parser;
    private ElevationGridGenerator generator;
    private float[] gridStepData;
    private Map overrideCapBitsMap;
    private Map requiredCapBitsMap;
    private Map overrideFreqBitsMap;
    private Map requiredFreqBitsMap;
    private final boolean haveFreqBitsAPI;

    public BTLoader() {
        this(0);
    }

    public BTLoader(int n) {
        super(n);
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("javax.media.j3d.SceneGraphObject");
                    Package package_ = clazz.getPackage();
                    return new Boolean(package_.isCompatibleWith("1.3"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Boolean.FALSE;
                }
            }
        });
        this.haveFreqBitsAPI = bl;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        this.overrideCapBitsMap = map;
        this.overrideFreqBitsMap = map2;
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        this.requiredCapBitsMap = map;
        this.requiredFreqBitsMap = map2;
    }

    public Scene load(InputStream inputStream) throws IncorrectFormatException, ParsingErrorException {
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        return this.load();
    }

    public Scene load(Reader reader) throws IncorrectFormatException {
        throw new IncorrectFormatException("Loader only handles binary data");
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input = new BufferedInputStream(fileInputStream);
        return this.load();
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.load();
    }

    public float[][] getHeights() {
        return this.parser.getHeights();
    }

    public float[] getGridStep() {
        return this.gridStepData;
    }

    public BTHeader getHeader() {
        return this.parser.getHeader();
    }

    private Scene load() throws IncorrectFormatException, ParsingErrorException {
        float[][] fArray = null;
        try {
            if (this.parser == null) {
                this.parser = new BTParser((InputStream)this.input);
            } else {
                this.parser.reset((InputStream)this.input);
            }
            fArray = this.parser.parse();
            this.input = null;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException("Error parsing stream: " + iOException);
        }
        BTHeader bTHeader = this.parser.getHeader();
        float f = (float)(bTHeader.rightExtent - bTHeader.leftExtent);
        float f2 = (float)(bTHeader.topExtent - bTHeader.bottomExtent);
        this.gridStepData = new float[2];
        this.gridStepData[0] = f / (float)bTHeader.rows;
        this.gridStepData[1] = f2 / (float)bTHeader.columns;
        if (this.generator == null) {
            this.generator = new ElevationGridGenerator(f, f2, bTHeader.rows, bTHeader.columns, fArray, 0.0f);
        } else {
            this.generator.setDimensions(f, f2, bTHeader.rows, bTHeader.columns);
            this.generator.setTerrainDetail(fArray, 0.0f);
        }
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 6;
        this.generator.generate(geometryData);
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        this.setCapBits((SceneGraphObject)branchGroup);
        this.setFreqBits((SceneGraphObject)branchGroup);
        int n = 35;
        TriangleStripArray triangleStripArray = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray.setCoordinates(0, geometryData.coordinates);
        triangleStripArray.setNormals(0, geometryData.normals);
        triangleStripArray.setTextureCoordinates(0, 0, geometryData.textureCoordinates);
        Appearance appearance = new Appearance();
        this.setCapBits((SceneGraphObject)appearance);
        this.setFreqBits((SceneGraphObject)appearance);
        Shape3D shape3D = new Shape3D((Geometry)triangleStripArray, appearance);
        this.setCapBits((SceneGraphObject)shape3D);
        this.setFreqBits((SceneGraphObject)shape3D);
        branchGroup.addChild((Node)shape3D);
        sceneBase.setSceneGroup(branchGroup);
        return sceneBase;
    }

    private void setCapBits(SceneGraphObject sceneGraphObject) {
        Class<?> clazz = sceneGraphObject.getClass();
        Map map = Collections.EMPTY_MAP;
        if (this.overrideCapBitsMap != null) {
            map = this.overrideCapBitsMap;
        } else if (this.requiredCapBitsMap != null) {
            map = this.requiredCapBitsMap;
        }
        int[] nArray = (int[])map.get(clazz);
        int n = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n; ++i) {
            sceneGraphObject.setCapability(nArray[i]);
        }
    }

    private void setFreqBits(SceneGraphObject sceneGraphObject) {
        if (!this.haveFreqBitsAPI) {
            return;
        }
        Class<?> clazz = sceneGraphObject.getClass();
        Map map = Collections.EMPTY_MAP;
        if (this.overrideFreqBitsMap != null) {
            map = this.overrideFreqBitsMap;
        } else if (this.requiredFreqBitsMap != null) {
            map = this.requiredFreqBitsMap;
        }
        int[] nArray = (int[])map.get(clazz);
        int n = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n; ++i) {
            sceneGraphObject.setCapabilityIsFrequent(nArray[i]);
        }
    }
}

