/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.ui.swt.widgets.ImageLoader;
import org.xj3d.ui.swt.widgets.ViewpointComboManager;

public class ViewpointToolbar
extends Composite
implements SelectionListener,
ViewpointStatusListener,
NavigationStateListener,
Runnable {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String DEFAULT_HOME_BUTTON = "images/navigation/ButtonHome.gif";
    private static final String DEFAULT_FITWORLD_BUTTON = "images/navigation/ButtonFit.gif";
    private static final String DEFAULT_LOOKAT_BUTTON = "images/navigation/ButtonLookat.gif";
    private static final String DEFAULT_NEXT_BUTTON = "images/navigation/ButtonForward.gif";
    private static final String DEFAULT_PREVIOUS_BUTTON = "images/navigation/ButtonBack.gif";
    private static final String HOME_BUTTON_PROPERTY = "HOME.button";
    private static final String FITWORLD_BUTTON_PROPERTY = "FITWORLD.button";
    private static final String LOOKAT_BUTTON_PROPERTY = "LOOKAT.button";
    private static final String NEXT_BUTTON_PROPERTY = "NEXTVIEW.button";
    private static final String PREVIOUS_BUTTON_PROPERTY = "PREVIOUSVIEW.button";
    private static final String HOME_BUTTON_TEXT = "Home";
    private static final String FITWORLD_BUTTON_TEXT = "Fit";
    private static final String LOOKAT_BUTTON_TEXT = "Look At";
    private static final String NEXT_BUTTON_TEXT = "Next";
    private static final String PREVIOUS_BUTTON_TEXT = "Previous";
    private static final String HOME_BUTTON_TOOLTIP_TEXT = "Return to current Viewpoint";
    private static final String FITWORLD_BUTTON_TOOLTIP_TEXT = "Fit to World";
    private static final String LOOKAT_BUTTON_TOOLTIP_TEXT = "Look At";
    private static final String NEXT_BUTTON_TOOLTIP_TEXT = "Next Viewpoint";
    private static final String PREVIOUS_BUTTON_TOOLTIP_TEXT = "Previous Viewpoint";
    private static final String VIEWPOINT_COMBO_TOOLTIP_TEXT = "Select a Viewpoint";
    private static int PROPERTY_INDEX = 0;
    private static int IMAGE_INDEX = 1;
    private static int TEXT_INDEX = 2;
    private static int TOOLTIP_TEXT_INDEX = 3;
    private static final String[][] buttonData = new String[][]{{"PREVIOUSVIEW.button", "images/navigation/ButtonBack.gif", "Previous", "Previous Viewpoint"}, {"NEXTVIEW.button", "images/navigation/ButtonForward.gif", "Next", "Next Viewpoint"}, {"HOME.button", "images/navigation/ButtonHome.gif", "Home", "Return to current Viewpoint"}, {"LOOKAT.button", "images/navigation/ButtonLookat.gif", "Look At", "Look At"}, {"FITWORLD.button", "images/navigation/ButtonFit.gif", "Fit", "Fit to World"}};
    private static final int PREVIOUS_BUTTON_INDEX = 0;
    private static final int NEXT_BUTTON_INDEX = 1;
    private static final int HOME_BUTTON_INDEX = 2;
    private static final int LOOKAT_BUTTON_INDEX = 3;
    private static final int FITWORLD_BUTTON_INDEX = 4;
    private Button[] button;
    private Display display;
    private boolean setEnabledFlag;
    private boolean enabled;
    private boolean setLookAtEnabledFlag;
    private boolean lookAtEnabled;
    private boolean setPartialDisableFlag;
    private ErrorReporter errorReporter;
    private ViewpointManager vpManager;
    private Combo viewpointCombo;
    private ViewpointComboManager comboManager;
    private ArrayList viewpointsByLayer;
    private boolean noInitialVPS;
    private ArrayList defaultViewpoints;
    private ArrayList boundViewpoints;
    private int activeLayerId;
    private BrowserCore browserCore;

    public ViewpointToolbar(Composite composite, BrowserCore browserCore, ViewpointManager viewpointManager, ErrorReporter errorReporter) {
        this(composite, browserCore, viewpointManager, DEFAULT_PROPERTIES, errorReporter);
    }

    public ViewpointToolbar(Composite composite, BrowserCore browserCore, ViewpointManager viewpointManager, Properties properties, ErrorReporter errorReporter) {
        super(composite, 0);
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.vpManager = viewpointManager;
        this.browserCore = browserCore;
        browserCore.addNavigationStateListener((NavigationStateListener)this);
        browserCore.addViewpointStatusListener((ViewpointStatusListener)this);
        this.viewpointsByLayer = new ArrayList();
        this.defaultViewpoints = new ArrayList();
        this.boundViewpoints = new ArrayList();
        this.activeLayerId = -1;
        Properties properties2 = properties == null ? DEFAULT_PROPERTIES : properties;
        int n = buttonData.length;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = n + 1;
        gridLayout.makeColumnsEqualWidth = false;
        super.setLayout((Layout)gridLayout);
        this.button = new Button[n];
        this.display = this.getDisplay();
        String string = properties2.getProperty(buttonData[0][PROPERTY_INDEX], buttonData[0][IMAGE_INDEX]);
        Image image = ImageLoader.loadImage(this.display, string, errorReporter);
        Button button = new Button((Composite)this, 8);
        if (image == null) {
            button.setText(buttonData[0][TEXT_INDEX]);
        } else {
            button.setImage(image);
        }
        button.setToolTipText(buttonData[0][TOOLTIP_TEXT_INDEX]);
        button.addSelectionListener((SelectionListener)this);
        button.setEnabled(false);
        this.button[0] = button;
        this.viewpointCombo = new Combo((Composite)this, 12);
        this.viewpointCombo.setVisibleItemCount(10);
        this.viewpointCombo.setToolTipText(VIEWPOINT_COMBO_TOOLTIP_TEXT);
        this.viewpointCombo.addSelectionListener((SelectionListener)this);
        this.viewpointCombo.setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.viewpointCombo.setLayoutData((Object)gridData);
        this.comboManager = new ViewpointComboManager(this.display, this.viewpointCombo);
        for (int i = 1; i < n; ++i) {
            string = properties2.getProperty(buttonData[i][PROPERTY_INDEX], buttonData[i][IMAGE_INDEX]);
            image = ImageLoader.loadImage(this.display, string, errorReporter);
            button = new Button((Composite)this, 8);
            if (image == null) {
                button.setText(buttonData[i][TEXT_INDEX]);
            } else {
                button.setImage(image);
            }
            button.setToolTipText(buttonData[i][TOOLTIP_TEXT_INDEX]);
            button.addSelectionListener((SelectionListener)this);
            if (i == 1) {
                button.setEnabled(false);
            }
            this.button[i] = button;
        }
    }

    public void setLayout(Layout layout) {
    }

    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setEnabledFlag = true;
        this.setPartialDisableFlag = false;
        this.display.asyncExec((Runnable)this);
    }

    public void navigationStateChanged(int n) {
    }

    public void navigationListChanged(String[] stringArray, int n) {
        boolean bl = false;
        this.lookAtEnabled = false;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("ANY")) {
                this.lookAtEnabled = true;
                break;
            }
            String string = stringArray[i];
            if (!string.equals("LOOKAT")) continue;
            this.lookAtEnabled = true;
        }
        this.setLookAtEnabledFlag = true;
        this.display.asyncExec((Runnable)this);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        VRMLViewpointNodeType vRMLViewpointNodeType;
        Object object = selectionEvent.getSource();
        if (object == this.button[1]) {
            this.vpManager.nextViewpoint();
        } else if (object == this.button[0]) {
            this.vpManager.previousViewpoint();
        } else if (object == this.button[2]) {
            int n2 = this.viewpointCombo.getSelectionIndex();
            VRMLViewpointNodeType vRMLViewpointNodeType2 = this.comboManager.getNode(n2);
            if (vRMLViewpointNodeType2 != null) {
                this.vpManager.setViewpoint(vRMLViewpointNodeType2);
            }
        } else if (object == this.button[4]) {
            if (this.browserCore != null) {
                this.browserCore.fitToWorld(false);
            }
        } else if (object == this.button[3]) {
            if (this.browserCore != null) {
                this.browserCore.setNavigationMode("LOOKAT");
            }
        } else if (object == this.viewpointCombo && (vRMLViewpointNodeType = this.comboManager.getNode(n = this.viewpointCombo.getSelectionIndex())) != null && !vRMLViewpointNodeType.getIsBound()) {
            this.vpManager.setViewpoint(vRMLViewpointNodeType);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        int n;
        VRMLViewpointNodeType vRMLViewpointNodeType;
        Object object = selectionEvent.getSource();
        if (object == this.viewpointCombo && (vRMLViewpointNodeType = this.comboManager.getNode(n = this.viewpointCombo.getSelectionIndex())) != null && !vRMLViewpointNodeType.getIsBound()) {
            this.vpManager.setViewpoint(vRMLViewpointNodeType);
        }
    }

    public void viewpointLayerAdded(int n) {
        if (n >= this.viewpointsByLayer.size()) {
            for (int i = this.viewpointsByLayer.size() - 1; i <= n; ++i) {
                this.viewpointsByLayer.add(null);
                this.defaultViewpoints.add(null);
                this.boundViewpoints.add(null);
            }
        }
        this.viewpointsByLayer.set(n, new ArrayList());
    }

    public void viewpointLayerRemoved(int n) {
        this.viewpointsByLayer.set(n, null);
        this.defaultViewpoints.set(n, null);
        this.boundViewpoints.set(n, null);
    }

    public void viewpointLayerActive(int n) {
        this.activeLayerId = n;
        if (n == -1) {
            this.clearViewpoints();
        } else {
            ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
            if (arrayList == null || arrayList.size() == 0) {
                this.comboManager.clear();
                this.partialDisable();
            } else {
                this.comboManager.clear();
                Object e = this.defaultViewpoints.get(n);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e2 = arrayList.get(i);
                    if (e2 == e) continue;
                    this.comboManager.add((VRMLViewpointNodeType)e2);
                }
                this.comboManager.select((VRMLViewpointNodeType)this.boundViewpoints.get(n));
                if (arrayList.size() == 1) {
                    this.partialDisable();
                }
            }
        }
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType, int n, boolean bl) {
        ArrayList arrayList;
        boolean bl2;
        if (bl) {
            this.defaultViewpoints.set(n, vRMLViewpointNodeType);
            if (this.boundViewpoints.get(n) == null) {
                this.boundViewpoints.set(n, vRMLViewpointNodeType);
            }
        }
        if (!(bl2 = (arrayList = (ArrayList)this.viewpointsByLayer.get(n)).contains(vRMLViewpointNodeType))) {
            arrayList.add(vRMLViewpointNodeType);
        }
        if (n == this.activeLayerId) {
            if (bl) {
                if (arrayList.size() == 0) {
                    if (!bl2) {
                        this.comboManager.add(vRMLViewpointNodeType);
                    }
                    this.partialDisable();
                }
            } else {
                Object e = this.defaultViewpoints.get(n);
                if (e != null) {
                    this.comboManager.remove((VRMLViewpointNodeType)e);
                }
                if (!bl2) {
                    this.comboManager.add(vRMLViewpointNodeType);
                }
                this.setEnabled(true);
            }
        }
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
        arrayList.remove(vRMLViewpointNodeType);
        if (this.defaultViewpoints.get(n) == vRMLViewpointNodeType) {
            this.defaultViewpoints.set(n, null);
        }
        if (this.boundViewpoints.get(n) == vRMLViewpointNodeType) {
            this.boundViewpoints.set(n, this.defaultViewpoints.get(n));
        }
        if (n == this.activeLayerId) {
            this.comboManager.remove(vRMLViewpointNodeType);
        }
    }

    public void viewpointBound(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        this.boundViewpoints.set(n, vRMLViewpointNodeType);
        if (n == this.activeLayerId) {
            this.comboManager.select(vRMLViewpointNodeType);
        }
    }

    public synchronized void run() {
        if (this.setEnabledFlag) {
            super.setEnabled(this.enabled);
            this.viewpointCombo.setEnabled(this.enabled);
            for (int i = 0; i < this.button.length; ++i) {
                this.button[i].setEnabled(this.enabled);
            }
            this.setEnabledFlag = false;
        }
        if (this.setPartialDisableFlag) {
            this.viewpointCombo.setEnabled(false);
            this.button[0].setEnabled(false);
            this.button[1].setEnabled(false);
            this.button[2].setEnabled(true);
            this.button[4].setEnabled(true);
            this.button[3].setEnabled(true);
            this.setPartialDisableFlag = false;
        }
        if (this.setLookAtEnabledFlag) {
            this.button[3].setEnabled(this.lookAtEnabled);
            this.setLookAtEnabledFlag = false;
        }
    }

    public void clearViewpoints() {
        this.comboManager.clear();
        this.setEnabled(false);
    }

    private synchronized void partialDisable() {
        this.setPartialDisableFlag = true;
        this.setEnabledFlag = false;
        this.display.asyncExec((Runnable)this);
    }
}

