/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;

public class ViewpointComboManager
implements Runnable {
    private static final String NO_DESCRIPTION = "<No description>";
    private boolean listHasChanged;
    private boolean selectionHasChanged;
    private ArrayList nodeList;
    private VRMLViewpointNodeType selectNode;
    private Display display;
    private Combo combo;

    public ViewpointComboManager(Display display, Combo combo) {
        this.display = display;
        this.combo = combo;
        this.nodeList = new ArrayList();
        this.listHasChanged = false;
        this.selectionHasChanged = false;
    }

    public void run() {
        Object object;
        int n;
        if (this.listHasChanged) {
            this.combo.removeAll();
            for (n = 0; n < this.nodeList.size(); ++n) {
                VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.nodeList.get(n);
                object = vRMLViewpointNodeType.getDescription();
                if (object == null) {
                    object = NO_DESCRIPTION;
                }
                this.combo.add((String)object);
            }
            this.listHasChanged = false;
        }
        if (this.selectionHasChanged) {
            n = this.nodeList.size();
            for (int i = 0; i < n; ++i) {
                object = (VRMLViewpointNodeType)this.nodeList.get(i);
                if (!object.equals(this.selectNode)) continue;
                this.combo.select(i);
                break;
            }
            this.selectionHasChanged = false;
        }
    }

    public void clear() {
        this.nodeList.clear();
        if (!this.listHasChanged) {
            this.listHasChanged = true;
            this.display.asyncExec((Runnable)this);
        }
    }

    public void add(VRMLViewpointNodeType vRMLViewpointNodeType) {
        if (vRMLViewpointNodeType != null) {
            this.nodeList.add(vRMLViewpointNodeType);
            if (!this.listHasChanged) {
                this.listHasChanged = true;
                this.display.asyncExec((Runnable)this);
            }
        }
    }

    public void remove(VRMLViewpointNodeType vRMLViewpointNodeType) {
        int n;
        if (vRMLViewpointNodeType != null && (n = this.nodeList.indexOf(vRMLViewpointNodeType)) != -1) {
            this.nodeList.remove(n);
            if (!this.listHasChanged) {
                this.listHasChanged = true;
                this.display.asyncExec((Runnable)this);
            }
        }
    }

    public void select(VRMLViewpointNodeType vRMLViewpointNodeType) {
        if (vRMLViewpointNodeType != null) {
            this.selectNode = vRMLViewpointNodeType;
            if (!this.selectionHasChanged) {
                this.selectionHasChanged = true;
                this.display.asyncExec((Runnable)this);
            }
        }
    }

    public VRMLViewpointNodeType getNode(int n) {
        if (n > -1 && n < this.nodeList.size()) {
            return (VRMLViewpointNodeType)this.nodeList.get(n);
        }
        return null;
    }
}

