/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.vrml.nodes.VRMLScene;
import org.xj3d.ui.swt.widgets.Alarm;
import org.xj3d.ui.swt.widgets.AlarmEvent;
import org.xj3d.ui.swt.widgets.AlarmListener;
import org.xj3d.ui.swt.widgets.StatusReporter;

public class StatusBar
extends Composite
implements Runnable,
AlarmListener,
StatusReporter,
BrowserCoreListener {
    private static final int UPDATE_PERIOD_MILLIS = 500;
    private Text statusLabel;
    private float lastFPS;
    private Text fpsLabel;
    private BrowserCore browserCore;
    private boolean statusUpdate;
    private String statusString;
    private Alarm alarm;
    private Timer fpsTimer;
    private boolean fpsUpdate;
    private String fpsString;
    private Display display;

    public StatusBar(Composite composite, BrowserCore browserCore, boolean bl, boolean bl2, Properties properties) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        super.setLayout((Layout)gridLayout);
        this.browserCore = browserCore;
        this.browserCore.addCoreListener((BrowserCoreListener)this);
        this.display = this.getDisplay();
        this.statusLabel = new Text((Composite)this, 16652);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.statusLabel.setLayoutData((Object)gridData);
        this.fpsLabel = new Text((Composite)this, 131340);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.fpsLabel.setLayoutData((Object)gridData);
        if (bl2) {
            this.fpsTimer = new Timer();
            this.alarm = new Alarm();
            this.alarm.addAlarmListener(this);
            this.fpsTimer.schedule((TimerTask)this.alarm, 500L, 500L);
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        if (this.alarm != null) {
            this.alarm.cancel();
            this.alarm.removeAlarmListener(this);
            this.alarm = null;
        }
        if (this.fpsTimer != null) {
            this.fpsTimer.cancel();
            this.fpsTimer = null;
        }
    }

    public void setLayout(Layout layout) {
    }

    public void run() {
        if (this.fpsUpdate && !this.fpsLabel.isDisposed()) {
            this.fpsLabel.setText(this.fpsString);
            this.fpsUpdate = false;
        }
        if (this.statusUpdate && !this.statusLabel.isDisposed()) {
            this.statusLabel.setText(this.statusString);
            this.statusUpdate = false;
        }
    }

    public void alarmAction(AlarmEvent alarmEvent) {
        float f = this.browserCore.getCurrentFrameRate();
        if (!Float.isInfinite(f) && (double)Math.abs(this.lastFPS - f) > 0.01) {
            int n = (int)f;
            int n2 = (int)((f -= (float)n) * 100000.0f);
            this.fpsString = n + "." + n2;
            this.fpsUpdate = true;
            if (!this.display.isDisposed()) {
                this.display.asyncExec((Runnable)this);
            }
            this.lastFPS = f;
        }
    }

    public void setStatusText(String string) {
        if (this.statusLabel != null && string != null) {
            this.statusString = string != null ? string : "";
            this.statusUpdate = true;
            this.display.asyncExec((Runnable)this);
        }
    }
}

