/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.prefs.Preferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;

public class OpenAction
implements SelectionListener,
Runnable {
    private static final String OPEN_FILE_DIALOG_TITLE = "Open File";
    private static final String FILENAME_TO_URL_FAILURE_MESSAGE = "Filename conversion to URL failed";
    private static final String UNABLE_TO_LOAD_MESSAGE = "Unable to load: ";
    private static String[] filterName = new String[]{"All Files", "Just X3D Files", "Just VRML Files", "Just GZIP'ed Files"};
    private static String[] filterExtension = new String[]{"*.*", "*.x3d*", "*.wr*", "*.gz"};
    private static final String LASTDIR_PROPERTY = "History_";
    private FileHandler fileHandler;
    private ErrorReporter errorReporter;
    private Shell parent;
    private String contentDir;
    private FileDialog dialog;
    private String urlToLoad;

    public OpenAction(Shell shell, FileHandler fileHandler, String string) {
        Preferences preferences;
        String string2;
        this.parent = shell;
        this.fileHandler = fileHandler;
        this.errorReporter = this.fileHandler.getErrorReporter();
        this.contentDir = string != null ? string : ((string2 = (preferences = Preferences.userNodeForPackage(OpenAction.class)).get(LASTDIR_PROPERTY, null)) != null ? string2 : System.getProperty("user.dir"));
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.dialog == null) {
            this.createDialog();
        }
        try {
            String string = this.dialog.open();
            if (string != null) {
                File file = new File(string);
                Preferences preferences = Preferences.userNodeForPackage(OpenAction.class);
                preferences.put(LASTDIR_PROPERTY, file.getParent());
                if (file.exists()) {
                    this.urlToLoad = file.toURL().toString();
                    new Thread(this).start();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.errorReporter.errorReport(FILENAME_TO_URL_FAILURE_MESSAGE, (Exception)malformedURLException);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void run() {
        try {
            this.fileHandler.loadURL(this.urlToLoad);
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport(UNABLE_TO_LOAD_MESSAGE, (Exception)iOException);
        }
    }

    private void createDialog() {
        this.dialog = new FileDialog(this.parent, 4096);
        this.dialog.setText(OPEN_FILE_DIALOG_TITLE);
        this.dialog.setFilterPath(this.contentDir);
        this.dialog.setFilterNames(filterName);
        this.dialog.setFilterExtensions(filterExtension);
    }
}

