/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.util.Properties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xj3d.ui.swt.widgets.ImageLoader;

public class NavigationToolbar
extends Composite
implements SelectionListener,
NavigationStateListener,
Runnable {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String EXAMINE_BUTTON_PROPERTY = "EXAMINE.button";
    private static final String FLY_BUTTON_PROPERTY = "FLY.button";
    private static final String PAN_BUTTON_PROPERTY = "PAN.button";
    private static final String TILT_BUTTON_PROPERTY = "TILT.button";
    private static final String WALK_BUTTON_PROPERTY = "WALK.button";
    private static final String DEFAULT_EXAMINE_BUTTON = "images/navigation/ButtonExamine.gif";
    private static final String DEFAULT_FLY_BUTTON = "images/navigation/ButtonFly.gif";
    private static final String DEFAULT_PAN_BUTTON = "images/navigation/ButtonPan.gif";
    private static final String DEFAULT_TILT_BUTTON = "images/navigation/ButtonTilt.gif";
    private static final String DEFAULT_WALK_BUTTON = "images/navigation/ButtonWalk.gif";
    private static final String DEFAULT_EXAMINE_TEXT = "Examine";
    private static final String DEFAULT_FLY_TEXT = "Fly";
    private static final String DEFAULT_PAN_TEXT = "Pan";
    private static final String DEFAULT_TILT_TEXT = "Tilt";
    private static final String DEFAULT_WALK_TEXT = "Walk";
    private static int PROPERTY_INDEX = 0;
    private static int IMAGE_INDEX = 1;
    private static int TEXT_INDEX = 2;
    private static int MODE_INDEX = 3;
    private static final String[][] buttonData = new String[][]{{"FLY.button", "images/navigation/ButtonFly.gif", "Fly", "FLY"}, {"PAN.button", "images/navigation/ButtonPan.gif", "Pan", "xj3d_PAN"}, {"TILT.button", "images/navigation/ButtonTilt.gif", "Tilt", "xj3d_TILT"}, {"WALK.button", "images/navigation/ButtonWalk.gif", "Walk", "WALK"}, {"EXAMINE.button", "images/navigation/ButtonExamine.gif", "Examine", "EXAMINE"}};
    private static final int TRANSITION_TRUE = 1;
    private static final int TRANSITION_NONE = 0;
    private static final int TRANSITION_FALSE = -1;
    private ErrorReporter errorReporter;
    private String[] navigationModes;
    private Button[] button;
    private Display display;
    private int[] enabledTransition;
    private int[] selectionTransition;
    private BrowserCore browserCore;

    public NavigationToolbar(Composite composite, BrowserCore browserCore, ErrorReporter errorReporter) {
        this(composite, browserCore, true, errorReporter);
    }

    public NavigationToolbar(Composite composite, BrowserCore browserCore, boolean bl, ErrorReporter errorReporter) {
        this(composite, browserCore, bl, null, errorReporter);
    }

    public NavigationToolbar(Composite composite, BrowserCore browserCore, Properties properties, ErrorReporter errorReporter) {
        this(composite, browserCore, true, properties, errorReporter);
    }

    public NavigationToolbar(Composite composite, BrowserCore browserCore, boolean bl, Properties properties, ErrorReporter errorReporter) {
        super(composite, 0);
        this.browserCore = browserCore;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        Properties properties2 = properties == null ? DEFAULT_PROPERTIES : properties;
        this.browserCore.addNavigationStateListener((NavigationStateListener)this);
        int n = buttonData.length;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = bl ? n : 1;
        super.setLayout((Layout)gridLayout);
        this.button = new Button[n];
        this.display = this.getDisplay();
        for (int i = 0; i < n; ++i) {
            String string = buttonData[i][TEXT_INDEX];
            String string2 = properties2.getProperty(buttonData[i][PROPERTY_INDEX], buttonData[i][IMAGE_INDEX]);
            Image image = ImageLoader.loadImage(this.display, string2, errorReporter);
            Button button = new Button((Composite)this, 2);
            if (image == null) {
                button.setText(string);
            } else {
                button.setImage(image);
            }
            button.setToolTipText(string);
            button.addSelectionListener((SelectionListener)this);
            button.setEnabled(false);
            this.button[i] = button;
        }
        this.enabledTransition = new int[n];
        this.selectionTransition = new int[n];
    }

    public void setLayout(Layout layout) {
    }

    public void navigationStateChanged(int n) {
        if (this.navigationModes != null) {
            String string = this.navigationModes[n];
            for (int i = 0; i < this.button.length; ++i) {
                this.selectionTransition[i] = string.equalsIgnoreCase(buttonData[i][MODE_INDEX]) ? 1 : -1;
            }
            this.display.asyncExec((Runnable)this);
        }
    }

    public void navigationListChanged(String[] stringArray, int n) {
        int n2;
        if (this.navigationModes == null || this.navigationModes.length != n) {
            this.navigationModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navigationModes, 0, n);
        boolean bl = false;
        for (int i = 0; i < this.button.length; ++i) {
            this.enabledTransition[i] = -1;
        }
        block1: for (n2 = 0; n2 < n; ++n2) {
            if (stringArray[n2].equals("ANY")) {
                bl = true;
                break;
            }
            String string = stringArray[n2];
            for (int i = 0; i < this.button.length; ++i) {
                if (!string.equals(buttonData[i][MODE_INDEX])) continue;
                this.enabledTransition[i] = 1;
                continue block1;
            }
        }
        if (bl) {
            for (n2 = 0; n2 < this.button.length; ++n2) {
                this.enabledTransition[n2] = 1;
            }
        }
        this.display.asyncExec((Runnable)this);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Button button = (Button)selectionEvent.getSource();
        String string = "NONE";
        for (int i = 0; i < this.button.length; ++i) {
            if (button == this.button[i]) {
                string = buttonData[i][MODE_INDEX];
                continue;
            }
            this.button[i].setSelection(false);
        }
        this.browserCore.setNavigationMode(string);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void run() {
        for (int i = 0; i < this.button.length; ++i) {
            switch (this.enabledTransition[i]) {
                case -1: {
                    this.button[i].setEnabled(false);
                    break;
                }
                case 1: {
                    this.button[i].setEnabled(true);
                }
            }
            this.enabledTransition[i] = 0;
            switch (this.selectionTransition[i]) {
                case -1: {
                    this.button[i].setSelection(false);
                    break;
                }
                case 1: {
                    this.button[i].setSelection(true);
                }
            }
            this.selectionTransition[i] = 0;
        }
    }
}

