/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.VRMLParseException;

public class MessageBuffer
implements Runnable,
ErrorHandler {
    private static final String VERSION_MESSAGE_PREFIX = "Xj3D Version: ";
    private ArrayList buffer = new ArrayList();
    private int index;
    private HashSet ignoredExceptionTypes;
    private Locator docLocator;
    private Text text;
    private Display display;

    public MessageBuffer() {
        this.messageReport("Xj3D Version: 2_M1_DEV_2009-01-05\n");
        this.ignoredExceptionTypes = new HashSet();
        this.ignoredExceptionTypes.add(InvalidFieldException.class);
        this.ignoredExceptionTypes.add(InvalidFieldFormatException.class);
        this.ignoredExceptionTypes.add(InvalidFieldValueException.class);
        this.ignoredExceptionTypes.add(FileNotFoundException.class);
        this.ignoredExceptionTypes.add(IOException.class);
        this.ignoredExceptionTypes.add(UnknownHostException.class);
        this.ignoredExceptionTypes.add(IllegalArgumentException.class);
        this.ignoredExceptionTypes.add(InvalidFieldConnectionException.class);
        this.ignoredExceptionTypes.add(VRMLParseException.class);
        this.ignoredExceptionTypes.add(UnsupportedComponentException.class);
        this.ignoredExceptionTypes.add(UnsupportedNodeException.class);
        this.ignoredExceptionTypes.add(UnsupportedProfileException.class);
        this.ignoredExceptionTypes.add(ClassNotFoundException.class);
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void warning(VRMLException vRMLException) throws VRMLException {
        this.warning(vRMLException.getMessage(), true);
    }

    public void error(VRMLException vRMLException) throws VRMLException {
        this.error(vRMLException.getMessage(), true);
    }

    public void fatalError(VRMLException vRMLException) throws VRMLException {
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        stringBuffer.append(" Line: ");
        stringBuffer.append(this.docLocator.getLineNumber());
        stringBuffer.append(" Column: ");
        stringBuffer.append(this.docLocator.getColumnNumber());
        stringBuffer.append(" ");
        stringBuffer.append(vRMLException.getMessage());
        stringBuffer.append("\n");
        this.append(stringBuffer.toString());
        throw vRMLException;
    }

    public void partialReport(String string) {
        this.append(string);
    }

    public void messageReport(String string) {
        StringBuffer stringBuffer = new StringBuffer("Message: ");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        this.append(stringBuffer.toString());
    }

    public void warningReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.append(stringBuffer.toString());
    }

    public void errorReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.append(stringBuffer.toString());
    }

    public void fatalErrorReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.append(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.text != null) {
            ArrayList arrayList = this.buffer;
            synchronized (arrayList) {
                while (this.buffer.size() > this.index) {
                    this.text.append((String)this.buffer.get(this.index++));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        if (string != null) {
            ArrayList arrayList = this.buffer;
            synchronized (arrayList) {
                this.buffer.add(string);
                if (this.display != null) {
                    this.display.asyncExec((Runnable)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = this.buffer;
        synchronized (arrayList) {
            this.buffer.clear();
            this.index = 0;
        }
    }

    public void setTextWidget(Text text) {
        this.text = text;
        this.display = text == null ? null : text.getDisplay();
        this.index = 0;
    }

    public void redirectSystemMessages() {
    }

    private void warning(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (bl) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append("\n");
        this.append(stringBuffer.toString());
    }

    private void error(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (bl) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append("\n");
        this.append(stringBuffer.toString());
    }
}

