/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.ietf.uri.URL;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.InputSource;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.FramerateThrottle;
import org.xj3d.ui.swt.widgets.ImageLoader;
import org.xj3d.ui.swt.widgets.LoadURLAction;
import org.xj3d.ui.swt.widgets.OpenAction;
import org.xj3d.ui.swt.widgets.ReloadAction;

public class LocationToolbar
extends Composite
implements FileHandler,
BrowserCoreListener,
Runnable {
    private static final String FILE_IS_DIRECTORY_MESSAGE = "File is a directory";
    private static final String LOCATION_LABEL = " Location: ";
    private static final String GO_BUTTON_TEXT = " Go! ";
    private static final String GO_BUTTON_TOOLTIP_TEXT = "Go to the new location";
    private static final String OPEN_BUTTON_TEXT = "Open";
    private static final String OPEN_BUTTON_TOOLTIP_TEXT = "Open File";
    private static final String RELOAD_BUTTON_TEXT = "Reload";
    private static final String RELOAD_BUTTON_TOOLTIP_TEXT = "Reload current location";
    private static final Properties DEFAULT_SKIN = new Properties();
    private static final String GO_BUTTON_PROPERTY = "GO.button";
    private static final String OPEN_BUTTON_PROPERTY = "OPEN.button";
    private static final String RELOAD_BUTTON_PROPERTY = "RELOAD.button";
    private static final String DEFAULT_GO_BUTTON = "images/locationbar/goIcon32x32.gif";
    private static final String DEFAULT_OPEN_BUTTON = "images/locationbar/openIcon32x32.gif";
    private static final String DEFAULT_RELOAD_BUTTON = "images/locationbar/reloadIcon32x32.gif";
    private ErrorReporter errorReporter;
    private Text urlTextField;
    private Button locationGoButton;
    private Button openButton;
    private Button reloadButton;
    private Display display;
    private String contentDirectory;
    private BrowserCore browserCore;
    private WorldLoaderManager loader;
    private FramerateThrottle throttle;
    private String urlText;

    public LocationToolbar(Composite composite, BrowserCore browserCore, WorldLoaderManager worldLoaderManager, boolean bl, boolean bl2, boolean bl3, String string, ErrorReporter errorReporter) {
        this(composite, browserCore, worldLoaderManager, bl, bl2, bl3, string, null, errorReporter);
    }

    public LocationToolbar(Composite composite, BrowserCore browserCore, WorldLoaderManager worldLoaderManager, boolean bl, boolean bl2, boolean bl3, String string, Properties properties, ErrorReporter errorReporter) {
        super(composite, 0);
        SelectionListener selectionListener;
        GridData gridData;
        FontData[] fontDataArray;
        String string2;
        Composite composite2;
        this.loader = worldLoaderManager;
        this.browserCore = browserCore;
        if (this.browserCore != null) {
            this.browserCore.addCoreListener((BrowserCoreListener)this);
        }
        string = this.contentDirectory == null ? System.getProperty("user.dir") : this.contentDirectory;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        Properties properties2 = properties == null ? DEFAULT_SKIN : properties;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        int n = 1;
        if (bl2 | bl3) {
            ++n;
        }
        gridLayout.numColumns = n;
        super.setLayout((Layout)gridLayout);
        this.display = this.getDisplay();
        if (bl2 || bl3) {
            int n2 = 0;
            if (bl2) {
                ++n2;
            }
            if (bl3) {
                ++n2;
            }
            composite2 = new Composite((Composite)this, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.numColumns = n2;
            gridLayout.makeColumnsEqualWidth = true;
            composite2.setLayout((Layout)gridLayout);
            if (bl2) {
                string2 = properties.getProperty(OPEN_BUTTON_PROPERTY, DEFAULT_OPEN_BUTTON);
                fontDataArray = ImageLoader.loadImage(this.display, string2, errorReporter);
                this.openButton = new Button(composite2, 8);
                if (fontDataArray != null) {
                    this.openButton.setImage((Image)fontDataArray);
                } else {
                    this.openButton.setText(OPEN_BUTTON_TEXT);
                }
                this.openButton.setToolTipText(OPEN_BUTTON_TOOLTIP_TEXT);
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.verticalAlignment = 4;
                this.openButton.setLayoutData((Object)gridData);
            }
            if (bl3) {
                string2 = properties.getProperty(RELOAD_BUTTON_PROPERTY, DEFAULT_RELOAD_BUTTON);
                fontDataArray = ImageLoader.loadImage(this.display, string2, errorReporter);
                this.reloadButton = new Button(composite2, 8);
                if (fontDataArray != null) {
                    this.reloadButton.setImage((Image)fontDataArray);
                } else {
                    this.reloadButton.setText(RELOAD_BUTTON_TEXT);
                }
                this.reloadButton.setToolTipText(RELOAD_BUTTON_TOOLTIP_TEXT);
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.verticalAlignment = 4;
                this.reloadButton.setLayoutData((Object)gridData);
            }
        }
        Composite composite3 = new Composite((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        composite2 = new Label(composite3, 0);
        string2 = composite2.getFont();
        fontDataArray = string2.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setStyle(1);
        }
        Font font = new Font((Device)this.display, fontDataArray);
        composite2.setFont(font);
        composite2.setText(LOCATION_LABEL);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        composite2.setLayoutData((Object)gridData);
        this.urlTextField = new Text(composite3, 18436);
        this.urlTextField.setText(string);
        this.urlTextField.setEditable(!bl);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.urlTextField.setLayoutData((Object)gridData);
        String string3 = properties.getProperty(GO_BUTTON_PROPERTY, DEFAULT_GO_BUTTON);
        Image image = ImageLoader.loadImage(this.display, string3, errorReporter);
        this.locationGoButton = new Button(composite3, 8);
        if (image != null) {
            this.locationGoButton.setImage(image);
        } else {
            this.locationGoButton.setText(GO_BUTTON_TEXT);
        }
        this.locationGoButton.setEnabled(!bl);
        this.locationGoButton.setToolTipText(GO_BUTTON_TOOLTIP_TEXT);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        this.locationGoButton.setLayoutData((Object)gridData);
        if (!bl) {
            selectionListener = new LoadURLAction(this, this.urlTextField);
            this.locationGoButton.addSelectionListener(selectionListener);
            this.urlTextField.addSelectionListener(selectionListener);
        }
        if (bl3) {
            selectionListener = new ReloadAction(this, this.urlTextField);
            this.reloadButton.addSelectionListener(selectionListener);
        }
        if (bl2) {
            selectionListener = new OpenAction(composite.getShell(), this, this.contentDirectory);
            this.openButton.addSelectionListener(selectionListener);
        }
    }

    public void setLayout(Layout layout) {
    }

    public void run() {
        this.urlTextField.setText(this.urlText);
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        String string = vRMLScene.getLoadedURI();
        this.urlText = string == null ? "" : string;
        this.display.asyncExec((Runnable)this);
        this.errorReporter.messageReport("Main scene: " + this.urlText + " loaded.");
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void loadURL(String string) throws IOException {
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.errorReporter.errorReport(FILE_IS_DIRECTORY_MESSAGE, null);
            } else {
                string2 = file.toURL().toExternalForm();
            }
        } else {
            URL uRL = new URL(string);
            string2 = uRL.toExternalForm();
        }
        this.urlText = string2 == null ? "" : string2;
        this.display.asyncExec((Runnable)this);
        if (this.throttle != null) {
            this.throttle.startedLoading();
        }
        this.loader.queueLoadURL(new String[]{string2}, null);
    }

    public void loadURL(InputSource inputSource) throws IOException {
        this.loadURL(inputSource.getURL());
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.loader.setProgressListener(progressListener);
    }

    public void setThrottle(FramerateThrottle framerateThrottle) {
        this.throttle = framerateThrottle;
    }
}

