/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;

public class LoadURLAction
implements SelectionListener,
Runnable {
    private static final String ATTEMPTING_TO_LOAD_MESSAGE = "Attempting to load: ";
    private static final String INVALID_URL_MESSAGE = "Not a valid URL: ";
    private static final String UNABLE_TO_LOAD_MESSAGE = "Unable to load: ";
    private static final String OTHER_EXCEPTION_WHILE_LOADING_MESSAGE = "Unusual exception trying to load: ";
    private static final String FILE_IS_DIRECTORY_MESSAGE = "File is a directory";
    private FileHandler fileHandler;
    private ErrorReporter errorReporter;
    private Text urlText;
    private String urlToLoad;

    public LoadURLAction(FileHandler fileHandler, Text text) {
        this.fileHandler = fileHandler;
        this.errorReporter = this.fileHandler.getErrorReporter();
        this.urlText = text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.urlToLoad = this.urlText.getText();
        new Thread(this).start();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.urlToLoad = this.urlText.getText();
        new Thread(this).start();
    }

    public void run() {
        try {
            this.errorReporter.messageReport(ATTEMPTING_TO_LOAD_MESSAGE + this.urlToLoad);
            String string = null;
            File file = new File(this.urlToLoad);
            if (file.exists()) {
                if (file.isDirectory()) {
                    this.errorReporter.errorReport(FILE_IS_DIRECTORY_MESSAGE, null);
                } else {
                    string = file.toURL().toExternalForm();
                }
            } else {
                URL uRL = new URL(this.urlToLoad);
                string = uRL.toExternalForm();
            }
            this.fileHandler.loadURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorReporter.errorReport(INVALID_URL_MESSAGE, (Exception)malformedURLException);
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport(UNABLE_TO_LOAD_MESSAGE + this.urlToLoad, (Exception)iOException);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport(OTHER_EXCEPTION_WHILE_LOADING_MESSAGE + this.urlToLoad, exception);
        }
    }
}

