/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xj3d.ui.swt.widgets.StatusReporter;

public class LoadProgressListener
implements ProgressListener,
StatusReporter {
    private static final String MAIN_FILE_LOAD_MSG = "Main file downloading";
    private static final String MAIN_FILE_LOAD_COMPLETE_MSG = "Main file complete";
    private StatusReporter statusRep;
    private ErrorReporter errorRep;

    public LoadProgressListener(StatusReporter statusReporter, ErrorReporter errorReporter) {
        this.statusRep = statusReporter == null ? this : statusReporter;
        this.errorRep = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.statusRep.setStatusText(progressEvent.getMessage());
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.statusRep.setStatusText(progressEvent.getMessage());
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        this.statusRep.setStatusText(progressEvent.getMessage());
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            StringBuffer stringBuffer = new StringBuffer(uRI.toExternalForm());
            stringBuffer.append(" (");
            stringBuffer.append(progressEvent.getValue());
            stringBuffer.append(")");
            this.statusRep.setStatusText(stringBuffer.toString());
        } else {
            this.statusRep.setStatusText(MAIN_FILE_LOAD_MSG);
        }
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            String string = uRI.toExternalForm() + " complete.";
            this.statusRep.setStatusText(string);
            this.errorRep.messageReport(string);
        } else {
            this.statusRep.setStatusText(MAIN_FILE_LOAD_COMPLETE_MSG);
        }
    }

    public void downloadError(ProgressEvent progressEvent) {
        this.statusRep.setStatusText(progressEvent.getMessage());
        this.errorRep.errorReport(progressEvent.getMessage(), null);
    }

    public void setStatusText(String string) {
    }
}

