/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.web3d.util.ErrorReporter;

public class ImageLoader {
    private static final String IMAGE_FAIL_MSG = "Unable to locate the required image file ";
    private static final int DEFAULT_SIZE = 70;
    private static HashMap loadedImages = new HashMap(70);

    public static void initializeCache(Map map) {
        if (map != null) {
            for (String string : map.keySet()) {
                Object v = map.get(string);
                if (!(v instanceof Image)) continue;
                loadedImages.put(string, v);
            }
        }
    }

    public static Image loadImage(Display display, String string, ErrorReporter errorReporter) {
        if (string == null) {
            return null;
        }
        Image image = (Image)loadedImages.get(string);
        if (image == null) {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL != null) {
                try {
                    image = new Image((Device)display, uRL.openStream());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image == null && (uRL = ImageLoader.class.getClassLoader().getResource(string)) != null) {
                try {
                    image = new Image((Device)display, uRL.openStream());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image == null) {
                errorReporter.warningReport(IMAGE_FAIL_MSG + string, null);
            } else {
                loadedImages.put(string, image);
            }
        }
        return image;
    }

    public static void dispose() {
        for (Image image : loadedImages.values()) {
            image.dispose();
        }
        loadedImages.clear();
    }
}

