/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import java.util.HashMap;
import java.util.Properties;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.SimpleStack;
import org.xj3d.core.eventmodel.CursorFilter;
import org.xj3d.ui.swt.widgets.ImageLoader;

public class CursorManager
implements org.xj3d.core.eventmodel.CursorManager,
SensorStatusListener,
NavigationStateListener,
Runnable {
    private static final String NULL_CANVAS_MSG = "The canvas reference cannot be null";
    private static final String CURSOR_NOT_FOUND_ERR_MSG = "Cursor node not found";
    private static final String CURSOR_IMAGE_LOAD_FAILURE_MSG = "Unable to load cursor image: ";
    private static final String ANCHOR_CURSOR_PROPERTY = "anchor.cursor";
    private static final String DRAGSENSOR_CURSOR_PROPERTY = "dragSensor.cursor";
    private static final String EXAMINE_CURSOR_PROPERTY = "EXAMINE.cursor";
    private static final String LOOKAT_CURSOR_PROPERTY = "LOOKAT.cursor";
    private static final String FLY_CURSOR_PROPERTY = "FLY.cursor";
    private static final String PAN_CURSOR_PROPERTY = "PAN.cursor";
    private static final String TILT_CURSOR_PROPERTY = "TILT.cursor";
    private static final String TOUCHSENSOR_CURSOR_PROPERTY = "touchSensor.cursor";
    private static final String WALK_CURSOR_PROPERTY = "WALK.cursor";
    private static final String NONE_CURSOR_PROPERTY = "NONE.cursor";
    private static final String DEFAULT_ANCHOR_CURSOR_VALUE = "images/navigation/link.gif";
    private static final String DEFAULT_DRAGSENSOR_CURSOR_VALUE = "images/navigation/drag.gif";
    private static final String DEFAULT_EXAMINE_CURSOR_VALUE = "images/navigation/CursorExamine.gif";
    private static final String DEFAULT_LOOKAT_CURSOR_VALUE = "images/navigation/CursorLookat.gif";
    private static final String DEFAULT_FLY_CURSOR_VALUE = "images/navigation/CursorFly.gif";
    private static final String DEFAULT_PAN_CURSOR_VALUE = "images/navigation/CursorPan.gif";
    private static final String DEFAULT_TILT_CURSOR_VALUE = "images/navigation/CursorTilt.gif";
    private static final String DEFAULT_TOUCHSENSOR_CURSOR_VALUE = "images/navigation/CursorTarget.gif";
    private static final String DEFAULT_WALK_CURSOR_VALUE = "images/navigation/CursorWalk.gif";
    private static final String DEFAULT_NONE_CURSOR_VALUE = "images/navigation/CursorNone.gif";
    private static int ANCHOR_CURSOR_INDEX = 0;
    private static int DRAGSENSOR_CURSOR_INDEX = 1;
    private static int TOUCHSENSOR_CURSOR_INDEX = 2;
    private static int PROPERTY = 0;
    private static int VALUE = 1;
    private static String[][] SENSOR_DATA = new String[][]{{"anchor.cursor", "images/navigation/link.gif"}, {"dragSensor.cursor", "images/navigation/drag.gif"}, {"touchSensor.cursor", "images/navigation/CursorTarget.gif"}};
    private static String[][] NAVIGATION_DATA = new String[][]{{"WALK.cursor", "images/navigation/CursorWalk.gif"}, {"FLY.cursor", "images/navigation/CursorFly.gif"}, {"EXAMINE.cursor", "images/navigation/CursorExamine.gif"}, {"PAN.cursor", "images/navigation/CursorPan.gif"}, {"TILT.cursor", "images/navigation/CursorTilt.gif"}, {"LOOKAT.cursor", "images/navigation/CursorLookat.gif"}, {"NONE.cursor", "images/navigation/CursorNone.gif"}};
    private static String[] NAV_MODE = new String[]{"WALK", "FLY", "EXAMINE", "xj3d_PAN", "xj3d_TILT", "LOOKAT", "NONE"};
    private ErrorReporter errorReporter;
    private NavigationStateListener navListener;
    private Canvas canvas;
    private Cursor navStateCursor;
    private Cursor defaultCursor;
    private Cursor activeCursor;
    private Display display;
    private SimpleStack sensorStack;
    private Cursor[] sensorCursors;
    private HashMap navCursors;
    private String[] navModes;
    private CursorFilter filter;

    public CursorManager(Canvas canvas, ErrorReporter errorReporter) throws IllegalArgumentException {
        this(canvas, null, errorReporter);
    }

    public CursorManager(Canvas canvas, Properties properties, ErrorReporter errorReporter) throws IllegalArgumentException {
        if (canvas == null) {
            throw new IllegalArgumentException(NULL_CANVAS_MSG);
        }
        this.canvas = canvas;
        this.display = canvas.getDisplay();
        this.sensorCursors = new Cursor[SENSOR_DATA.length];
        this.navCursors = new HashMap();
        this.navModes = new String[0];
        this.sensorStack = new SimpleStack();
        this.navStateCursor = this.defaultCursor = new Cursor((Device)this.display, 2);
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        Properties properties2 = properties == null ? new Properties() : properties;
        this.loadCursors(properties2);
    }

    public void setCursorFilter(CursorFilter cursorFilter) {
        this.filter = cursorFilter;
        System.out.println("Filtering not implemented yet in SWT CursorManager");
    }

    public CursorFilter getCursorFilter() {
        return this.filter;
    }

    public void setCursor(String string, int n, int n2) {
        System.out.println("SetCursor not implemented in SWT CursorManager");
    }

    public void deviceOver(int n, String string) {
        switch (n) {
            case 0: {
                Cursor cursor = this.sensorCursors[ANCHOR_CURSOR_INDEX];
                this.sensorStack.push((Object)cursor);
                this.activeCursor = cursor;
                break;
            }
            case 1: {
                Cursor cursor = this.sensorCursors[TOUCHSENSOR_CURSOR_INDEX];
                this.sensorStack.push((Object)cursor);
                this.activeCursor = cursor;
                break;
            }
            case 2: {
                Cursor cursor = this.sensorCursors[DRAGSENSOR_CURSOR_INDEX];
                this.sensorStack.push((Object)cursor);
                this.activeCursor = cursor;
            }
        }
        this.display.asyncExec((Runnable)this);
    }

    public void deviceNotOver(int n) {
        this.sensorStack.pop();
        this.activeCursor = !this.sensorStack.isEmpty() ? (Cursor)this.sensorStack.peek() : this.navStateCursor;
        this.display.asyncExec((Runnable)this);
    }

    public void deviceActivated(int n) {
    }

    public void linkActivated(String[] stringArray, String[] stringArray2, String string) {
    }

    public void navigationStateChanged(int n) {
        Cursor cursor = (Cursor)this.navCursors.get(this.navModes[n]);
        if (cursor == null) {
            this.errorReporter.warningReport(CURSOR_NOT_FOUND_ERR_MSG, null);
            this.activeCursor = this.defaultCursor;
        } else {
            this.navStateCursor = cursor;
            this.activeCursor = cursor;
        }
        this.display.asyncExec((Runnable)this);
    }

    public void navigationListChanged(String[] stringArray, int n) {
        if (this.navModes.length != n) {
            this.navModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navModes, 0, n);
    }

    public void run() {
        if (this.activeCursor != null) {
            this.canvas.setCursor(this.activeCursor);
        }
    }

    public void resetCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public void dispose() {
        this.defaultCursor.dispose();
        for (int i = 0; i < this.sensorCursors.length; ++i) {
            Cursor cursor = this.sensorCursors[i];
            if (cursor.isDisposed()) continue;
            cursor.dispose();
        }
        Cursor[] cursorArray = new Cursor[this.navCursors.size()];
        cursorArray = this.navCursors.values().toArray(cursorArray);
        for (int i = 0; i < cursorArray.length; ++i) {
            Cursor cursor = cursorArray[i];
            if (cursor.isDisposed()) continue;
            cursor.dispose();
        }
    }

    private void loadCursors(Properties properties) {
        Cursor cursor;
        String string;
        int n;
        for (n = 0; n < SENSOR_DATA.length; ++n) {
            string = properties.getProperty(SENSOR_DATA[n][PROPERTY], SENSOR_DATA[n][VALUE]);
            cursor = this.getCursor(string);
            this.sensorCursors[n] = cursor == null ? this.defaultCursor : cursor;
        }
        for (n = 0; n < NAVIGATION_DATA.length; ++n) {
            string = properties.getProperty(NAVIGATION_DATA[n][PROPERTY], NAVIGATION_DATA[n][VALUE]);
            cursor = this.getCursor(string);
            if (cursor == null) {
                this.navCursors.put(NAV_MODE[n], this.defaultCursor);
                continue;
            }
            this.navCursors.put(NAV_MODE[n], cursor);
        }
    }

    private Cursor getCursor(String string) {
        Image image = ImageLoader.loadImage(this.display, string, this.errorReporter);
        if (image != null) {
            ImageData imageData = image.getImageData();
            int n = imageData.width / 2;
            int n2 = imageData.height / 2;
            return new Cursor((Device)this.display, imageData, n, n2);
        }
        this.errorReporter.warningReport(CURSOR_IMAGE_LOAD_FAILURE_MSG + string, null);
        return null;
    }
}

