/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.widgets;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xj3d.ui.swt.widgets.MessageBuffer;

public class ConsoleWindow
implements SelectionListener,
ShellListener,
DisposeListener,
Runnable {
    private static final String CONSOLE_TITLE = "Xj3D Console";
    private static final String CLEAR_BUTTON_LABEL = "Clear";
    private static final String CLEAR_TOOLTIP = "Clear the contents of the console";
    private static final String COPY_BUTTON_LABEL = "Copy";
    private static final String COPY_TOOLTIP = "Copy the contents of the window to the clipboard";
    private static final String VERSION_MESSAGE_PREFIX = "Xj3D Version: ";
    private Text text;
    private MessageBuffer messageBuffer;
    private Button clearButton;
    private Button copyButton;
    private Display display;
    private Shell parentShell;
    private Shell dialog;
    private Clipboard clipboard;
    private boolean doOpen;

    public ConsoleWindow(Shell shell, MessageBuffer messageBuffer) {
        if (shell == null) {
            throw new IllegalArgumentException("ConsoleWindow must have a valid parent");
        }
        if (messageBuffer == null) {
            throw new IllegalArgumentException("ConsoleWindow must have a valid MessageBuffer");
        }
        this.messageBuffer = messageBuffer;
        this.parentShell = shell;
        this.parentShell.addShellListener((ShellListener)this);
        this.display = shell.getDisplay();
        this.doOpen = true;
    }

    public void run() {
        if (this.doOpen) {
            if (this.dialog == null) {
                this.dialog = new Shell(this.display, 1264);
                this.dialog.setText(CONSOLE_TITLE);
                this.dialog.setLayout((Layout)new FormLayout());
                this.dialog.addDisposeListener((DisposeListener)this);
                this.clearButton = new Button((Composite)this.dialog, 8);
                this.clearButton.setText(CLEAR_BUTTON_LABEL);
                this.clearButton.setToolTipText(CLEAR_TOOLTIP);
                this.clearButton.addSelectionListener((SelectionListener)this);
                FormData formData = new FormData();
                formData.left = new FormAttachment(50, -5);
                formData.bottom = new FormAttachment(100, -5);
                this.clearButton.setLayoutData((Object)formData);
                this.copyButton = new Button((Composite)this.dialog, 8);
                this.copyButton.setText(COPY_BUTTON_LABEL);
                this.copyButton.setToolTipText(COPY_TOOLTIP);
                this.copyButton.addSelectionListener((SelectionListener)this);
                formData = new FormData();
                formData.right = new FormAttachment((Control)this.clearButton, -5);
                formData.bottom = new FormAttachment(100, -5);
                this.copyButton.setLayoutData((Object)formData);
                this.text = new Text((Composite)this.dialog, 2882);
                this.text.setEditable(false);
                formData = new FormData();
                formData.top = new FormAttachment(0, 5);
                formData.bottom = new FormAttachment((Control)this.clearButton, -5);
                formData.left = new FormAttachment(0, 5);
                formData.right = new FormAttachment(100, -5);
                this.text.setLayoutData((Object)formData);
                this.messageBuffer.setTextWidget(this.text);
                this.messageBuffer.run();
                this.dialog.setSize(600, 400);
                this.dialog.setLocation(80, 80);
            }
            this.dialog.open();
        } else if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.close();
            this.dialog = null;
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object == this.clearButton) {
            this.messageBuffer.clear();
            this.text.setText("");
        } else if (object == this.copyButton) {
            String string;
            if (this.clipboard == null) {
                this.clipboard = new Clipboard(this.display);
            }
            if ((string = this.text.getText()).length() > 0) {
                TextTransfer textTransfer = TextTransfer.getInstance();
                this.clipboard.setContents(new Object[]{string}, new Transfer[]{textTransfer});
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void shellActivated(ShellEvent shellEvent) {
    }

    public void shellClosed(ShellEvent shellEvent) {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.close();
            this.dialog = null;
        }
    }

    public void shellDeactivated(ShellEvent shellEvent) {
    }

    public void shellDeiconified(ShellEvent shellEvent) {
    }

    public void shellIconified(ShellEvent shellEvent) {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (!this.parentShell.isDisposed()) {
            this.parentShell.removeShellListener((ShellListener)this);
        }
        this.messageBuffer.setTextWidget(null);
        this.dialog = null;
    }

    public void open() {
        this.doOpen = true;
        this.display.asyncExec((Runnable)this);
    }

    public void close() {
        this.doOpen = false;
        this.display.asyncExec((Runnable)this);
    }
}

