/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;

public class LoadProgressListener
extends Job
implements ProgressListener,
Runnable {
    private static final String JOB_TITLE = "Loading";
    private static final String MAIN_FILE_LOAD_MSG = "Main file downloading";
    private static final String MAIN_FILE_LOAD_COMPLETE_MSG = "Main file complete";
    private ErrorReporter reporter;
    private IStatusLineManager status;
    private String msg;
    private IProgressMonitor monitor;
    private int contentSize;
    private int currentSize;
    private int lastReportedSize;
    private boolean loadInProgress;
    private boolean loadingMainFile;
    private IStatus loadStatus;
    private Display display;

    public LoadProgressListener(Display display, IStatusLineManager iStatusLineManager, ErrorReporter errorReporter) {
        super(JOB_TITLE);
        this.display = display;
        this.status = iStatusLineManager;
        this.reporter = errorReporter;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (URI.getScheme((String)resourceConnection.getURI().toExternalForm()).equals("file")) {
            this.loadInProgress = true;
            this.contentSize = resourceConnection.getContentLength();
            this.currentSize = 0;
        } else {
            this.contentSize = -1;
        }
        this.msg = progressEvent.getMessage();
        this.display.asyncExec((Runnable)this);
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.msg = progressEvent.getMessage();
        this.display.asyncExec((Runnable)this);
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        this.loadInProgress = true;
        this.contentSize = resourceConnection.getContentLength();
        this.currentSize = 0;
        this.schedule();
        this.msg = progressEvent.getMessage();
        this.display.asyncExec((Runnable)this);
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            if (this.monitor != null) {
                this.currentSize = progressEvent.getValue();
                this.wakeUp();
            } else {
                this.loadInProgress = true;
                this.contentSize = resourceConnection.getContentLength();
                this.currentSize = progressEvent.getValue();
                this.schedule();
            }
            URI uRI = resourceConnection.getURI();
            this.msg = uRI.toExternalForm();
            this.display.asyncExec((Runnable)this);
        } else if (this.loadingMainFile) {
            if (this.monitor != null) {
                this.currentSize = progressEvent.getValue();
                this.wakeUp();
            }
        } else {
            this.loadingMainFile = true;
            this.msg = MAIN_FILE_LOAD_MSG;
            this.display.asyncExec((Runnable)this);
            if (this.contentSize != -1) {
                this.currentSize = progressEvent.getValue();
                this.schedule();
            }
        }
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection;
        if (this.monitor != null) {
            this.loadInProgress = false;
            this.loadStatus = Status.OK_STATUS;
            this.wakeUp();
        }
        if ((resourceConnection = progressEvent.getSource()) != null) {
            URI uRI = resourceConnection.getURI();
            this.msg = uRI.toExternalForm() + " complete.";
            this.reporter.messageReport(this.msg);
            this.display.asyncExec((Runnable)this);
        } else {
            this.loadingMainFile = false;
            this.msg = MAIN_FILE_LOAD_COMPLETE_MSG;
            this.display.asyncExec((Runnable)this);
        }
    }

    public void downloadError(ProgressEvent progressEvent) {
        if (this.monitor != null) {
            this.loadInProgress = false;
            this.loadStatus = Status.OK_STATUS;
            this.wakeUp();
        }
        this.msg = progressEvent.getMessage();
        this.reporter.errorReport(this.msg, null);
        this.display.asyncExec((Runnable)this);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
        this.lastReportedSize = 0;
        this.monitor.beginTask(JOB_TITLE, this.contentSize);
        while (this.loadInProgress) {
            if (this.monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.currentSize > this.lastReportedSize) {
                this.monitor.worked(this.currentSize - this.lastReportedSize);
                this.lastReportedSize = this.currentSize;
            }
            this.sleep(250L);
        }
        this.monitor.done();
        this.monitor = null;
        return this.loadStatus;
    }

    public void run() {
        this.status.setMessage(this.msg);
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

