/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.view;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.vrml.nodes.VRMLScene;
import org.xj3d.ui.swt.widgets.Alarm;
import org.xj3d.ui.swt.widgets.AlarmEvent;
import org.xj3d.ui.swt.widgets.AlarmListener;

public class FrameRateContributionItem
extends ContributionItem
implements BrowserCoreListener,
DisposeListener,
AlarmListener,
Runnable {
    private static final int UPDATE_PERIOD_MILLIS = 500;
    private static final String FPS_TOOLTIP_TEXT = "Frames Per Second";
    private static final String PROTO = "00000.00000";
    private BrowserCore browserCore;
    private Alarm alarm;
    private Timer fpsTimer;
    private float lastFPS;
    private CLabel fpsLabel;
    private String fpsString;
    private Display display;

    public FrameRateContributionItem(String string, BrowserCore browserCore) {
        super(string);
        this.browserCore = browserCore;
        this.browserCore.addCoreListener((BrowserCoreListener)this);
        this.fpsTimer = new Timer();
        this.alarm = new Alarm();
        this.alarm.addAlarmListener(this);
        this.fpsTimer.schedule((TimerTask)this.alarm, 500L, 500L);
    }

    public void fill(Composite composite) {
        this.display = composite.getDisplay();
        Label label = new Label(composite, 2);
        this.fpsLabel = new CLabel(composite, 32);
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        Point point = gC.textExtent(PROTO);
        int n = point.x;
        int n2 = fontMetrics.getHeight();
        gC.dispose();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = n;
        statusLineLayoutData.heightHint = n2;
        this.fpsLabel.setLayoutData((Object)statusLineLayoutData);
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = n2;
        label.setLayoutData((Object)statusLineLayoutData);
        this.fpsLabel.setToolTipText(FPS_TOOLTIP_TEXT);
        this.fpsTimer = new Timer();
        this.alarm = new Alarm();
        this.alarm.addAlarmListener(this);
        this.fpsTimer.schedule((TimerTask)this.alarm, 500L, 500L);
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        this.deleteTimer();
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.deleteTimer();
    }

    public void alarmAction(AlarmEvent alarmEvent) {
        float f = this.browserCore.getCurrentFrameRate();
        if (!Float.isInfinite(f)) {
            if ((double)Math.abs(this.lastFPS - f) > 0.01) {
                int n = (int)f;
                int n2 = (int)((f -= (float)n) * 100000.0f);
                this.fpsString = n + "." + n2;
            }
        } else {
            this.fpsString = "            ";
        }
        if (this.fpsTimer != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)this);
        }
        this.lastFPS = f;
    }

    public void run() {
        if (this.fpsLabel != null && !this.fpsLabel.isDisposed()) {
            this.fpsLabel.setText(this.fpsString);
        }
    }

    private void deleteTimer() {
        if (this.alarm != null) {
            this.alarm.removeAlarmListener(this);
            this.alarm.cancel();
            this.alarm = null;
        }
        if (this.fpsTimer != null) {
            this.fpsTimer.cancel();
            this.fpsTimer = null;
        }
    }
}

