/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.view;

import java.util.HashMap;
import java.util.Properties;
import javax.media.opengl.GLCapabilities;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.event.ProgressListener;
import org.j3d.aviatrix3d.output.graphics.ElumensSWTSurface;
import org.j3d.aviatrix3d.output.graphics.SimpleSWTSurface;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.FramerateThrottle;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.ui.swt.device.SWTDeviceFactory;
import org.xj3d.ui.swt.view.FrameRateContributionItem;
import org.xj3d.ui.swt.view.LoadProgressListener;
import org.xj3d.ui.swt.widgets.ConsoleTool;
import org.xj3d.ui.swt.widgets.ConsoleWindow;
import org.xj3d.ui.swt.widgets.CursorManager;
import org.xj3d.ui.swt.widgets.ImageLoader;
import org.xj3d.ui.swt.widgets.LocationToolbar;
import org.xj3d.ui.swt.widgets.MessageBuffer;
import org.xj3d.ui.swt.widgets.NavigationToolbar;
import org.xj3d.ui.swt.widgets.StatusBar;
import org.xj3d.ui.swt.widgets.ViewpointToolbar;

public class BrowserView
extends ViewPart
implements BrowserComponent,
BrowserCoreListener,
ShellListener,
DisposeListener,
KeyListener,
IPartListener2 {
    private static final String INITIALIZATION_MSG = "Initializing SWT OpenGL X3D browser";
    private static final String PROPERTY_SETUP_ERR = "Error setting up system properties";
    private static final String WIREFRAME_RENDERING_MODE_MSG = "Wireframe rendering mode enabled";
    private static final String POINT_RENDERING_MODE_MSG = "Point rendering mode enabled";
    private static final String SHADED_RENDERING_MODE_MSG = "Shaded rendering mode disabled";
    private static final int A_KEY = 97;
    private static final int E_KEY = 101;
    private static final int F_KEY = 102;
    private static final int P_KEY = 112;
    private static final int W_KEY = 119;
    private static final int Z_KEY = 122;
    private static final int FRAME_PERIOD_VISIBLE = 0;
    private static final int FRAME_PERIOD_HIDDEN = 1000;
    private Composite surfaceComposite;
    private Shell shell;
    private Canvas glCanvas;
    private ViewpointManager viewpoint_manager;
    private CursorManager cursorManager;
    private ConsoleWindow console;
    private ViewpointToolbar vpToolbar;
    protected NavigationToolbar navToolbar;
    protected LocationToolbar locToolbar;
    protected StatusBar statusBar;
    private ProgressListener loadProgressListener;
    protected MessageBuffer messageBuffer;
    protected OGLBrowserCanvas mainCanvas;
    protected OGLStandardBrowserCore browserCore;
    private boolean wireframe;
    private boolean pointrender;
    private boolean elumensMode;
    private GLCapabilities caps;
    private int numSamples;
    private boolean maxChooserStarted;
    private IPartService partService;
    private boolean shellIsVisible;
    private boolean viewIsVisible;

    public void createPartControl(Composite composite) {
        Object object;
        IStatusLineManager iStatusLineManager;
        IActionBars iActionBars;
        GridData gridData;
        Composite composite2 = new Composite(composite, 0);
        composite2.addDisposeListener((DisposeListener)this);
        BrowserConfig browserConfig = new BrowserConfig(new HashMap());
        browserConfig.showOpenButton = true;
        browserConfig.showReloadButton = true;
        browserConfig.showStatusBar = true;
        browserConfig.showFPS = true;
        Properties properties = browserConfig.browserSkin == null ? new Properties() : browserConfig.browserSkin;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = null;
        if (browserConfig.showDash && browserConfig.dashTop || browserConfig.showUrl && browserConfig.urlTop || browserConfig.showDash && browserConfig.showUrl) {
            composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new FillLayout());
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            composite3.setLayoutData((Object)gridData);
            if (browserConfig.showDash && browserConfig.showUrl && browserConfig.dashTop == browserConfig.urlTop) {
                browserConfig.urlTop = true;
                browserConfig.dashTop = false;
            }
        }
        this.shell = composite.getShell();
        this.shell.addShellListener((ShellListener)this);
        this.shellIsVisible = true;
        this.viewIsVisible = true;
        this.messageBuffer = new MessageBuffer();
        this.messageBuffer.messageReport(INITIALIZATION_MSG);
        this.numSamples = 1;
        this.wireframe = false;
        this.pointrender = false;
        this.maxChooserStarted = false;
        this.caps = new GLCapabilities();
        this.caps.setDoubleBuffered(true);
        this.caps.setHardwareAccelerated(true);
        if (browserConfig.antialiased) {
            this.caps.setSampleBuffers(true);
            if (browserConfig.antialiasingQuality.equals("low")) {
                this.numSamples = 2;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("medium")) {
                this.messageBuffer.messageReport("Trying for 4 samples of antialiasing.");
                this.numSamples = 4;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("high")) {
                this.messageBuffer.messageReport("Trying for 8 samples of antialiasing.");
                this.numSamples = 8;
                this.caps.setNumSamples(this.numSamples);
            }
        }
        this.surfaceComposite = new Composite(composite2, 0);
        this.surfaceComposite.setLayout((Layout)new FillLayout());
        SimpleSWTSurface simpleSWTSurface = new SimpleSWTSurface(this.surfaceComposite, 0, this.caps);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.surfaceComposite.setLayoutData((Object)gridData);
        this.glCanvas = (Canvas)simpleSWTSurface.getSurfaceObject();
        this.glCanvas.addKeyListener((KeyListener)this);
        SWTDeviceFactory sWTDeviceFactory = new SWTDeviceFactory(this.glCanvas, "aviatrix3d", simpleSWTSurface, (ErrorReporter)this.messageBuffer);
        this.mainCanvas = new OGLBrowserCanvas((GraphicsOutputDevice)simpleSWTSurface, sWTDeviceFactory, browserConfig);
        this.mainCanvas.initialize();
        this.mainCanvas.setErrorReporter((ErrorReporter)this.messageBuffer);
        this.cursorManager = new CursorManager(this.glCanvas, properties, (ErrorReporter)this.messageBuffer);
        this.browserCore = this.mainCanvas.getUniverse();
        this.browserCore.addCoreListener(this);
        this.browserCore.addSensorStatusListener(this.cursorManager);
        this.browserCore.addNavigationStateListener(this.cursorManager);
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        WorldLoaderManager worldLoaderManager = this.mainCanvas.getWorldLoaderManager();
        this.viewpoint_manager = this.mainCanvas.getViewpointManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)this.browserCore, routeManager, frameStateManager, worldLoaderManager);
        vRML97ScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)this.browserCore, routeManager, frameStateManager, worldLoaderManager);
        javascriptScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.browserCore, this.viewpoint_manager, routeManager, frameStateManager, worldLoaderManager);
        javaSAIScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.browserCore, this.viewpoint_manager, routeManager, frameStateManager, worldLoaderManager);
        eCMAScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        scriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.browserCore, worldLoaderManager, browserConfig.textureQuality);
        this.console = new ConsoleWindow(this.shell, this.messageBuffer);
        if (browserConfig.showUrl) {
            if (browserConfig.urlTop) {
                this.locToolbar = new LocationToolbar(composite3, this.browserCore, worldLoaderManager, browserConfig.urlReadOnly, browserConfig.showOpenButton, browserConfig.showReloadButton, browserConfig.contentDirectory, properties, (ErrorReporter)this.messageBuffer);
            } else {
                this.locToolbar = new LocationToolbar(composite2, this.browserCore, worldLoaderManager, browserConfig.urlReadOnly, browserConfig.showOpenButton, browserConfig.showReloadButton, browserConfig.contentDirectory, properties, (ErrorReporter)this.messageBuffer);
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.grabExcessHorizontalSpace = true;
                this.locToolbar.setLayoutData(gridData);
            }
        }
        if (browserConfig.showDash) {
            if (browserConfig.dashTop) {
                iActionBars = new Composite(composite3, 0);
            } else {
                iActionBars = new Composite(composite2, 0);
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.grabExcessHorizontalSpace = true;
                iActionBars.setLayoutData((Object)gridData);
            }
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.numColumns = 3;
            gridLayout.makeColumnsEqualWidth = false;
            iActionBars.setLayout((Layout)gridLayout);
            this.navToolbar = new NavigationToolbar((Composite)iActionBars, (BrowserCore)this.browserCore, properties, (ErrorReporter)this.messageBuffer);
            gridData = new GridData();
            this.navToolbar.setLayoutData(gridData);
            iStatusLineManager = this.mainCanvas.getViewpointManager();
            this.vpToolbar = new ViewpointToolbar((Composite)iActionBars, this.browserCore, (ViewpointManager)iStatusLineManager, properties, (ErrorReporter)this.messageBuffer);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.vpToolbar.setLayoutData(gridData);
            object = new ConsoleTool((Composite)iActionBars, this.console, properties, this.messageBuffer);
        }
        if (browserConfig.showConsole) {
            this.console.open();
        }
        iActionBars = this.getViewSite().getActionBars();
        iStatusLineManager = iActionBars.getStatusLineManager();
        iStatusLineManager.add((IContributionItem)new FrameRateContributionItem("org.xj3d.ui.swt.view.FrameRateContributionItem", this.browserCore));
        iActionBars.updateActionBars();
        this.loadProgressListener = new LoadProgressListener(composite.getDisplay(), iStatusLineManager, (ErrorReporter)this.messageBuffer);
        ResourceConnection.addGlobalProgressListener((ProgressListener)this.loadProgressListener);
        worldLoaderManager.setProgressListener(this.loadProgressListener);
        if (this.locToolbar != null) {
            object = new FramerateThrottle((BrowserCore)this.browserCore, (ErrorReporter)this.messageBuffer);
            object.setScriptLoader(scriptLoader);
            object.setLoadManager(this.mainCanvas.getContentLoadManager());
            this.locToolbar.setThrottle((FramerateThrottle)object);
        }
        this.partService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
        this.partService.addPartListener((IPartListener2)this);
        this.mainCanvas.setEnabled(true);
    }

    public void setFocus() {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.keyCode;
        switch (keyEvent.stateMask) {
            case 0: {
                switch (n) {
                    case 0x1000006: {
                        this.viewpoint_manager.nextViewpoint();
                        break;
                    }
                    case 0x1000005: {
                        this.viewpoint_manager.previousViewpoint();
                        break;
                    }
                    case 0x1000007: {
                        this.viewpoint_manager.firstViewpoint();
                        break;
                    }
                    case 0x1000008: {
                        this.viewpoint_manager.lastViewpoint();
                    }
                }
                break;
            }
            case 65536: {
                if (n == 97) break;
                if (n == 112) {
                    boolean bl = this.pointrender = !this.pointrender;
                    if (this.pointrender) {
                        this.statusBar.setStatusText(POINT_RENDERING_MODE_MSG);
                        this.browserCore.setRenderingStyle(1);
                        break;
                    }
                    if (this.wireframe) {
                        this.statusBar.setStatusText(WIREFRAME_RENDERING_MODE_MSG);
                        this.browserCore.setRenderingStyle(2);
                        break;
                    }
                    this.statusBar.setStatusText(SHADED_RENDERING_MODE_MSG);
                    this.browserCore.setRenderingStyle(4);
                    break;
                }
                if (n == 119) {
                    boolean bl = this.wireframe = !this.wireframe;
                    if (this.wireframe) {
                        this.statusBar.setStatusText(WIREFRAME_RENDERING_MODE_MSG);
                        this.browserCore.setRenderingStyle(2);
                        break;
                    }
                    if (this.pointrender) {
                        this.statusBar.setStatusText(POINT_RENDERING_MODE_MSG);
                        this.browserCore.setRenderingStyle(1);
                        break;
                    }
                    this.statusBar.setStatusText(SHADED_RENDERING_MODE_MSG);
                    this.browserCore.setRenderingStyle(4);
                    break;
                }
                if (n != 122) break;
                this.resetSurface();
                break;
            }
            case 262144: {
                if (n == 101) {
                    this.browserCore.setNavigationMode("EXAMINE");
                    break;
                }
                if (n == 102) {
                    this.browserCore.setNavigationMode("FLY");
                    break;
                }
                if (n != 119) break;
                this.browserCore.setNavigationMode("WALK");
            }
        }
    }

    public void shellActivated(ShellEvent shellEvent) {
    }

    public void shellClosed(ShellEvent shellEvent) {
    }

    public void shellDeactivated(ShellEvent shellEvent) {
    }

    public void shellDeiconified(ShellEvent shellEvent) {
        this.shellIsVisible = true;
        this.configureThrottle();
    }

    public void shellIconified(ShellEvent shellEvent) {
        this.shellIsVisible = false;
        this.configureThrottle();
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.destroy();
        this.console.close();
        this.partService.removePartListener((IPartListener2)this);
        this.shell.removeShellListener((ShellListener)this);
        ImageLoader.dispose();
        this.cursorManager.dispose();
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Object getCanvas() {
        return this.glCanvas;
    }

    public int getRendererType() {
        return this.browserCore.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.browserCore;
    }

    public ErrorReporter getErrorReporter() {
        return this.messageBuffer;
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        this.mainCanvas.setMinimumFrameInterval(n, bl);
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        if (this.browserCore != null) {
            this.browserCore.dispose();
        }
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        this.browserCore = null;
        URI.setContentHandlerFactory(null);
        ResourceConnection.removeGlobalProgressListener((ProgressListener)this.loadProgressListener);
    }

    public void urlLoadFailed(String string) {
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        IViewReference iViewReference;
        if (iWorkbenchPartReference instanceof IViewReference && (iViewReference = (IViewReference)iWorkbenchPartReference).getView(false) == this) {
            this.viewIsVisible = false;
            this.configureThrottle();
        }
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        IViewReference iViewReference;
        if (iWorkbenchPartReference instanceof IViewReference && (iViewReference = (IViewReference)iWorkbenchPartReference).getView(false) == this) {
            this.viewIsVisible = true;
            this.configureThrottle();
        }
    }

    private void configureThrottle() {
        if (this.shellIsVisible && this.viewIsVisible) {
            this.mainCanvas.setMinimumFrameInterval(0, false);
            this.mainCanvas.enableRenderPipeline(true);
        } else {
            this.mainCanvas.setMinimumFrameInterval(1000, false);
            this.mainCanvas.enableRenderPipeline(false);
        }
    }

    private void resetSurface() {
        ElumensSWTSurface elumensSWTSurface;
        this.stop();
        this.glCanvas.removeKeyListener((KeyListener)this);
        this.glCanvas.dispose();
        if (this.elumensMode) {
            elumensSWTSurface = new ElumensSWTSurface(this.surfaceComposite, 0, this.caps);
            elumensSWTSurface.setNumberOfChannels(3);
            this.browserCore.setHardwareFOV(180.0f);
        } else {
            elumensSWTSurface = new SimpleSWTSurface(this.surfaceComposite, 0, this.caps);
            this.browserCore.setHardwareFOV(0.0f);
        }
        this.glCanvas = (Canvas)elumensSWTSurface.getSurfaceObject();
        SWTDeviceFactory sWTDeviceFactory = new SWTDeviceFactory(this.glCanvas, "aviatrix3d", elumensSWTSurface, (ErrorReporter)this.messageBuffer);
        this.mainCanvas.setSurface((GraphicsOutputDevice)elumensSWTSurface, sWTDeviceFactory);
        this.cursorManager.resetCanvas(this.glCanvas);
        this.glCanvas.addKeyListener((KeyListener)this);
        this.surfaceComposite.layout();
        this.start();
    }

    private void setupProperties(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, String string) {
        URIResourceStreamFactory uRIResourceStreamFactory;
        Object object;
        ContentHandlerFactory contentHandlerFactory;
        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
        try {
            contentHandlerFactory = Class.forName("vlc.net.content.image.ImageDecoder");
            object = contentHandlerFactory.newInstance();
            System.setProperty("java.content.handler.pkgs", "vlc.net.content");
        }
        catch (Throwable throwable) {
            this.messageBuffer.warningReport("Image loaders not available", null);
        }
        contentHandlerFactory = URI.getContentHandlerFactory();
        if (!(contentHandlerFactory instanceof VRMLContentHandlerFactory)) {
            contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
            URI.setContentHandlerFactory((ContentHandlerFactory)contentHandlerFactory);
        }
        if (!((object = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
            object = new VRMLFileNameMap(object);
            URI.setFileNameMap(object);
        }
        if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
            uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
            URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
        }
        if (string.equals("medium")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
        } else if (string.equals("high")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
        }
    }
}

