/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.util.MathUtils;

public class ImageUtils {
    private boolean imageScaleUp = false;
    private int maxTextureSize = -1;
    private boolean useMipMaps = true;

    public ImageUtils() {
    }

    public ImageUtils(boolean bl, boolean bl2, int n) {
        int n2;
        this.imageScaleUp = bl;
        this.useMipMaps = bl2;
        if (n != -1 && n != (n2 = MathUtils.nearestPowerTwo((int)n, (boolean)false))) {
            n = n2;
        }
        this.maxTextureSize = n;
    }

    public NIOBufferImage toNIOBufferImage(ImageData imageData) {
        int n = imageData.height;
        int n2 = imageData.width;
        PaletteData paletteData = imageData.palette;
        ByteBuffer byteBuffer = null;
        NIOBufferImageType nIOBufferImageType = null;
        boolean bl = true;
        int n3 = imageData.getTransparencyType();
        if (n3 != 0) {
            nIOBufferImageType = NIOBufferImageType.RGBA;
            byteBuffer = ByteBuffer.allocateDirect(n2 * n * nIOBufferImageType.size);
            byteBuffer.order(ByteOrder.nativeOrder());
            int[] nArray = new int[n2];
            if (paletteData.isDirect) {
                if (n3 == 4) {
                    int n4 = imageData.transparentPixel;
                    int n5 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        imageData.getPixels(0, n5, n2, nArray, 0);
                        for (int j = 0; j < n2; ++j) {
                            int n6 = nArray[j];
                            RGB rGB = paletteData.getRGB(n6);
                            if (bl) {
                                bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                            }
                            byteBuffer.put((byte)rGB.red);
                            byteBuffer.put((byte)rGB.green);
                            byteBuffer.put((byte)rGB.blue);
                            byte by = n6 == n4 ? (byte)0 : -1;
                            byteBuffer.put(by);
                        }
                        --n5;
                    }
                } else if (imageData.alpha == -1) {
                    byte[] byArray = new byte[n2];
                    int n7 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        imageData.getAlphas(0, n7, n2, byArray, 0);
                        imageData.getPixels(0, n7, n2, nArray, 0);
                        for (int j = 0; j < n2; ++j) {
                            RGB rGB = paletteData.getRGB(nArray[j]);
                            if (bl) {
                                bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                            }
                            byteBuffer.put((byte)rGB.red);
                            byteBuffer.put((byte)rGB.green);
                            byteBuffer.put((byte)rGB.blue);
                            byteBuffer.put(byArray[j]);
                        }
                        --n7;
                    }
                } else {
                    byte by = (byte)imageData.alpha;
                    int n8 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        imageData.getPixels(0, n8, n2, nArray, 0);
                        for (int j = 0; j < n2; ++j) {
                            RGB rGB = paletteData.getRGB(nArray[j]);
                            if (bl) {
                                bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                            }
                            byteBuffer.put((byte)rGB.red);
                            byteBuffer.put((byte)rGB.green);
                            byteBuffer.put((byte)rGB.blue);
                            byteBuffer.put(by);
                        }
                        --n8;
                    }
                }
            } else {
                int n9 = imageData.transparentPixel;
                int n10 = n - 1;
                for (int i = 0; i < n; ++i) {
                    imageData.getPixels(0, n10, n2, nArray, 0);
                    for (int j = 0; j < n2; ++j) {
                        int n11 = nArray[j];
                        RGB rGB = paletteData.getRGB(n11);
                        if (bl) {
                            bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                        }
                        byteBuffer.put((byte)rGB.red);
                        byteBuffer.put((byte)rGB.green);
                        byteBuffer.put((byte)rGB.blue);
                        byte by = n11 == n9 ? (byte)0 : -1;
                        byteBuffer.put(by);
                    }
                    --n10;
                }
            }
        } else {
            nIOBufferImageType = NIOBufferImageType.RGB;
            byteBuffer = ByteBuffer.allocateDirect(n2 * n * nIOBufferImageType.size);
            byteBuffer.order(ByteOrder.nativeOrder());
            int[] nArray = new int[n2];
            if (paletteData.isDirect) {
                int n12 = n - 1;
                for (int i = 0; i < n; ++i) {
                    imageData.getPixels(0, n12, n2, nArray, 0);
                    for (int j = 0; j < n2; ++j) {
                        RGB rGB = paletteData.getRGB(nArray[j]);
                        if (bl) {
                            bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                        }
                        byteBuffer.put((byte)rGB.red);
                        byteBuffer.put((byte)rGB.green);
                        byteBuffer.put((byte)rGB.blue);
                    }
                    --n12;
                }
            } else {
                int n13 = n - 1;
                for (int i = 0; i < n; ++i) {
                    imageData.getPixels(0, n13, n2, nArray, 0);
                    for (int j = 0; j < n2; ++j) {
                        int n14 = nArray[j];
                        RGB rGB = paletteData.getRGB(n14);
                        if (bl) {
                            bl = rGB.red == rGB.green | rGB.green == rGB.blue;
                        }
                        byteBuffer.put((byte)rGB.red);
                        byteBuffer.put((byte)rGB.green);
                        byteBuffer.put((byte)rGB.blue);
                    }
                    --n13;
                }
            }
        }
        return new NIOBufferImage(n2, n, nIOBufferImageType, bl, byteBuffer);
    }

    public ImageData[] preprocess(ImageData imageData) {
        ImageData[] imageDataArray;
        int n = imageData.width;
        int n2 = imageData.height;
        int n3 = MathUtils.nearestPowerTwo((int)n, (boolean)this.imageScaleUp);
        int n4 = MathUtils.nearestPowerTwo((int)n2, (boolean)this.imageScaleUp);
        if (this.maxTextureSize > 0) {
            float f;
            if (n3 == n4) {
                if (n3 > this.maxTextureSize) {
                    f = (float)this.maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n3 > n4) {
                if (n3 > this.maxTextureSize) {
                    f = (float)this.maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n4 > this.maxTextureSize) {
                f = (float)this.maxTextureSize / (float)n4;
                n3 = (int)(f * (float)n3);
                n4 = (int)(f * (float)n4);
            }
        }
        if (n != n3 || n2 != n4) {
            imageData = this.scale(imageData, n3, n4);
        }
        if (this.useMipMaps) {
            boolean bl = false;
            int n5 = Math.max(MathUtils.computeLog((int)n3), MathUtils.computeLog((int)n4)) + 1;
            imageDataArray = new ImageData[n5];
            imageDataArray[0] = imageData;
            for (int i = 1; i < n5; ++i) {
                if (n3 > 1) {
                    n3 >>= 1;
                }
                if (n4 > 1) {
                    n4 >>= 1;
                }
                imageDataArray[i] = this.scale(imageData, n3, n4);
            }
        } else {
            imageDataArray = new ImageData[]{imageData};
        }
        return imageDataArray;
    }

    public NIOBufferImage consolidate(ImageData[] imageDataArray) {
        NIOBufferImage nIOBufferImage = null;
        if (imageDataArray != null && imageDataArray[0] != null) {
            nIOBufferImage = this.toNIOBufferImage(imageDataArray[0]);
            int n = imageDataArray.length;
            if (n > 1) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[n];
                byteBufferArray[0] = nIOBufferImage.getBuffer();
                for (int i = 1; i < n; ++i) {
                    NIOBufferImage nIOBufferImage2 = this.toNIOBufferImage(imageDataArray[i]);
                    byteBufferArray[i] = nIOBufferImage2.getBuffer();
                }
                nIOBufferImage.setBuffer(byteBufferArray);
            }
        }
        return nIOBufferImage;
    }

    public ImageData scale(ImageData imageData, int n, int n2) {
        if (n != imageData.width && n2 != imageData.height) {
            return imageData.scaledTo(n, n2);
        }
        return imageData;
    }
}

