/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.device.ogl.mouse;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.xj3d.device.Tracker;
import org.xj3d.device.TrackerState;

public class MouseTracker
extends Tracker
implements MouseListener,
MouseMoveListener,
Listener {
    private static final int mask = 14;
    private final String deviceId;
    private TrackerState[] tstate;
    private int currentIndex;
    private int lastIndex;
    private Vector3f mousePickDirection;
    private Point3f mouseEyePosition;
    private Point3f mousePosition;
    private Matrix4f surfaceTransform;
    private GraphicsOutputDevice surface;
    private int lastMouseX;
    private int lastMouseY;

    public MouseTracker(GraphicsOutputDevice graphicsOutputDevice, String string) {
        this.surface = graphicsOutputDevice;
        this.deviceId = string;
        this.mousePickDirection = new Vector3f();
        this.mouseEyePosition = new Point3f();
        this.mousePosition = new Point3f();
        this.surfaceTransform = new Matrix4f();
        this.currentIndex = 0;
        this.lastIndex = 1;
        this.tstate = new TrackerState[2];
        this.tstate[0] = new TrackerState();
        this.tstate[0].numButtons = 3;
        this.tstate[0].buttonMode[0] = 10;
        this.tstate[0].pickingEnabled[0] = true;
        this.tstate[0].buttonMode[1] = 0;
        this.tstate[0].pickingEnabled[1] = false;
        this.tstate[0].buttonMode[2] = 10;
        this.tstate[0].pickingEnabled[2] = false;
        this.tstate[1] = new TrackerState();
        this.tstate[1].numButtons = 3;
        this.tstate[1].buttonMode[0] = 10;
        this.tstate[1].pickingEnabled[0] = true;
        this.tstate[1].buttonMode[1] = 0;
        this.tstate[1].pickingEnabled[1] = false;
        this.tstate[1].buttonMode[2] = 10;
        this.tstate[1].pickingEnabled[2] = false;
    }

    public int getActionMask() {
        return 14;
    }

    public void beginPolling() {
        if (this.currentIndex == 0) {
            this.currentIndex = 1;
            this.lastIndex = 0;
        } else {
            this.currentIndex = 0;
            this.lastIndex = 1;
        }
    }

    public void endPolling() {
        if (this.tstate[this.currentIndex].actionType != 0) {
            this.tstate[this.lastIndex].actionType = 0;
        } else {
            this.tstate[this.currentIndex].actionType = 0;
            this.tstate[this.lastIndex].actionType = 0;
        }
    }

    public void getState(int n, int n2, TrackerState trackerState) {
        trackerState.actionMask = 14;
        trackerState.actionType = this.tstate[this.lastIndex].actionType;
        trackerState.devicePos[0] = this.tstate[this.lastIndex].devicePos[0];
        trackerState.devicePos[1] = this.tstate[this.lastIndex].devicePos[1];
        trackerState.devicePos[2] = this.tstate[this.lastIndex].devicePos[2];
        trackerState.deviceOri[0] = 0.0f;
        trackerState.deviceOri[1] = 0.0f;
        trackerState.deviceOri[2] = 0.0f;
        this.transformMouse(n, n2, trackerState);
        trackerState.numButtons = this.tstate[this.lastIndex].numButtons;
        for (int i = 0; i < this.tstate[this.lastIndex].numButtons; ++i) {
            trackerState.buttonMode[i] = this.tstate[this.lastIndex].buttonMode[i];
            trackerState.buttonState[i] = this.tstate[this.lastIndex].buttonState[i];
            trackerState.pickingEnabled[i] = this.tstate[this.lastIndex].pickingEnabled[i];
        }
        trackerState.wheelClicks = this.tstate[this.lastIndex].wheelClicks;
    }

    public void mouseDown(MouseEvent mouseEvent) {
        switch (mouseEvent.button) {
            case 1: {
                this.tstate[this.currentIndex].buttonState[0] = true;
                break;
            }
            case 2: {
                this.tstate[this.currentIndex].buttonState[1] = true;
                break;
            }
            case 3: {
                this.tstate[this.currentIndex].buttonState[2] = true;
            }
        }
        this.updateMouseDetails(mouseEvent);
        this.tstate[this.currentIndex].actionType = 2;
    }

    public void mouseUp(MouseEvent mouseEvent) {
        switch (mouseEvent.button) {
            case 1: {
                this.tstate[this.currentIndex].buttonState[0] = false;
                break;
            }
            case 2: {
                this.tstate[this.currentIndex].buttonState[1] = false;
                break;
            }
            case 3: {
                this.tstate[this.currentIndex].buttonState[2] = false;
            }
        }
        this.tstate[this.currentIndex].actionType = this.tstate[this.currentIndex].actionType == 2 ? 8 : 16;
        this.updateMouseDetails(mouseEvent);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
            if (this.tstate[this.currentIndex].actionType == 0 || this.tstate[this.currentIndex].actionType == 4) {
                this.updateMouseDetails(mouseEvent);
                this.tstate[this.currentIndex].actionType = 4;
            }
        } else if (this.tstate[this.currentIndex].actionType == 0 || this.tstate[this.currentIndex].actionType == 32) {
            this.updateMouseDetails(mouseEvent);
            this.tstate[this.currentIndex].actionType = 32;
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 37: {
                this.tstate[this.currentIndex].wheelClicks = -(event.count / 3);
                this.tstate[this.currentIndex].actionType = 256;
            }
        }
    }

    private void updateMouseDetails(MouseEvent mouseEvent) {
        Control control = (Control)mouseEvent.widget;
        Point point = control.getSize();
        float f = point.y - 1;
        float f2 = point.x - 1;
        this.lastMouseX = mouseEvent.x;
        this.lastMouseY = mouseEvent.y;
        this.tstate[this.currentIndex].devicePos[0] = (float)this.lastMouseX / f2;
        this.tstate[this.currentIndex].devicePos[1] = (float)this.lastMouseY / f;
        this.tstate[this.currentIndex].devicePos[2] = 0.0f;
        this.lastMouseY = (int)(f - (float)this.lastMouseY);
    }

    private void transformMouse(int n, int n2, TrackerState trackerState) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = this.tstate[this.lastIndex].actionType == 4;
        if (!this.surface.getSurfaceToVWorld(this.lastMouseX, this.lastMouseY, n, n2, this.surfaceTransform, "mouse", bl)) {
            bl2 = false;
        }
        if (!this.surface.getCenterEyeInSurface(this.lastMouseX, this.lastMouseY, n, n2, this.mouseEyePosition, "mouse", bl)) {
            bl2 = false;
        }
        if (!this.surface.getPixelLocationInSurface(this.lastMouseX, this.lastMouseY, n, n2, this.mousePosition, "mouse", bl)) {
            bl2 = false;
        }
        if (!bl2) {
            trackerState.actionMask = 0;
            return;
        }
        this.mousePickDirection.sub((Tuple3f)this.mousePosition, (Tuple3f)this.mouseEyePosition);
        this.surfaceTransform.transform(this.mousePosition);
        this.surfaceTransform.transform(this.mousePickDirection);
        trackerState.worldPos[0] = this.mousePosition.x;
        trackerState.worldPos[1] = this.mousePosition.y;
        trackerState.worldPos[2] = this.mousePosition.z;
        trackerState.worldOri[0] = this.mousePickDirection.x;
        trackerState.worldOri[1] = this.mousePickDirection.y;
        trackerState.worldOri[2] = this.mousePickDirection.z;
    }
}

