/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.device;

import java.util.List;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.util.KeySensorDevice;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.device.DeviceManager;
import org.xj3d.device.InputDevice;
import org.xj3d.ui.swt.device.SWTKeySensorDevice;

public class SWTDeviceFactory
extends DeviceFactory {
    public SWTDeviceFactory(Object object, String string, Object object2, ErrorReporter errorReporter) {
        if (!(object instanceof Control)) {
            throw new IllegalArgumentException("canvas object is not a subclass of org.eclipse.swt.Control");
        }
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.toolkitID = "swt";
        this.canvas = object;
        this.rendererID = string;
        this.surface = object2;
    }

    public DeviceManager[] getDeviceManagers() {
        List list = this.createDevices();
        DeviceManager[] deviceManagerArray = list.toArray(new DeviceManager[list.size()]);
        Control control = (Control)this.canvas;
        for (int i = 0; i < deviceManagerArray.length; ++i) {
            InputDevice[] inputDeviceArray = deviceManagerArray[i].getDevices();
            for (int j = 0; j < inputDeviceArray.length; ++j) {
                InputDevice inputDevice = inputDeviceArray[j];
                if (inputDevice instanceof MouseListener) {
                    control.addMouseListener((MouseListener)inputDevice);
                }
                if (inputDevice instanceof MouseMoveListener) {
                    control.addMouseMoveListener((MouseMoveListener)inputDevice);
                }
                if (inputDevice instanceof Listener) {
                    control.addListener(37, (Listener)inputDevice);
                }
                if (!(inputDevice instanceof KeyListener)) continue;
                control.addKeyListener((KeyListener)inputDevice);
            }
        }
        return deviceManagerArray;
    }

    public KeySensorDevice getKeySensorDevice() {
        SWTKeySensorDevice sWTKeySensorDevice = new SWTKeySensorDevice();
        Control control = (Control)this.canvas;
        control.addKeyListener((KeyListener)sWTKeySensorDevice);
        return sWTKeySensorDevice;
    }
}

