/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.swt.browser.ogl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.browser.BrowserCore;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.X3DComponent;
import org.xj3d.core.eventmodel.CursorManager;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.FramerateThrottle;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.ui.swt.browser.ogl.BrowserComposite;

public class X3DBrowserComposite
extends BrowserComposite
implements X3DComponent {
    private static final String PROPERTY_SETUP_ERR = "Error setting up system properties in X3DBrowserComposite";
    private SAIBrowser saiBrowser;

    public X3DBrowserComposite(Composite composite, ViewPart viewPart, BrowserConfig browserConfig) {
        super(composite, viewPart, browserConfig);
        this.setupProperties();
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        WorldLoaderManager worldLoaderManager = this.mainCanvas.getWorldLoaderManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        javaSAIScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        eCMAScriptEngine.setErrorReporter((ErrorReporter)this.messageBuffer);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        x3DCommonBrowser.setErrorReporter((ErrorReporter)this.messageBuffer);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.messageBuffer);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.browserCore, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, (CursorManager)this.cursorManager, (ErrorReporter)this.messageBuffer);
        if (this.locToolbar != null) {
            FramerateThrottle framerateThrottle = new FramerateThrottle((BrowserCore)this.browserCore, (ErrorReporter)this.messageBuffer);
            framerateThrottle.setScriptLoader(scriptLoader);
            framerateThrottle.setLoadManager(this.mainCanvas.getContentLoadManager());
            this.locToolbar.setThrottle(framerateThrottle);
        }
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        try {
            this.saiBrowser.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.browserCore != null) {
            this.browserCore.dispose();
        }
    }

    private void setupProperties() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    URIResourceStreamFactory uRIResourceStreamFactory = URI.getURIResourceStreamFactory();
                    if (!(uRIResourceStreamFactory instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.messageBuffer.warningReport(PROPERTY_SETUP_ERR, null);
        }
    }
}

