/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct.ogl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.vrml.nodes.VRMLScene;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.ui.construct.ogl.OGLConstruct;

public class ShutdownManager
implements Runnable,
BrowserCoreListener {
    private static final String LOG_NAME = "ShutdownManager";
    protected OGLConstruct construct;
    protected Thread shutdownThread;

    public ShutdownManager(OGLConstruct oGLConstruct) {
        if (oGLConstruct == null) {
            throw new IllegalArgumentException("ShutdownManager: construct instance must be non-null");
        }
        this.construct = oGLConstruct;
        this.shutdownThread = new Thread((Runnable)this, "Xj3D Shutdown Thread");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(ShutdownManager.this.shutdownThread);
                return null;
            }
        });
        oGLConstruct.core.addCoreListener(this);
    }

    public void run() {
        this.shutdown(true);
    }

    public void browserShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browserDisposed() {
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            if (this.shutdownThread != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Runtime runtime = Runtime.getRuntime();
                        runtime.removeShutdownHook(ShutdownManager.this.shutdownThread);
                        return null;
                    }
                });
                this.shutdownThread = null;
            }
        }
        this.construct.renderManager.disableInternalShutdown();
        this.shutdown(false);
    }

    public void urlLoadFailed(String string) {
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    protected void shutdown(boolean bl) {
        this.construct.getContentLoadManager().shutdown();
        ScriptLoader scriptLoader = this.construct.getScriptLoader();
        if (scriptLoader != null) {
            scriptLoader.shutdown();
        }
        this.construct.getEventModelEvaluator().shutdown();
        if (!bl) {
            this.construct.renderManager.shutdown();
        }
    }
}

