/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct.ogl;

import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.RenderManager;
import org.j3d.aviatrix3d.output.audio.OpenALAudioDevice;
import org.j3d.aviatrix3d.pipeline.RenderPipeline;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullStage;
import org.j3d.aviatrix3d.pipeline.audio.AudioOutputDevice;
import org.j3d.aviatrix3d.pipeline.audio.AudioRenderPipeline;
import org.j3d.aviatrix3d.pipeline.audio.AudioSortStage;
import org.j3d.aviatrix3d.pipeline.audio.DefaultAudioPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.DefaultGraphicsPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRenderPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsSortStage;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.renderer.ogl.OGLSceneBuilderFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.ui.construct.Construct;

public abstract class OGLConstruct
extends Construct {
    protected String RENDER_MANAGER = "org.j3d.aviatrix3d.management.SingleThreadRenderManager";
    protected String DISPLAY_MANAGER = "org.j3d.aviatrix3d.management.SingleDisplayCollection";
    protected String AUDIO_PIPELINE = "org.j3d.aviatrix3d.pipeline.audio.DefaultAudioPipeline";
    protected String AUDIO_SORT_STAGE = "org.j3d.aviatrix3d.pipeline.audio.NullAudioSortStage";
    protected String AUDIO_CULL_STAGE = "org.j3d.aviatrix3d.pipeline.audio.NullAudioCullStage";
    protected String GRAPHICS_PIPELINE = "org.j3d.aviatrix3d.pipeline.graphics.DefaultGraphicsPipeline";
    protected String GRAPHICS_SORT_STAGE = "org.j3d.aviatrix3d.pipeline.graphics.StateAndTransparencyDepthSortStage";
    protected String GRAPHICS_CULL_STAGE = "org.j3d.aviatrix3d.pipeline.graphics.FrustumCullStage";
    protected String OGL_LAYER_MANAGER_FACTORY = "org.web3d.vrml.renderer.ogl.browser.OGLLayerManagerFactory";
    protected String UI_DEVICE_FACTORY;
    protected GLCapabilities glCapabilities;
    protected GLCapabilitiesChooser glCapabilitiesChooser;
    protected GraphicsOutputDevice graphicsDevice;
    protected AudioOutputDevice audioDevice;
    protected DefaultGraphicsPipeline graphicsPipeline;
    protected DefaultAudioPipeline audioPipeline;
    protected DisplayCollection displayManager;
    protected RenderManager renderManager;
    protected OGLStandardBrowserCore core;

    protected OGLConstruct() {
        this(null);
    }

    protected OGLConstruct(ErrorReporter errorReporter) {
        super(errorReporter);
        this.renderer = 3;
        this.renderer_id = "aviatrix3d";
        this.LAYER_MANAGER_FACTORY = this.OGL_LAYER_MANAGER_FACTORY;
    }

    public Object getGraphicsObject() {
        return this.graphicsDevice.getSurfaceObject();
    }

    protected void buildAudioRenderingDevice() {
        this.audioDevice = new OpenALAudioDevice();
    }

    protected void buildBrowserCore() {
        this.core = new OGLStandardBrowserCore(this.eventModel, this.renderManager, this.displayManager);
        ((Construct)this).core = this.core;
        GraphicsResizeListener[] graphicsResizeListenerArray = this.core.getGraphicsResizeListeners();
        for (int i = 0; i < graphicsResizeListenerArray.length; ++i) {
            this.graphicsDevice.addGraphicsResizeListener(graphicsResizeListenerArray[i]);
        }
    }

    protected void buildSceneBuilderFactory() {
        this.sceneBuilderFactory = new OGLSceneBuilderFactory(this.supportVRML & !this.supportX3D, true, true, true, true, true, true);
    }

    public OGLStandardBrowserCore getBrowserCore() {
        return this.core;
    }

    public void buildRenderingCapabilities() {
        if (this.glCapabilities == null) {
            this.glCapabilities = new GLCapabilities();
            this.glCapabilities.setDoubleBuffered(this.doubleBuffered);
            this.glCapabilities.setHardwareAccelerated(this.hardwareAccelerated);
            if (this.antialiasSamples > 1) {
                this.glCapabilities.setSampleBuffers(true);
                this.glCapabilities.setNumSamples(this.antialiasSamples);
            } else {
                this.glCapabilities.setSampleBuffers(false);
            }
        }
        super.buildRenderingCapabilities();
    }

    public void buildInterfaceDevices() {
        this.deviceFactory = (DeviceFactory)this.loader.loadClass(this.UI_DEVICE_FACTORY, new Object[]{this.graphicsDevice.getSurfaceObject(), this.renderer_id, this.graphicsDevice, this.errorReporter}, new Class[]{Object.class, String.class, Object.class, ErrorReporter.class}, false);
    }

    public void buildRenderer() {
        this.displayManager = (DisplayCollection)this.loader.loadClass(this.DISPLAY_MANAGER, true);
        GraphicsSortStage graphicsSortStage = (GraphicsSortStage)this.loader.loadClass(this.GRAPHICS_SORT_STAGE, true);
        GraphicsCullStage graphicsCullStage = (GraphicsCullStage)this.loader.loadClass(this.GRAPHICS_CULL_STAGE, true);
        graphicsCullStage.setOffscreenCheckEnabled(true);
        this.graphicsPipeline = (DefaultGraphicsPipeline)this.loader.loadClass(this.GRAPHICS_PIPELINE, true);
        this.graphicsPipeline.setCuller(graphicsCullStage);
        this.graphicsPipeline.setSorter(graphicsSortStage);
        this.graphicsPipeline.setGraphicsOutputDevice(this.graphicsDevice);
        this.displayManager.addPipeline((RenderPipeline)this.graphicsPipeline);
        if (this.audioDevice != null) {
            AudioSortStage audioSortStage = (AudioSortStage)this.loader.loadClass(this.AUDIO_SORT_STAGE, true);
            AudioCullStage audioCullStage = (AudioCullStage)this.loader.loadClass(this.AUDIO_CULL_STAGE, true);
            this.audioPipeline = (DefaultAudioPipeline)this.loader.loadClass(this.AUDIO_PIPELINE, true);
            this.audioPipeline.setCuller(audioCullStage);
            this.audioPipeline.setSorter(audioSortStage);
            this.audioPipeline.setAudioOutputDevice(this.audioDevice);
            this.displayManager.addPipeline((RenderPipeline)this.audioPipeline);
        }
        this.renderManager = (RenderManager)this.loader.loadClass(this.RENDER_MANAGER, true);
        this.renderManager.addDisplay(this.displayManager);
    }

    public GraphicsRenderPipeline getGraphicsRenderPipeline() {
        return this.graphicsPipeline;
    }

    public AudioRenderPipeline getAudioRenderPipeline() {
        return this.audioPipeline;
    }

    public DisplayCollection getDisplayCollection() {
        return this.displayManager;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }
}

