/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct.ogl;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.SimpleLayer;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.SimpleViewport;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.util.MatrixUtils;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.renderer.ogl.nodes.navigation.OGLNavigationInfo;
import org.web3d.vrml.renderer.ogl.nodes.navigation.OGLViewpoint;
import org.xj3d.ui.construct.ogl.OGLConstruct;

public class AutoConfigureViewpoint
implements FrameStateListener {
    private static final String LOG_NAME = "AutoConfigureViewpoint";
    protected OGLConstruct construct;
    protected boolean headlight;
    protected OGLStandardBrowserCore core;
    protected FrameStateManager fsm;
    protected ErrorReporter errorReporter;
    protected boolean configComplete;
    protected OGLViewpoint viewpoint;
    protected OGLNavigationInfo navInfo;
    protected VRMLWorldRootNodeType root;
    protected boolean addNodes;

    public AutoConfigureViewpoint(OGLConstruct oGLConstruct, boolean bl) {
        this.construct = oGLConstruct;
        this.headlight = bl;
        this.core = oGLConstruct.getBrowserCore();
        this.fsm = oGLConstruct.getFrameStateManager();
        this.errorReporter = oGLConstruct.getErrorReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allEventsComplete() {
        if (this.addNodes) {
            this.root.addChild((VRMLNodeType)this.navInfo);
            int n = this.navInfo.getFieldIndex("set_bind");
            this.navInfo.setValue(n, true);
            this.navInfo.setupFinished();
            this.root.addChild((VRMLNodeType)this.viewpoint);
            n = this.viewpoint.getFieldIndex("set_bind");
            this.viewpoint.setValue(n, true);
            this.viewpoint.setupFinished();
            this.addNodes = false;
            this.fsm.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            AutoConfigureViewpoint autoConfigureViewpoint = this;
            synchronized (autoConfigureViewpoint) {
                this.configComplete = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure() {
        BoundingBox boundingBox = this.getWorldBounds();
        if (boundingBox == null) {
            this.errorReporter.errorReport("AutoConfigureViewpoint: Could not determine scene bounds. No Viewpoint configured.", null);
            return false;
        }
        float[] fArray = new float[3];
        boundingBox.getSize(fArray);
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        boundingBox.getExtents(fArray3, fArray2);
        float f = (fArray3[0] + fArray2[0]) / 2.0f;
        float f2 = (fArray3[1] + fArray2[1]) / 2.0f;
        float f3 = (fArray3[2] + fArray2[2]) / 2.0f;
        float[] fArray4 = new float[]{f, f2, f3};
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = fArray[2];
        float f7 = (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f8 = f7 / (float)Math.sin(0.392699);
        float f9 = f8 / (float)Math.sqrt(3.0);
        float f10 = 0.0f;
        if (f9 < 0.125f) {
            f10 = f9 * 0.9f;
        }
        float[] fArray5 = new float[]{f + f9, f2 + f9, f3 + f9};
        Point3f point3f = new Point3f(fArray5);
        Point3f point3f2 = new Point3f(fArray4);
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        MatrixUtils matrixUtils = new MatrixUtils();
        Matrix4f matrix4f = new Matrix4f();
        matrixUtils.lookAt(point3f, point3f2, vector3f, matrix4f);
        matrixUtils.inverse(matrix4f, matrix4f);
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        axisAngle4f.set(matrix4f);
        float[] fArray6 = new float[4];
        axisAngle4f.get(fArray6);
        VRMLScene vRMLScene = this.core.getScene();
        VRMLNodeFactory vRMLNodeFactory = vRMLScene.getNodeFactory();
        this.viewpoint = (OGLViewpoint)vRMLNodeFactory.createVRMLNode("Viewpoint", false);
        int n = this.viewpoint.getFieldIndex("set_position");
        this.viewpoint.setValue(n, fArray5, 3);
        n = this.viewpoint.getFieldIndex("set_orientation");
        this.viewpoint.setValue(n, fArray6, 4);
        this.navInfo = (OGLNavigationInfo)vRMLNodeFactory.createVRMLNode("NavigationInfo", false);
        this.navInfo.setType(new String[0], 0);
        this.navInfo.setHeadlight(this.headlight);
        if (f10 > 0.0f) {
            this.navInfo.setAvatarSize(new float[]{f10 * 2.0f, 1.6f, 0.75f}, 3);
        }
        this.root = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
        this.addNodes = true;
        AutoConfigureViewpoint autoConfigureViewpoint = this;
        synchronized (autoConfigureViewpoint) {
            this.fsm.addEndOfThisFrameListener((FrameStateListener)this);
            this.configComplete = false;
            while (!this.configComplete) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    private BoundingBox getWorldBounds() {
        DisplayCollection displayCollection = this.construct.getDisplayCollection();
        Layer[] layerArray = new Layer[displayCollection.numLayers()];
        displayCollection.getLayers(layerArray);
        for (int i = 0; i < layerArray.length; ++i) {
            SimpleScene simpleScene;
            Group group;
            BoundingVolume boundingVolume;
            SimpleViewport simpleViewport;
            SimpleLayer simpleLayer;
            if (!(layerArray[i] instanceof SimpleLayer) || !((simpleLayer = (SimpleLayer)layerArray[i]).getViewport() instanceof SimpleViewport) || !((simpleViewport = (SimpleViewport)simpleLayer.getViewport()).getScene() instanceof SimpleScene) || !((boundingVolume = (group = (simpleScene = simpleViewport.getScene()).getRenderedGeometry()).getBounds()) instanceof BoundingBox)) continue;
            return (BoundingBox)boundingVolume;
        }
        return null;
    }
}

