/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct;

import java.util.Date;
import org.web3d.util.ErrorReporter;

public class SystemErrorReporter
implements ErrorReporter {
    private static final String MESSAGE = "Message: ";
    private static final String WARNING = "Warning: ";
    private static final String ERROR = "Error: ";
    private static final String FATAL_ERROR = "Fatal Error: ";
    private boolean logMessage = true;
    private boolean logWarning = true;
    private boolean logError = true;
    private boolean logFatalError = true;

    public SystemErrorReporter() {
        this(true, true, true, true);
    }

    public SystemErrorReporter(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setReportingLevels(bl, bl2, bl3, bl4);
        this.messageReport(new Date().toString());
        this.messageReport("Xj3D Version: 2_M1_DEV_2009-01-05\n");
    }

    public void partialReport(String string) {
        System.out.print(string);
    }

    public void messageReport(String string) {
        if (this.logMessage) {
            System.out.print(MESSAGE);
            System.out.println(string);
        }
    }

    public void warningReport(String string, Exception exception) {
        if (this.logWarning) {
            System.out.print(WARNING);
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void errorReport(String string, Exception exception) {
        if (this.logError) {
            System.out.print(ERROR);
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void fatalErrorReport(String string, Exception exception) {
        if (this.logFatalError) {
            System.out.print(FATAL_ERROR);
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void setReportingLevels(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.logMessage = bl;
        this.logWarning = bl2;
        this.logError = bl3;
        this.logFatalError = bl4;
    }
}

