/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashSet;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.sav.VRMLParseException;

public class LoggingErrorReporter
implements ErrorReporter {
    private static final String MESSAGE = "Message: ";
    private static final String WARNING = "Warning: ";
    private static final String ERROR = "Error: ";
    private static final String FATAL_ERROR = "Fatal Error: ";
    private static final String LINE = " Line: ";
    private static final String COLUMN = " Column: ";
    private static final char NL = '\n';
    private HashSet ignoredExceptionTypes;
    private BufferedWriter writer;
    private boolean logMessage = true;
    private boolean logWarning = true;
    private boolean logError = true;
    private boolean logFatalError = true;

    public LoggingErrorReporter(File file) {
        this(file, true, true, true, true);
    }

    public LoggingErrorReporter(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        try {
            this.writer = new BufferedWriter(new FileWriter(file, true));
        }
        catch (IOException iOException) {
            System.out.println("LoggingErrorReporter: could not create log file: " + file);
        }
        this.setReportingLevels(bl, bl2, bl3, bl4);
        this.messageReport(new Date().toString());
        this.messageReport("Xj3D Version: 2_M1_DEV_2009-01-05\n");
        this.ignoredExceptionTypes = new HashSet();
        this.ignoredExceptionTypes.add(InvalidFieldException.class);
        this.ignoredExceptionTypes.add(InvalidFieldFormatException.class);
        this.ignoredExceptionTypes.add(InvalidFieldValueException.class);
        this.ignoredExceptionTypes.add(FileNotFoundException.class);
        this.ignoredExceptionTypes.add(IOException.class);
        this.ignoredExceptionTypes.add(UnknownHostException.class);
        this.ignoredExceptionTypes.add(IllegalArgumentException.class);
        this.ignoredExceptionTypes.add(InvalidFieldConnectionException.class);
        this.ignoredExceptionTypes.add(VRMLParseException.class);
        this.ignoredExceptionTypes.add(UnsupportedComponentException.class);
        this.ignoredExceptionTypes.add(UnsupportedNodeException.class);
        this.ignoredExceptionTypes.add(UnsupportedProfileException.class);
        this.ignoredExceptionTypes.add(ClassNotFoundException.class);
    }

    public void partialReport(String string) {
        if (this.writer != null) {
            try {
                this.writer.write(string, 0, string.length());
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void messageReport(String string) {
        if (this.writer != null && this.logMessage) {
            try {
                this.writer.write(MESSAGE, 0, MESSAGE.length());
                this.writer.write(string, 0, string.length());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void warningReport(String string, Exception exception) {
        if (this.writer != null && this.logWarning) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(WARNING);
            if (exception instanceof VRMLParseException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
                stringBuffer.append('\n');
            } else if (exception instanceof InvalidFieldFormatException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
                stringBuffer.append('\n');
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            if (exception != null) {
                string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = exception.getClass().getName();
                }
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    stringBuffer.append(stringWriter.toString());
                }
            }
            try {
                string2 = stringBuffer.toString();
                this.writer.write(string2, 0, string2.length());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void errorReport(String string, Exception exception) {
        if (this.writer != null && this.logError) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(ERROR);
            if (exception instanceof VRMLParseException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
                stringBuffer.append('\n');
            } else if (exception instanceof InvalidFieldFormatException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
                stringBuffer.append('\n');
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            if (exception != null) {
                string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = exception.getClass().getName();
                }
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    stringBuffer.append(stringWriter.toString());
                }
            }
            try {
                string2 = stringBuffer.toString();
                this.writer.write(string2, 0, string2.length());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void fatalErrorReport(String string, Exception exception) {
        if (this.writer != null && this.logFatalError) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(FATAL_ERROR);
            if (exception instanceof VRMLParseException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
                stringBuffer.append('\n');
            } else if (exception instanceof InvalidFieldFormatException) {
                stringBuffer.append(LINE);
                stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
                stringBuffer.append(COLUMN);
                stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
                stringBuffer.append('\n');
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            if (exception != null) {
                string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = exception.getClass().getName();
                }
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    stringBuffer.append(stringWriter.toString());
                }
            }
            try {
                string2 = stringBuffer.toString();
                this.writer.write(string2, 0, string2.length());
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setReportingLevels(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.logMessage = bl;
        this.logWarning = bl2;
        this.logError = bl3;
        this.logFatalError = bl4;
    }
}

