/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.InvalidConfigurationException;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.VRML97ResourceFactory;
import org.web3d.net.protocol.Web3DResourceFactory;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.DefaultSensorManager;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.x3d.sai.ExternalBrowser;
import org.xj3d.core.eventmodel.CursorManager;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.InputDeviceManager;
import org.xj3d.core.eventmodel.KeyDeviceSensorManager;
import org.xj3d.core.eventmodel.LayerManagerFactory;
import org.xj3d.core.eventmodel.LayerRenderingManager;
import org.xj3d.core.eventmodel.NetworkManager;
import org.xj3d.core.eventmodel.NetworkProtocolHandler;
import org.xj3d.core.eventmodel.NodeManager;
import org.xj3d.core.eventmodel.PickingManager;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.RouterFactory;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.SensorManager;
import org.xj3d.core.eventmodel.TimeSensorManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ContentLoadManager;
import org.xj3d.core.loading.SceneBuilderFactory;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.eventmodel.DefaultViewpointManager;
import org.xj3d.impl.core.loading.DefaultWorldLoaderManager;
import org.xj3d.ui.construct.ClassLoadUtilities;
import org.xj3d.ui.construct.ConstructBuilder;

public abstract class Construct
implements ConstructBuilder {
    private static final String LOG_NAME = "Construct";
    protected String DIS_PROTOCOL_HANDLER = "org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler";
    protected String NETWORK_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultNetworkManager";
    protected String HANIM_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultHumanoidManager";
    protected String PHYSICS_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultRigidBodyPhysicsManager";
    protected String PARTICLE_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultParticleSystemManager";
    protected String SCRIPT_LOADER = "org.xj3d.impl.core.loading.DefaultScriptLoader";
    protected String SCRIPT_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultScriptManager";
    protected String CONTENT_LOADER = "org.xj3d.impl.core.loading.MemCacheLoadManager";
    protected String ROUTER_FACTORY = "org.xj3d.impl.core.eventmodel.ListsRouterFactory";
    protected String ROUTER_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultRouteManager";
    protected String STATE_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultFrameStateManager";
    protected String PICKING_MANAGER = "org.web3d.vrml.renderer.ogl.input.DefaultPickingManager";
    protected String SENSOR_MANAGER = "org.web3d.vrml.renderer.common.input.DefaultSensorManager";
    protected String EVENT_MODEL = "org.xj3d.impl.core.eventmodel.DefaultEventModelEvaluator";
    protected String TIME_SENSOR_MANAGER = "org.xj3d.impl.core.eventmodel.RealTimeSensorManager";
    protected String VRML_JAVA_SCRIPT_ENGINE = "org.web3d.vrml.scripting.jsai.VRML97ScriptEngine";
    protected String VRML_JAVASCRIPT_SCRIPT_ENGINE = "org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine";
    protected String X3D_JAVA_SCRIPT_ENGINE = "org.web3d.vrml.scripting.sai.JavaSAIScriptEngine";
    protected String X3D_ECMASCRIPT_SCRIPT_ENGINE = "org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine";
    protected String LAYER_MANAGER_FACTORY;
    protected String CONTENT_HANDLER_FACTORY;
    protected int renderer;
    protected String renderer_id;
    protected boolean supportVRML;
    protected boolean supportX3D;
    protected boolean lightweightRenderer;
    protected boolean useMipMaps;
    protected boolean doubleBuffered;
    protected boolean hardwareAccelerated;
    protected int anisotropicDegree;
    protected int antialiasSamples;
    protected DeviceFactory deviceFactory;
    protected BrowserCore core;
    protected ScriptManager scriptManager;
    protected ScriptLoader scriptLoader;
    protected FrameStateManager stateManager;
    protected ContentLoadManager loadManager;
    protected NetworkManager networkManager;
    protected NodeManager hanimManager;
    protected NodeManager physicsManager;
    protected NodeManager particleManager;
    protected RouteManager routeManager;
    protected SensorManager sensorManager;
    protected TimeSensorManager timeSensorManager;
    protected PickingManager pickingManager;
    protected EventModelEvaluator eventModel;
    protected WorldLoaderManager worldLoader;
    protected ViewpointManager viewpointManager;
    protected SceneBuilderFactory sceneBuilderFactory;
    protected ExternalBrowser externalBrowser;
    protected ErrorReporter errorReporter;
    protected ClassLoadUtilities loader;

    protected Construct() {
        this(null);
    }

    protected Construct(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? new DefaultErrorReporter() : errorReporter;
        this.loader = new ClassLoadUtilities(this.errorReporter);
        this.supportVRML = true;
        this.supportX3D = true;
        this.lightweightRenderer = false;
        this.useMipMaps = true;
        this.doubleBuffered = true;
        this.hardwareAccelerated = true;
    }

    public abstract Object getGraphicsObject();

    public void buildAll() {
        this.buildRenderingCapabilities();
        this.buildRenderingDevices();
        this.buildInterfaceDevices();
        this.buildRenderer();
        this.buildManagers();
        this.buildScriptEngines();
        this.buildNetworkCapabilities();
    }

    public void buildRenderingCapabilities() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    if (Construct.this.useMipMaps) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                    }
                    if (Construct.this.anisotropicDegree > 1) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", new Integer(Construct.this.anisotropicDegree).toString());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.errorReporter.warningReport("Construct: Exception setting System properties", (Exception)privilegedActionException);
        }
    }

    public void buildRenderingDevices() {
        this.buildGraphicsRenderingDevice();
        this.buildAudioRenderingDevice();
    }

    protected abstract void buildGraphicsRenderingDevice();

    protected abstract void buildAudioRenderingDevice();

    public void buildManagers() {
        this.scriptManager = (ScriptManager)this.loader.loadClass(this.SCRIPT_MANAGER, true);
        this.loadManager = (ContentLoadManager)this.loader.loadClass(this.CONTENT_LOADER, true);
        this.routeManager = (RouteManager)this.loader.loadClass(this.ROUTER_MANAGER, true);
        this.stateManager = (FrameStateManager)this.loader.loadClass(this.STATE_MANAGER, true);
        this.timeSensorManager = (TimeSensorManager)this.loader.loadClass(this.TIME_SENSOR_MANAGER, true);
        this.eventModel = (EventModelEvaluator)this.loader.loadClass(this.EVENT_MODEL, true);
        this.scriptLoader = (ScriptLoader)this.loader.loadClass(this.SCRIPT_LOADER, false);
        RouterFactory routerFactory = (RouterFactory)this.loader.loadClass(this.ROUTER_FACTORY, false);
        this.pickingManager = (PickingManager)this.loader.loadClass(this.PICKING_MANAGER, false);
        int n = 0;
        this.networkManager = (NetworkManager)this.loader.loadClass(this.NETWORK_MANAGER, false);
        if (this.networkManager != null) {
            ++n;
        }
        this.hanimManager = (NodeManager)this.loader.loadClass(this.HANIM_MANAGER, false);
        if (this.hanimManager != null) {
            ++n;
        }
        this.physicsManager = (NodeManager)this.loader.loadClass(this.PHYSICS_MANAGER, false);
        if (this.physicsManager != null) {
            ++n;
        }
        this.particleManager = (NodeManager)this.loader.loadClass(this.PARTICLE_MANAGER, false);
        if (this.particleManager != null) {
            ++n;
        }
        NodeManager[] nodeManagerArray = new NodeManager[n];
        n = 0;
        if (this.networkManager != null) {
            nodeManagerArray[n++] = this.networkManager;
        }
        if (this.hanimManager != null) {
            nodeManagerArray[n++] = this.hanimManager;
        }
        if (this.physicsManager != null) {
            nodeManagerArray[n++] = this.physicsManager;
        }
        if (this.particleManager != null) {
            nodeManagerArray[n++] = this.particleManager;
        }
        DISProtocolHandler dISProtocolHandler = (DISProtocolHandler)this.loader.loadClass(this.DIS_PROTOCOL_HANDLER, false);
        this.sensorManager = new DefaultSensorManager(this.timeSensorManager);
        this.sensorManager.setErrorReporter(this.errorReporter);
        this.sensorManager.setPickingManager(this.pickingManager);
        InputDeviceManager inputDeviceManager = new InputDeviceManager(this.deviceFactory);
        KeyDeviceSensorManager keyDeviceSensorManager = new KeyDeviceSensorManager(this.deviceFactory);
        this.sensorManager.setInputManager(inputDeviceManager);
        this.sensorManager.setKeyDeviceSensorManager(keyDeviceSensorManager);
        this.routeManager.setRouterFactory(routerFactory);
        this.scriptManager.setScriptLoader(this.scriptLoader);
        if (dISProtocolHandler != null) {
            this.networkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
        }
        this.buildBrowserCore();
        this.core.setErrorReporter(this.errorReporter);
        this.viewpointManager = new DefaultViewpointManager(this.core);
        LayerManagerFactory layerManagerFactory = (LayerManagerFactory)this.loader.loadClass(this.LAYER_MANAGER_FACTORY, true);
        this.eventModel.initialize(this.scriptManager, this.routeManager, this.sensorManager, this.stateManager, this.loadManager, this.viewpointManager, layerManagerFactory, (LayerRenderingManager)this.core, nodeManagerArray);
        this.eventModel.setErrorReporter(this.errorReporter);
        this.buildSceneBuilderFactory();
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Construct: Failed to load Parser Factory");
        }
        this.worldLoader = new DefaultWorldLoaderManager(this.core, this.stateManager, this.routeManager);
        this.worldLoader.setErrorReporter(this.errorReporter);
        this.worldLoader.registerBuilderFactory(this.renderer, this.sceneBuilderFactory);
        this.worldLoader.registerParserFactory(this.renderer, vRMLParserFactory);
    }

    protected abstract void buildBrowserCore();

    protected abstract void buildSceneBuilderFactory();

    public void buildScriptEngines() {
        if (this.scriptLoader != null) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.supportVRML) {
                arrayList.add(this.VRML_JAVA_SCRIPT_ENGINE);
                arrayList.add(this.VRML_JAVASCRIPT_SCRIPT_ENGINE);
            }
            if (this.supportX3D) {
                arrayList.add(this.X3D_JAVA_SCRIPT_ENGINE);
                arrayList.add(this.X3D_ECMASCRIPT_SCRIPT_ENGINE);
            }
            if ((n = arrayList.size()) > 0) {
                String[] stringArray = new String[n];
                stringArray = arrayList.toArray(stringArray);
                ScriptEngine scriptEngine = null;
                for (int i = 0; i < n; ++i) {
                    scriptEngine = this.loader.loadScriptEngine(stringArray[i], this.core, this.viewpointManager, this.routeManager, this.stateManager, this.worldLoader, true);
                    scriptEngine.setErrorReporter(this.errorReporter);
                    this.scriptLoader.registerScriptingEngine(scriptEngine);
                }
            }
        } else {
            this.errorReporter.warningReport("Construct: Cannot load ScriptEngines: ScriptLoader is not initialized", null);
        }
    }

    public void buildNetworkCapabilities() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    FileNameMap fileNameMap;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    URIResourceStreamFactory uRIResourceStreamFactory = URI.getURIResourceStreamFactory();
                    if (Construct.this.supportX3D && Construct.this.supportVRML) {
                        if (!(uRIResourceStreamFactory instanceof Web3DResourceFactory)) {
                            uRIResourceStreamFactory = new Web3DResourceFactory(uRIResourceStreamFactory);
                            URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                        }
                    } else if (Construct.this.supportX3D) {
                        if (!(uRIResourceStreamFactory instanceof X3DResourceFactory)) {
                            uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                            URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                        }
                    } else if (Construct.this.supportVRML && !(uRIResourceStreamFactory instanceof VRML97ResourceFactory)) {
                        uRIResourceStreamFactory = new VRML97ResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(Construct.this.CONTENT_HANDLER_FACTORY);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new InvalidConfigurationException("Construct: Missing required Factory:" + Construct.this.CONTENT_HANDLER_FACTORY);
                    }
                    ContentHandlerFactory contentHandlerFactory = URI.getContentHandlerFactory();
                    if (!clazz.isInstance(contentHandlerFactory)) {
                        contentHandlerFactory = (ContentHandlerFactory)Construct.this.loader.loadClass(Construct.this.CONTENT_HANDLER_FACTORY, new Object[]{Construct.this.core, Construct.this.worldLoader, contentHandlerFactory}, new Class[]{BrowserCore.class, WorldLoaderManager.class, ContentHandlerFactory.class}, true);
                        URI.setContentHandlerFactory((ContentHandlerFactory)contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap((FileNameMap)fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.errorReporter.warningReport("Construct: Exception setting System properties", (Exception)privilegedActionException);
        }
    }

    public void buildAuthoring(CursorManager cursorManager) {
        if (this.supportX3D) {
            X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser(this.core, this.viewpointManager, this.routeManager, this.stateManager, this.worldLoader);
            x3DCommonBrowser.setErrorReporter(this.errorReporter);
            ExternalEventQueue externalEventQueue = new ExternalEventQueue(this.errorReporter);
            this.eventModel.addExternalView((ExternalView)externalEventQueue);
            this.externalBrowser = new SAIBrowser(this.core, x3DCommonBrowser, this.routeManager, this.stateManager, externalEventQueue, cursorManager, this.errorReporter);
        }
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public ScriptLoader getScriptLoader() {
        return this.scriptLoader;
    }

    public ViewpointManager getViewpointManager() {
        return this.viewpointManager;
    }

    public ContentLoadManager getContentLoadManager() {
        return this.loadManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public TimeSensorManager getTimeSensorManager() {
        return this.timeSensorManager;
    }

    public WorldLoaderManager getWorldLoaderManager() {
        return this.worldLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public EventModelEvaluator getEventModelEvaluator() {
        return this.eventModel;
    }

    public BrowserCore getBrowserCore() {
        return this.core;
    }
}

