/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.InvalidConfigurationException;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.scripting.ScriptEngine;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.WorldLoaderManager;

public class ClassLoadUtilities {
    private static final String LOG_NAME = "ClassLoadUtilities";
    protected ErrorReporter errorReporter;

    public ClassLoadUtilities() {
        this(null);
    }

    public ClassLoadUtilities(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? new DefaultErrorReporter() : errorReporter;
    }

    public Object loadClass(final String string, final boolean bl) {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string);
                    return clazz.newInstance();
                }
                catch (Error error) {
                    if (bl) {
                        throw new InvalidConfigurationException("ClassLoadUtilities: Missing required Class:" + string);
                    }
                    ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load Class: " + string, null);
                }
                catch (Exception exception) {
                    if (bl) {
                        throw new InvalidConfigurationException("ClassLoadUtilities: Missing required Class:" + string);
                    }
                    ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load Class: " + string, exception);
                }
                return null;
            }
        });
        return object;
    }

    public Object loadClass(final String string, final Object[] objectArray, final Class[] classArray, final boolean bl) {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    return constructor.newInstance(objectArray);
                }
                catch (Error error) {
                    if (bl) {
                        throw new InvalidConfigurationException("ClassLoadUtilities: Missing required Class:" + string);
                    }
                    Exception exception = new Exception(error.getMessage(), error);
                    ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load class: " + string, exception);
                }
                catch (Exception exception) {
                    if (bl) {
                        throw new InvalidConfigurationException("ClassLoadUtilities: Missing required Class:" + string);
                    }
                    ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load Class: " + string, exception);
                }
                return null;
            }
        });
        return object;
    }

    protected ScriptEngine loadScriptEngine(final String string, final BrowserCore browserCore, final ViewpointManager viewpointManager, final RouteManager routeManager, final FrameStateManager frameStateManager, final WorldLoaderManager worldLoaderManager, final boolean bl) {
        ScriptEngine scriptEngine = (ScriptEngine)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object[] objectArray = new Object[]{browserCore, routeManager, frameStateManager, worldLoaderManager};
                Object[] objectArray2 = new Object[]{browserCore, viewpointManager, routeManager, frameStateManager, worldLoaderManager};
                ScriptEngine scriptEngine = null;
                boolean bl2 = false;
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        Class<?>[] classArray = constructorArray[i].getParameterTypes();
                        if (classArray.length == objectArray.length) {
                            scriptEngine = (ScriptEngine)constructorArray[i].newInstance(objectArray);
                            bl2 = true;
                            break;
                        }
                        if (classArray.length != objectArray2.length) continue;
                        scriptEngine = (ScriptEngine)constructorArray[i].newInstance(objectArray2);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        if (bl) {
                            throw new InvalidConfigurationException("ClassLoadUtilities: Missing required ScriptEngine:" + string);
                        }
                        ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load ScriptEngine: " + string, null);
                    }
                }
                catch (Exception exception) {
                    if (bl) {
                        throw new InvalidConfigurationException("ClassLoadUtilities: Missing required ScriptEngine:" + string);
                    }
                    ClassLoadUtilities.this.errorReporter.warningReport("ClassLoadUtilities: Cannot load ScriptEngine: " + string, exception);
                }
                return scriptEngine;
            }
        });
        return scriptEngine;
    }
}

