/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.construct;

import java.util.Map;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.InputSource;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.LoaderThreadPool;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.ui.construct.Construct;
import org.xj3d.ui.construct.ScenePreprocessor;

public class BlockingWorldLoader
implements Runnable,
BrowserCoreListener,
FrameStateListener {
    private static final String LOG_NAME = "BlockingWorldLoader";
    protected Construct construct;
    protected ScenePreprocessor preprocessor;
    protected ErrorReporter errorReporter;
    protected InputSource source;
    protected boolean loadStatus;
    protected boolean loadInProgress;
    protected LoaderThreadPool loaderPool;
    protected ContentLoadQueue pending;
    protected Map inProgress;

    public BlockingWorldLoader(Construct construct) {
        if (construct == null) {
            throw new IllegalArgumentException("BlockingWorldLoader: construct instance must be non-null");
        }
        this.construct = construct;
        this.errorReporter = construct.errorReporter;
        this.loaderPool = LoaderThreadPool.getLoaderThreadPool();
        this.pending = this.loaderPool.getWaitingList();
        this.inProgress = this.loaderPool.getProgressMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WorldLoader worldLoader = this.construct.worldLoader.fetchLoader();
        VRMLScene vRMLScene = null;
        try {
            vRMLScene = worldLoader.loadNow(this.construct.core, this.source);
            this.loadStatus = true;
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("BlockingWorldLoader: Failed to load file", exception);
            this.loadStatus = false;
        }
        this.construct.worldLoader.releaseLoader(worldLoader);
        if (this.loadStatus) {
            if (this.preprocessor != null) {
                this.preprocessor.preprocess(vRMLScene, this.construct);
            }
            this.construct.core.setScene(vRMLScene, null);
        } else {
            BlockingWorldLoader blockingWorldLoader = this;
            synchronized (blockingWorldLoader) {
                this.loadInProgress = false;
                this.notify();
            }
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        this.construct.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allEventsComplete() {
        boolean bl = this.isLoadingInProgress();
        if (bl) {
            this.construct.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            BlockingWorldLoader blockingWorldLoader = this;
            synchronized (blockingWorldLoader) {
                this.loadInProgress = false;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputSource inputSource) {
        this.source = inputSource;
        this.construct.core.setMinimumFrameInterval(250, false);
        this.construct.core.addCoreListener((BrowserCoreListener)this);
        Thread thread = new Thread((Runnable)this, "Xj3D World Loader");
        thread.start();
        try {
            BlockingWorldLoader blockingWorldLoader = this;
            synchronized (blockingWorldLoader) {
                this.loadInProgress = true;
                while (this.loadInProgress) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.construct.core.removeCoreListener((BrowserCoreListener)this);
        this.construct.core.setMinimumFrameInterval(0, false);
        return this.loadStatus;
    }

    public boolean isLoadingInProgress() {
        int n;
        int n2;
        int n3 = this.pending.size();
        int n4 = n3 + (n2 = this.inProgress.size()) + (n = this.construct.worldLoader.getNumberLoadersActive());
        return n4 > 0;
    }

    public void setScenePreprocessor(ScenePreprocessor scenePreprocessor) {
        this.preprocessor = scenePreprocessor;
    }
}

