/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.ui.awt.widgets.FitWorldAction;
import org.xj3d.ui.awt.widgets.HomeViewpointAction;
import org.xj3d.ui.awt.widgets.IconLoader;
import org.xj3d.ui.awt.widgets.LookatAction;
import org.xj3d.ui.awt.widgets.NextViewpointAction;
import org.xj3d.ui.awt.widgets.PreviousViewpointAction;
import org.xj3d.ui.awt.widgets.ViewpointCellRenderer;

public class SwingViewpointToolbar
extends JPanel
implements ItemListener,
ViewpointStatusListener,
NavigationStateListener {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String DEFAULT_HOME_BUTTON = "images/navigation/ButtonHome.gif";
    private static final String DEFAULT_FITWORLD_BUTTON = "images/navigation/ButtonFit.gif";
    private static final String DEFAULT_LOOKAT_BUTTON = "images/navigation/ButtonLookat.gif";
    private static final String DEFAULT_NEXT_BUTTON = "images/navigation/ButtonForward.gif";
    private static final String DEFAULT_PREVIOUS_BUTTON = "images/navigation/ButtonBack.gif";
    private static final String HOME_BUTTON_PROPERTY = "HOME.button";
    private static final String FITWORLD_BUTTON_PROPERTY = "FITWORLD.button";
    private static final String LOOKAT_BUTTON_PROPERTY = "LOOKAT.button";
    private static final String NEXT_BUTTON_PROPERTY = "NEXTVIEW.button";
    private static final String PREVIOUS_BUTTON_PROPERTY = "PREVIOUSVIEW.button";
    private ErrorReporter errorReporter;
    private ViewpointManager vpManager;
    private JComboBox viewpoints;
    private DefaultComboBoxModel viewpointModel;
    private JButton nextViewpoint;
    private JButton prevViewpoint;
    private JButton homeViewpoint;
    private JButton fitworldViewpoint;
    private JButton lookatViewpoint;
    private ArrayList viewpointsByLayer;
    private boolean noInitialVPS;
    private ArrayList defaultViewpoints;
    private ArrayList boundViewpoints;
    private int activeLayerId;
    private BrowserCore browserCore;
    private NextViewpointAction nextViewpointMenuAction;
    private PreviousViewpointAction prevViewpointMenuAction;
    private HomeViewpointAction homeViewpointMenuAction;
    private LookatAction lookatMenuAction;
    private FitWorldAction fitWorldMenuAction;
    private NextViewpointAction nextViewpointAction;
    private PreviousViewpointAction prevViewpointAction;
    private HomeViewpointAction homeViewpointAction;
    private LookatAction lookatAction;
    private FitWorldAction fitWorldAction;

    public SwingViewpointToolbar(BrowserCore browserCore, ViewpointManager viewpointManager, ErrorReporter errorReporter) {
        this(browserCore, viewpointManager, DEFAULT_PROPERTIES, errorReporter);
    }

    public SwingViewpointToolbar(BrowserCore browserCore, ViewpointManager viewpointManager, Properties properties, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.vpManager = viewpointManager;
        this.browserCore = browserCore;
        browserCore.addNavigationStateListener((NavigationStateListener)this);
        browserCore.addViewpointStatusListener((ViewpointStatusListener)this);
        this.viewpointsByLayer = new ArrayList();
        this.defaultViewpoints = new ArrayList();
        this.boundViewpoints = new ArrayList();
        this.activeLayerId = -1;
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        this.viewpointModel = new DefaultComboBoxModel();
        this.viewpoints = new JComboBox(this.viewpointModel);
        this.viewpoints.setRenderer(new ViewpointCellRenderer());
        this.viewpoints.setEditable(false);
        this.viewpoints.setLightWeightPopupEnabled(false);
        this.viewpoints.setMinimumSize(new Dimension(60, 10));
        this.viewpoints.setToolTipText("Select a Viewpoint");
        this.viewpoints.addItemListener(this);
        String string = properties.getProperty(NEXT_BUTTON_PROPERTY, DEFAULT_NEXT_BUTTON);
        ImageIcon imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.nextViewpointAction = new NextViewpointAction(true, imageIcon, this.vpManager);
        this.nextViewpointMenuAction = new NextViewpointAction(false, imageIcon, this.vpManager);
        int n = 0;
        int n2 = 11;
        this.nextViewpoint = new JButton(this.nextViewpointAction);
        this.nextViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.nextViewpoint.setToolTipText("Next Viewpoint");
        this.nextViewpoint.setVerticalTextPosition(n);
        this.nextViewpoint.setHorizontalTextPosition(n2);
        string = properties.getProperty(PREVIOUS_BUTTON_PROPERTY, DEFAULT_PREVIOUS_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.prevViewpointAction = new PreviousViewpointAction(true, imageIcon, this.vpManager);
        this.prevViewpointMenuAction = new PreviousViewpointAction(false, imageIcon, this.vpManager);
        this.prevViewpoint = new JButton(this.prevViewpointAction);
        this.prevViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.prevViewpoint.setToolTipText("Previous Viewpoint");
        this.prevViewpoint.setVerticalTextPosition(n);
        this.prevViewpoint.setHorizontalTextPosition(n2);
        string = properties.getProperty(HOME_BUTTON_PROPERTY, DEFAULT_HOME_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.homeViewpointAction = new HomeViewpointAction(true, imageIcon, this.vpManager);
        this.homeViewpointMenuAction = new HomeViewpointAction(false, imageIcon, this.vpManager);
        this.homeViewpoint = new JButton(this.homeViewpointAction);
        this.homeViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.homeViewpoint.setToolTipText("Return to current Viewpoint");
        string = properties.getProperty(LOOKAT_BUTTON_PROPERTY, DEFAULT_LOOKAT_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.lookatAction = new LookatAction(true, imageIcon, this.browserCore);
        this.lookatMenuAction = new LookatAction(false, imageIcon, this.browserCore);
        this.lookatViewpoint = new JButton(this.lookatAction);
        this.lookatViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.lookatViewpoint.setToolTipText("LookAt");
        string = properties.getProperty(FITWORLD_BUTTON_PROPERTY, DEFAULT_FITWORLD_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.fitWorldAction = new FitWorldAction(true, imageIcon, this.browserCore);
        this.fitWorldMenuAction = new FitWorldAction(false, imageIcon, this.browserCore);
        this.fitworldViewpoint = new JButton(this.fitWorldAction);
        this.fitworldViewpoint.setMargin(new Insets(0, 0, 0, 0));
        this.fitworldViewpoint.setToolTipText("Fit to World");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(this.nextViewpoint);
        jPanel.add(this.homeViewpoint);
        jPanel.add(this.lookatViewpoint);
        jPanel.add(this.fitworldViewpoint);
        this.setLayout(new BorderLayout());
        this.add((Component)this.prevViewpoint, "West");
        this.add((Component)this.viewpoints, "Center");
        this.add((Component)jPanel, "East");
        this.setEnabled(false);
    }

    public void navigationStateChanged(int n) {
    }

    public void navigationListChanged(String[] stringArray, int n) {
        boolean bl = false;
        this.lookatAction.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("ANY")) {
                bl = true;
                break;
            }
            String string = stringArray[i];
            if (!string.equals("LOOKAT")) continue;
            this.lookatAction.setEnabled(true);
        }
        if (bl) {
            this.lookatAction.setEnabled(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)itemEvent.getItem();
        if (!vRMLViewpointNodeType.getIsBound()) {
            this.vpManager.setViewpoint(vRMLViewpointNodeType);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.viewpoints.setEnabled(bl);
        this.nextViewpointAction.setEnabled(bl);
        this.nextViewpointMenuAction.setEnabled(bl);
        this.prevViewpointAction.setEnabled(bl);
        this.prevViewpointMenuAction.setEnabled(bl);
        this.homeViewpointAction.setEnabled(bl);
        this.homeViewpointMenuAction.setEnabled(bl);
        this.fitWorldAction.setEnabled(bl);
        this.fitWorldMenuAction.setEnabled(bl);
        this.lookatAction.setEnabled(bl);
        this.lookatMenuAction.setEnabled(bl);
    }

    public void viewpointLayerAdded(int n) {
        if (n >= this.viewpointsByLayer.size()) {
            for (int i = this.viewpointsByLayer.size() - 1; i <= n; ++i) {
                this.viewpointsByLayer.add(null);
                this.defaultViewpoints.add(null);
                this.boundViewpoints.add(null);
            }
        }
        this.viewpointsByLayer.set(n, new ArrayList());
    }

    public void viewpointLayerRemoved(int n) {
        this.viewpointsByLayer.set(n, null);
        this.defaultViewpoints.set(n, null);
        this.boundViewpoints.set(n, null);
    }

    public void viewpointLayerActive(int n) {
        this.activeLayerId = n;
        if (n == -1) {
            this.clearViewpoints();
        } else {
            ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
            if (arrayList == null || arrayList.size() == 0) {
                this.viewpointModel.removeAllElements();
                this.partialDisable();
            } else {
                this.viewpointModel.removeAllElements();
                Object e = this.defaultViewpoints.get(n);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e2 = arrayList.get(i);
                    if (e2 == e) continue;
                    this.viewpointModel.addElement(e2);
                }
                this.viewpointModel.setSelectedItem(this.boundViewpoints.get(n));
                if (arrayList.size() == 1) {
                    this.partialDisable();
                }
            }
        }
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType, int n, boolean bl) {
        ArrayList arrayList;
        boolean bl2;
        if (bl) {
            this.defaultViewpoints.set(n, vRMLViewpointNodeType);
            if (this.boundViewpoints.get(n) == null) {
                this.boundViewpoints.set(n, vRMLViewpointNodeType);
            }
        }
        if (!(bl2 = (arrayList = (ArrayList)this.viewpointsByLayer.get(n)).contains(vRMLViewpointNodeType))) {
            arrayList.add(vRMLViewpointNodeType);
        }
        if (n == this.activeLayerId) {
            if (bl) {
                if (arrayList.size() == 0) {
                    if (!bl2) {
                        this.viewpointModel.addElement(vRMLViewpointNodeType);
                    }
                    this.partialDisable();
                }
            } else {
                Object e = this.defaultViewpoints.get(n);
                if (e != null) {
                    this.viewpointModel.removeElement(e);
                }
                if (!bl2) {
                    this.viewpointModel.addElement(vRMLViewpointNodeType);
                }
                this.setEnabled(true);
            }
        }
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
        arrayList.remove(vRMLViewpointNodeType);
        if (this.defaultViewpoints.get(n) == vRMLViewpointNodeType) {
            this.defaultViewpoints.set(n, null);
        }
        if (this.boundViewpoints.get(n) == vRMLViewpointNodeType) {
            this.boundViewpoints.set(n, this.defaultViewpoints.get(n));
        }
        if (n == this.activeLayerId) {
            this.viewpointModel.removeElement(vRMLViewpointNodeType);
        }
    }

    public void viewpointBound(final VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        this.boundViewpoints.set(n, vRMLViewpointNodeType);
        if (n == this.activeLayerId) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SwingViewpointToolbar.this.viewpoints.setSelectedItem(vRMLViewpointNodeType);
                }
            });
        }
    }

    public AbstractAction getNextViewpointAction() {
        return this.nextViewpointMenuAction;
    }

    public AbstractAction getPreviousViewpointAction() {
        return this.prevViewpointMenuAction;
    }

    public AbstractAction getHomeViewpointAction() {
        return this.homeViewpointMenuAction;
    }

    public AbstractAction getLookatAction() {
        return this.lookatMenuAction;
    }

    public AbstractAction getFitWorldAction() {
        return this.fitWorldMenuAction;
    }

    public void clearViewpoints() {
        this.viewpointModel.removeAllElements();
        this.setEnabled(false);
    }

    private void partialDisable() {
        this.viewpoints.setEnabled(false);
        this.nextViewpointAction.setEnabled(false);
        this.nextViewpointMenuAction.setEnabled(false);
        this.prevViewpointAction.setEnabled(false);
        this.prevViewpointMenuAction.setEnabled(false);
        this.homeViewpointAction.setEnabled(true);
        this.homeViewpointMenuAction.setEnabled(true);
        this.fitWorldAction.setEnabled(true);
        this.fitWorldMenuAction.setEnabled(true);
        this.lookatAction.setEnabled(true);
        this.lookatMenuAction.setEnabled(true);
    }
}

