/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLScene;
import org.xj3d.ui.awt.widgets.SwingProgressListener;

public class SwingStatusBar
extends JPanel
implements Runnable,
BrowserCoreListener {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private ErrorReporter errorReporter;
    private JLabel statusLabel;
    private float lastFPS;
    private JLabel fpsLabel;
    private JProgressBar progressBar;
    private BrowserCore browserCore;
    private SwingProgressListener dlListener;
    private Thread statusThread;
    private boolean runStatusThread;

    public SwingStatusBar(BrowserCore browserCore, boolean bl, boolean bl2, Properties properties, ErrorReporter errorReporter) {
        super(new BorderLayout());
        this.browserCore = browserCore;
        this.browserCore.addCoreListener((BrowserCoreListener)this);
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        if (bl2) {
            this.fpsLabel = new JLabel();
            jPanel.add((Component)this.fpsLabel, "East");
            this.statusThread = new Thread((Runnable)this, "Xj3D FPS updates");
            this.runStatusThread = true;
            this.statusThread.start();
        }
        if (bl) {
            this.statusLabel = new JLabel();
            this.add((Component)this.statusLabel, "West");
            this.progressBar = new JProgressBar();
            this.dlListener = new SwingProgressListener(this.statusLabel, this.progressBar, jPanel, "West", errorReporter);
            ResourceConnection.addGlobalProgressListener((ProgressListener)this.dlListener);
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        if (this.dlListener != null) {
            ResourceConnection.removeGlobalProgressListener((ProgressListener)this.dlListener);
        }
        if (this.statusThread != null) {
            this.runStatusThread = false;
            this.statusThread.interrupt();
        }
    }

    public void run() {
        while (this.runStatusThread) {
            float f;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!((double)Math.abs(this.lastFPS - (f = this.browserCore.getCurrentFrameRate())) > 0.1)) continue;
            String string = Float.toString(f);
            if (string.equals("Infinity")) {
                this.lastFPS = 999.9f;
                string = "999.9";
            }
            int n = string.length();
            string = string.substring(0, Math.min(5, n));
            if (n < 5) {
                n = 5 - n;
                for (int i = 0; i < n; ++i) {
                    string = string + " ";
                }
            }
            this.fpsLabel.setText(string);
            this.lastFPS = f;
        }
    }

    public ProgressListener getProgressListener() {
        return this.dlListener;
    }

    public void setStatusText(String string) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(string);
        }
    }
}

