/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;

public class SwingProgressListener
implements ProgressListener {
    private static final String MAIN_FILE_LOAD_MSG = "Main file downloading";
    private static final String MAIN_FILE_LOAD_COMPLETE_MSG = "Main file complete";
    private JLabel statusLabel;
    private ErrorReporter reporter;
    private JProgressBar progressBar;
    private int mainSize;
    private Container progressPanel;
    private String progressLocation;
    private boolean currentConnectionIsFile;
    private boolean loadingMainFile;
    private boolean progressBarIsActive;

    public SwingProgressListener(JLabel jLabel, JProgressBar jProgressBar, Container container, String string, ErrorReporter errorReporter) {
        this.statusLabel = jLabel;
        this.reporter = errorReporter;
        this.progressBar = jProgressBar;
        this.progressPanel = container;
        this.progressLocation = string;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (URI.getScheme((String)resourceConnection.getURI().toExternalForm()).equals("file")) {
            this.currentConnectionIsFile = true;
            this.mainSize = resourceConnection.getContentLength();
            this.progressBar.setMaximum(this.mainSize);
        } else {
            this.currentConnectionIsFile = false;
        }
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        int n = resourceConnection.getContentLength();
        this.progressBar.setMaximum(n);
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        String string = null;
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            string = uRI.toExternalForm();
            this.statusLabel.setText(string);
            if (this.progressBarIsActive) {
                this.progressBar.setValue(progressEvent.getValue());
            } else {
                this.addProgressBar();
                this.progressBarIsActive = true;
                this.progressBar.setValue(progressEvent.getValue());
            }
        } else if (this.loadingMainFile) {
            if (this.progressBarIsActive) {
                this.progressBar.setValue(progressEvent.getValue());
            }
        } else {
            this.loadingMainFile = true;
            this.statusLabel.setText(MAIN_FILE_LOAD_MSG);
            if (this.currentConnectionIsFile) {
                this.addProgressBar();
                this.progressBarIsActive = true;
                this.progressBar.setValue(progressEvent.getValue());
            }
        }
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            String string = uRI.toExternalForm() + " complete.";
            this.statusLabel.setText(string);
            this.reporter.messageReport(string);
        } else {
            this.statusLabel.setText(MAIN_FILE_LOAD_COMPLETE_MSG);
            this.loadingMainFile = false;
        }
        if (this.progressBarIsActive) {
            this.progressBarIsActive = false;
            this.removeProgressBar();
        }
    }

    public void downloadError(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
        this.reporter.errorReport(progressEvent.getMessage(), null);
        if (this.progressBarIsActive) {
            this.progressBarIsActive = false;
            this.removeProgressBar();
        }
    }

    private void addProgressBar() {
        this.progressPanel.add((Component)this.progressBar, this.progressLocation);
    }

    private void removeProgressBar() {
        this.progressBar.setMaximum(1);
        this.progressBar.setValue(1);
    }
}

