/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xj3d.ui.awt.widgets.IconLoader;
import org.xj3d.ui.awt.widgets.NavModeAction;

public class SwingNavigationToolbar
extends JPanel
implements NavigationStateListener {
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String EXAMINE_BUTTON_PROPERTY = "EXAMINE.button";
    private static final String FLY_BUTTON_PROPERTY = "FLY.button";
    private static final String PAN_BUTTON_PROPERTY = "PAN.button";
    private static final String TILT_BUTTON_PROPERTY = "TILT.button";
    private static final String WALK_BUTTON_PROPERTY = "WALK.button";
    private static final String TRACK_BUTTON_PROPERTY = "TRACK.button";
    private static final String DEFAULT_EXAMINE_BUTTON = "images/navigation/ButtonExamine.gif";
    private static final String DEFAULT_FLY_BUTTON = "images/navigation/ButtonFly.gif";
    private static final String DEFAULT_PAN_BUTTON = "images/navigation/ButtonPan.gif";
    private static final String DEFAULT_TILT_BUTTON = "images/navigation/ButtonTilt.gif";
    private static final String DEFAULT_WALK_BUTTON = "images/navigation/ButtonWalk.gif";
    private static final String DEFAULT_TRACK_BUTTON = "images/navigation/ButtonTExamine.gif";
    private ErrorReporter errorReporter;
    private String[] navigationModes;
    private ButtonGroup navStateGroup;
    private JToggleButton flyButton;
    private JToggleButton panButton;
    private JToggleButton tiltButton;
    private JToggleButton walkButton;
    private JToggleButton examineButton;
    private JToggleButton trackButton;
    private BrowserCore browserCore;
    private NavModeAction flyAction;
    private NavModeAction flyMenuAction;
    private NavModeAction walkAction;
    private NavModeAction walkMenuAction;
    private NavModeAction examineAction;
    private NavModeAction examineMenuAction;
    private NavModeAction panAction;
    private NavModeAction panMenuAction;
    private NavModeAction tiltAction;
    private NavModeAction tiltMenuAction;
    private NavModeAction trackAction;
    private NavModeAction trackMenuAction;

    public SwingNavigationToolbar(BrowserCore browserCore, ErrorReporter errorReporter) {
        this(browserCore, true, errorReporter);
    }

    public SwingNavigationToolbar(BrowserCore browserCore, boolean bl, ErrorReporter errorReporter) {
        this(browserCore, bl, null, errorReporter);
    }

    public SwingNavigationToolbar(BrowserCore browserCore, Properties properties, ErrorReporter errorReporter) {
        this(browserCore, true, properties, errorReporter);
    }

    public SwingNavigationToolbar(BrowserCore browserCore, boolean bl, Properties properties, ErrorReporter errorReporter) {
        this.browserCore = browserCore;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        this.browserCore.addNavigationStateListener((NavigationStateListener)this);
        if (bl) {
            this.setLayout(new GridLayout(1, 5));
        } else {
            this.setLayout(new GridLayout(5, 1));
        }
        this.navStateGroup = new ButtonGroup();
        String string = properties.getProperty(FLY_BUTTON_PROPERTY, DEFAULT_FLY_BUTTON);
        ImageIcon imageIcon = IconLoader.loadIcon(string, errorReporter);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, 2);
        this.flyAction = new NavModeAction(true, imageIcon, "FLY", keyStroke, this.browserCore);
        this.flyMenuAction = new NavModeAction(false, imageIcon, "FLY", keyStroke, this.browserCore);
        this.flyAction.setEnabled(false);
        this.flyMenuAction.setEnabled(false);
        this.flyButton = new JToggleButton(this.flyAction);
        this.flyButton.setMargin(new Insets(0, 0, 0, 0));
        this.flyButton.setToolTipText("Fly");
        this.navStateGroup.add(this.flyButton);
        this.add(this.flyButton);
        string = properties.getProperty(PAN_BUTTON_PROPERTY, DEFAULT_PAN_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.panAction = new NavModeAction(true, imageIcon, "xj3d_PAN", null, this.browserCore);
        this.panMenuAction = new NavModeAction(false, imageIcon, "xj3d_PAN", null, this.browserCore);
        this.panAction.setEnabled(false);
        this.panMenuAction.setEnabled(false);
        this.panButton = new JToggleButton(this.panAction);
        this.panButton.setMargin(new Insets(0, 0, 0, 0));
        this.panButton.setToolTipText("Pan");
        this.panButton.setEnabled(false);
        this.navStateGroup.add(this.panButton);
        this.add(this.panButton);
        string = properties.getProperty(TILT_BUTTON_PROPERTY, DEFAULT_TILT_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.tiltAction = new NavModeAction(true, imageIcon, "xj3d_TILT", null, this.browserCore);
        this.tiltMenuAction = new NavModeAction(false, imageIcon, "xj3d_TILT", null, this.browserCore);
        this.tiltAction.setEnabled(false);
        this.tiltMenuAction.setEnabled(false);
        this.tiltButton = new JToggleButton(this.tiltAction);
        this.tiltButton.setMargin(new Insets(0, 0, 0, 0));
        this.tiltButton.setToolTipText("Tilt");
        this.tiltButton.setEnabled(false);
        this.navStateGroup.add(this.tiltButton);
        this.add(this.tiltButton);
        string = properties.getProperty(WALK_BUTTON_PROPERTY, DEFAULT_WALK_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        keyStroke = KeyStroke.getKeyStroke(87, 2);
        this.walkAction = new NavModeAction(true, imageIcon, "WALK", keyStroke, this.browserCore);
        this.walkMenuAction = new NavModeAction(false, imageIcon, "WALK", keyStroke, this.browserCore);
        this.walkAction.setEnabled(false);
        this.walkMenuAction.setEnabled(false);
        this.walkButton = new JToggleButton(this.walkAction);
        this.walkButton.setMargin(new Insets(0, 0, 0, 0));
        this.walkButton.setToolTipText("Walk");
        this.navStateGroup.add(this.walkButton);
        this.add(this.walkButton);
        string = properties.getProperty(TRACK_BUTTON_PROPERTY, DEFAULT_TRACK_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        this.trackAction = new NavModeAction(true, imageIcon, "xj3d_TRACK_EXAMINE", null, this.browserCore);
        this.trackMenuAction = new NavModeAction(false, imageIcon, "xj3d_TRACK_EXAMINE", null, this.browserCore);
        this.trackAction.setEnabled(false);
        this.trackMenuAction.setEnabled(false);
        this.trackButton = new JToggleButton(this.trackAction);
        this.trackButton.setMargin(new Insets(0, 0, 0, 0));
        this.trackButton.setToolTipText("Track");
        this.trackButton.setEnabled(false);
        this.navStateGroup.add(this.trackButton);
        this.add(this.trackButton);
        string = properties.getProperty(EXAMINE_BUTTON_PROPERTY, DEFAULT_EXAMINE_BUTTON);
        imageIcon = IconLoader.loadIcon(string, errorReporter);
        keyStroke = KeyStroke.getKeyStroke(69, 2);
        this.examineAction = new NavModeAction(true, imageIcon, "EXAMINE", keyStroke, this.browserCore);
        this.examineMenuAction = new NavModeAction(false, imageIcon, "EXAMINE", keyStroke, this.browserCore);
        this.examineAction.setEnabled(false);
        this.examineMenuAction.setEnabled(false);
        this.examineButton = new JToggleButton(this.examineAction);
        this.examineButton.setMargin(new Insets(0, 0, 0, 0));
        this.examineButton.setToolTipText("Examine");
        this.examineButton.setEnabled(false);
        this.navStateGroup.add(this.examineButton);
        this.add(this.examineButton);
    }

    public void navigationStateChanged(int n) {
        if (this.navigationModes != null) {
            String string = this.navigationModes[n];
            if (string.equalsIgnoreCase("WALK")) {
                this.walkButton.setSelected(true);
            } else if (string.equalsIgnoreCase("FLY")) {
                this.flyButton.setSelected(true);
            } else if (string.equalsIgnoreCase("xj3d_TILT")) {
                this.tiltButton.setSelected(true);
            } else if (string.equalsIgnoreCase("xj3d_PAN")) {
                this.panButton.setSelected(true);
            } else if (string.equalsIgnoreCase("EXAMINE")) {
                this.examineButton.setSelected(true);
            } else if (string.equalsIgnoreCase("xj3d_TRACK_EXAMINE")) {
                this.trackButton.setSelected(true);
            }
        }
    }

    public void navigationListChanged(String[] stringArray, int n) {
        if (this.navigationModes == null || this.navigationModes.length != n) {
            this.navigationModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navigationModes, 0, n);
        boolean bl = false;
        this.walkAction.setEnabled(false);
        this.walkMenuAction.setEnabled(false);
        this.flyAction.setEnabled(false);
        this.flyMenuAction.setEnabled(false);
        this.examineAction.setEnabled(false);
        this.examineMenuAction.setEnabled(false);
        this.panAction.setEnabled(false);
        this.panMenuAction.setEnabled(false);
        this.tiltAction.setEnabled(false);
        this.tiltMenuAction.setEnabled(false);
        this.trackAction.setEnabled(false);
        this.trackMenuAction.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("ANY")) {
                bl = true;
                break;
            }
            String string = stringArray[i];
            if (string.equals("WALK")) {
                this.walkAction.setEnabled(true);
                this.walkMenuAction.setEnabled(true);
                continue;
            }
            if (string.equals("FLY")) {
                this.flyAction.setEnabled(true);
                this.flyMenuAction.setEnabled(true);
                continue;
            }
            if (string.equals("EXAMINE")) {
                this.examineAction.setEnabled(true);
                this.examineMenuAction.setEnabled(true);
                continue;
            }
            if (string.equals("xj3d_PAN")) {
                this.panAction.setEnabled(true);
                this.panMenuAction.setEnabled(true);
                continue;
            }
            if (string.equals("xj3d_TILT")) {
                this.tiltAction.setEnabled(true);
                this.tiltMenuAction.setEnabled(true);
                continue;
            }
            if (!string.equals("xj3d_TRACK_EXAMINE")) continue;
            this.trackAction.setEnabled(true);
            this.trackMenuAction.setEnabled(true);
        }
        if (bl) {
            this.walkAction.setEnabled(true);
            this.walkMenuAction.setEnabled(true);
            this.flyAction.setEnabled(true);
            this.flyMenuAction.setEnabled(true);
            this.examineAction.setEnabled(true);
            this.examineMenuAction.setEnabled(true);
            this.panAction.setEnabled(true);
            this.panMenuAction.setEnabled(true);
            this.tiltAction.setEnabled(true);
            this.tiltMenuAction.setEnabled(true);
            this.trackAction.setEnabled(true);
            this.trackMenuAction.setEnabled(true);
        }
    }

    public AbstractAction getFlyAction() {
        return this.flyMenuAction;
    }

    public AbstractAction getWalkAction() {
        return this.walkMenuAction;
    }

    public AbstractAction getExamineAction() {
        return this.examineMenuAction;
    }

    public AbstractAction getPanAction() {
        return this.panMenuAction;
    }

    public AbstractAction getTiltAction() {
        return this.tiltMenuAction;
    }

    public AbstractAction getTrackAction() {
        return this.trackMenuAction;
    }
}

