/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ietf.uri.URL;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.InputSource;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.FramerateThrottle;
import org.xj3d.ui.awt.widgets.DynamicGridLayout;
import org.xj3d.ui.awt.widgets.IconLoader;
import org.xj3d.ui.awt.widgets.OpenAction;
import org.xj3d.ui.awt.widgets.ReloadAction;

public class SwingLocationToolbar
extends JPanel
implements ActionListener,
FileHandler,
BrowserCoreListener {
    private static final Properties DEFAULT_SKIN = new Properties();
    private static final String GO_BUTTON_PROPERTY = "GO.button";
    private static final String OPEN_BUTTON_PROPERTY = "OPEN.button";
    private static final String RELOAD_BUTTON_PROPERTY = "RELOAD.button";
    private static final String DEFAULT_GO_BUTTON = "images/locationbar/goIcon32x32.gif";
    private static final String DEFAULT_OPEN_BUTTON = "images/locationbar/openIcon32x32.gif";
    private static final String DEFAULT_RELOAD_BUTTON = "images/locationbar/reloadIcon32x32.gif";
    private static final int MAX_LOCATIONS = 5;
    private static final String HISTORY_PROPERTY = "History_";
    private String historyFile;
    private Vector locations;
    private ErrorReporter errorReporter;
    private JComboBox urlComboBox;
    private JButton locationGoButton;
    private JButton openButton;
    private JButton reloadButton;
    private String contentDirectory;
    private BrowserCore browserCore;
    private boolean ignoreAction;
    private boolean locationEmpty;
    private WorldLoaderManager loader;
    private String userDir;
    private FramerateThrottle throttle;
    private OpenAction openAction;
    private ReloadAction reloadAction;

    public SwingLocationToolbar(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, boolean bl, boolean bl2, boolean bl3, String string, ErrorReporter errorReporter) {
        this(browserCore, worldLoaderManager, bl, bl2, bl3, string, null, errorReporter);
    }

    public SwingLocationToolbar(BrowserCore browserCore, WorldLoaderManager worldLoaderManager, boolean bl, boolean bl2, boolean bl3, String string, Properties properties, ErrorReporter errorReporter) {
        super(new BorderLayout());
        this.loader = worldLoaderManager;
        this.browserCore = browserCore;
        this.contentDirectory = string;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        if (properties == null) {
            properties = DEFAULT_SKIN;
        }
        this.browserCore.addCoreListener((BrowserCoreListener)this);
        JLabel jLabel = new JLabel(" Location: ");
        String string2 = properties.getProperty(GO_BUTTON_PROPERTY, DEFAULT_GO_BUTTON);
        ImageIcon imageIcon = IconLoader.loadIcon(string2, errorReporter);
        this.locationGoButton = imageIcon == null ? new JButton(" Go! ") : new JButton(imageIcon);
        this.locationGoButton.setEnabled(!bl);
        this.locationGoButton.setMargin(new Insets(0, 0, 0, 0));
        this.locationGoButton.setToolTipText("Go to the new location");
        this.locations = new Vector();
        this.userDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("user.dir");
                return string;
            }
        });
        this.userDir = this.userDir + "\\";
        this.locations.add(this.userDir);
        this.locationEmpty = true;
        this.loadLocations();
        this.urlComboBox = new JComboBox(this.locations);
        this.urlComboBox.setLightWeightPopupEnabled(false);
        this.urlComboBox.setEditable(true);
        this.urlComboBox.addActionListener(this);
        this.urlComboBox.requestFocus();
        this.urlComboBox.setEditable(!bl);
        if (!bl) {
            this.locationGoButton.addActionListener(this);
        }
        DynamicGridLayout dynamicGridLayout = new DynamicGridLayout(1, 4, 2, 2);
        dynamicGridLayout.setColumnSize(0, -1);
        dynamicGridLayout.setColumnSize(1, -1);
        dynamicGridLayout.setColumnSize(3, -1);
        dynamicGridLayout.setRowSize(0, -1);
        JPanel jPanel = new JPanel(dynamicGridLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        if (bl2 || bl3) {
            int n = 0;
            if (bl2) {
                ++n;
            }
            if (bl3) {
                ++n;
            }
            JPanel jPanel3 = new JPanel(new GridLayout(1, n));
            if (bl2) {
                string2 = properties.getProperty(OPEN_BUTTON_PROPERTY, DEFAULT_OPEN_BUTTON);
                imageIcon = IconLoader.loadIcon(string2, errorReporter);
                this.openButton = imageIcon == null ? new JButton("Open") : new JButton(imageIcon);
                this.openButton.setToolTipText("Open File");
                this.openButton.setMargin(new Insets(0, 0, 0, 0));
                this.openAction = new OpenAction(this, this, this.contentDirectory);
                this.openButton.addActionListener(this.openAction);
                jPanel3.add(this.openButton);
            }
            if (bl3) {
                string2 = properties.getProperty(RELOAD_BUTTON_PROPERTY, DEFAULT_RELOAD_BUTTON);
                imageIcon = IconLoader.loadIcon(string2, errorReporter);
                this.reloadButton = imageIcon == null ? new JButton("Reload") : new JButton(imageIcon);
                this.reloadButton.setToolTipText("Reload current location");
                this.reloadButton.setMargin(new Insets(0, 0, 0, 0));
                this.reloadAction = new ReloadAction(this, this, this.urlComboBox);
                this.reloadButton.addActionListener(this.reloadAction);
                jPanel3.add(this.reloadButton);
            }
            Font font = jLabel.getFont().deriveFont(1.0f);
            JLabel jLabel2 = new JLabel(" ");
            JLabel jLabel3 = new JLabel(" ");
            JLabel jLabel4 = new JLabel(" ");
            JLabel jLabel5 = new JLabel(" ");
            jLabel2.setFont(font);
            jLabel3.setFont(font);
            jLabel4.setFont(font);
            jLabel5.setFont(font);
            DynamicGridLayout dynamicGridLayout2 = new DynamicGridLayout(3, 2, 0, 0);
            dynamicGridLayout2.setColumnSize(0, -1);
            dynamicGridLayout2.setRowSize(1, -1);
            jPanel2 = new JPanel(dynamicGridLayout2);
            jPanel2.add(jLabel2);
            jPanel2.add(jLabel3);
            jPanel2.add(jLabel);
            jPanel2.add(this.urlComboBox);
            jPanel2.add(jLabel4);
            jPanel2.add(jLabel5);
            if (bl2) {
                jPanel.add(this.openButton);
            }
            if (bl3) {
                jPanel.add(this.reloadButton);
            }
            jPanel.add(jPanel2);
            jPanel.add(this.locationGoButton);
        }
        this.add((Component)jPanel, "North");
    }

    public AbstractAction getOpenAction() {
        return this.openAction;
    }

    public AbstractAction getReloadAction() {
        return this.reloadAction;
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        String string = vRMLScene.getLoadedURI();
        this.errorReporter.messageReport("Main scene: " + string + " loaded.");
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void loadURL(String string) throws IOException {
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.errorReporter.errorReport("File is a directory", null);
            } else {
                string2 = file.toURL().toExternalForm();
            }
        } else {
            URL uRL = new URL(string);
            string2 = uRL.toExternalForm();
        }
        if (this.throttle != null) {
            this.throttle.startedLoading();
        }
        this.loader.queueLoadURL(new String[]{string2}, null);
        this.addLocation(string2);
    }

    public void loadURL(InputSource inputSource) throws IOException {
        this.loadURL(inputSource.getURL());
    }

    public void loadLocations() {
        String string;
        Preferences preferences = Preferences.userNodeForPackage(SwingLocationToolbar.class);
        for (int i = 0; i < 5 && (string = preferences.get(HISTORY_PROPERTY + i, null)) != null; ++i) {
            this.locations.add(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Object var3_3 = null;
        if (object != this.urlComboBox || !this.ignoreAction && !actionEvent.getActionCommand().equals("comboBoxEdited")) {
            String string = (String)this.urlComboBox.getSelectedItem();
            if (string.length() < 1) {
                return;
            }
            try {
                this.loadURL(string);
            }
            catch (IOException iOException) {
                this.errorReporter.errorReport("Unable to load " + string, (Exception)iOException);
            }
        }
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.loader.setProgressListener(progressListener);
    }

    public void setThrottle(FramerateThrottle framerateThrottle) {
        this.throttle = framerateThrottle;
    }

    private void addLocation(String string) {
        String string2;
        this.ignoreAction = true;
        if (this.locationEmpty) {
            this.urlComboBox.removeItem(this.userDir);
            this.locationEmpty = false;
        }
        this.urlComboBox.removeItem(string);
        this.urlComboBox.insertItemAt(string, 0);
        Object object = this.urlComboBox.getSelectedItem();
        this.urlComboBox.setSelectedIndex(0);
        this.ignoreAction = false;
        Preferences preferences = Preferences.userNodeForPackage(SwingLocationToolbar.class);
        Iterator iterator = this.locations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (string2.length() <= 0) continue;
            preferences.remove(HISTORY_PROPERTY + n);
            ++n;
        }
        preferences.put("History_0", string);
        iterator = this.locations.iterator();
        n = 0;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (string2.length() <= 0) continue;
            preferences.put(HISTORY_PROPERTY + n, string2);
            ++n;
        }
    }

    private void clearLocations() {
        Preferences preferences = Preferences.userNodeForPackage(SwingLocationToolbar.class);
        for (int i = 0; i < 10; ++i) {
            preferences.remove(HISTORY_PROPERTY + i);
        }
    }
}

