/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.VRMLParseException;
import org.xj3d.ui.awt.widgets.SwingTextAreaOutputStream;

public class SwingConsoleWindow
extends JFrame
implements ActionListener,
ErrorHandler,
ErrorReporter {
    private static final String CLEAR_TOOLTIP = "Clear the contents of the console";
    private static final String COPY_TOOLTIP = "Copy the contents of the window to the clipboard";
    private HashSet ignoredExceptionTypes;
    private JTextArea errorField;
    private JButton clearButton;
    private JButton copyButton;
    private Locator docLocator;

    public SwingConsoleWindow() {
        super("Xj3D Console");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.errorField = new JTextArea(20, 60);
        this.errorField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.errorField);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        container.add((Component)jPanel, "South");
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText(CLEAR_TOOLTIP);
        this.clearButton.addActionListener(this);
        jPanel.add(this.clearButton);
        this.copyButton = new JButton("Copy");
        this.copyButton.setToolTipText(COPY_TOOLTIP);
        this.copyButton.addActionListener(this);
        jPanel.add(this.copyButton);
        this.setSize(600, 400);
        this.setLocation(80, 80);
        this.setDefaultCloseOperation(1);
        this.messageReport("Xj3D Version: 2_M1_DEV_2009-01-05\n");
        this.ignoredExceptionTypes = new HashSet();
        this.ignoredExceptionTypes.add(InvalidFieldException.class);
        this.ignoredExceptionTypes.add(InvalidFieldFormatException.class);
        this.ignoredExceptionTypes.add(InvalidFieldValueException.class);
        this.ignoredExceptionTypes.add(FileNotFoundException.class);
        this.ignoredExceptionTypes.add(IOException.class);
        this.ignoredExceptionTypes.add(UnknownHostException.class);
        this.ignoredExceptionTypes.add(IllegalArgumentException.class);
        this.ignoredExceptionTypes.add(InvalidFieldConnectionException.class);
        this.ignoredExceptionTypes.add(VRMLParseException.class);
        this.ignoredExceptionTypes.add(UnsupportedComponentException.class);
        this.ignoredExceptionTypes.add(UnsupportedNodeException.class);
        this.ignoredExceptionTypes.add(UnsupportedProfileException.class);
        this.ignoredExceptionTypes.add(ClassNotFoundException.class);
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void warning(VRMLException vRMLException) throws VRMLException {
        this.warning(vRMLException.getMessage(), true);
    }

    public void error(VRMLException vRMLException) throws VRMLException {
        this.error(vRMLException.getMessage(), true);
    }

    public void fatalError(VRMLException vRMLException) throws VRMLException {
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        stringBuffer.append(" Line: ");
        stringBuffer.append(this.docLocator.getLineNumber());
        stringBuffer.append(" Column: ");
        stringBuffer.append(this.docLocator.getColumnNumber());
        stringBuffer.append(" ");
        stringBuffer.append(vRMLException.getMessage());
        stringBuffer.append("\n");
        this.errorField.append(stringBuffer.toString());
        throw vRMLException;
    }

    public void partialReport(String string) {
        this.errorField.append(string);
    }

    public void messageReport(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\n');
        this.errorField.append(stringBuffer.toString());
    }

    public void warningReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Field name: ");
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void errorReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void fatalErrorReport(String string, Exception exception) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        if (exception instanceof FieldException && (object2 = (object = (FieldException)((Object)exception)).getFieldName()) != null) {
            stringBuffer.append("Field name: ");
            stringBuffer.append((String)object2);
        }
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)((Object)exception)).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.getClass().getName();
            }
            stringBuffer.append((String)object);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                object2 = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object2);
                exception.printStackTrace(printWriter);
                stringBuffer.append(((StringWriter)object2).toString());
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearButton) {
            this.errorField.setText("");
        } else if (object == this.copyButton) {
            Toolkit toolkit = this.copyButton.getToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.errorField.getText());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public void redirectSystemMessages() {
        PrintStream printStream = new PrintStream(new SwingTextAreaOutputStream("System.out: ", this.errorField));
        System.setOut(printStream);
        PrintStream printStream2 = new PrintStream(new SwingTextAreaOutputStream("System.err: ", this.errorField));
        System.setErr(printStream);
    }

    private void warning(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (bl) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append("\n");
        this.errorField.append(stringBuffer.toString());
    }

    private void error(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (bl) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append("\n");
        this.errorField.append(stringBuffer.toString());
    }
}

