/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.web3d.util.FileHandler;
import org.xj3d.ui.awt.widgets.VRMLFileFilter;
import org.xj3d.ui.awt.widgets.Web3DFileFilter;
import org.xj3d.ui.awt.widgets.X3DFileFilter;

public class OpenAction
extends AbstractAction {
    private static final String LASTDIR_PROPERTY = "History_";
    private FileHandler fileHandler;
    private Component parent;
    private JFileChooser fc;

    public OpenAction(Component component, FileHandler fileHandler, String string) {
        super("Open");
        this.parent = component;
        this.fileHandler = fileHandler;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(79, 2);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("MnemonicKey", new Integer(79));
        this.putValue("ShortDescription", "Open A new VRML or X3D file");
        String string2 = null;
        if (string == null) {
            Preferences preferences = Preferences.userNodeForPackage(OpenAction.class);
            String string3 = preferences.get(LASTDIR_PROPERTY, null);
            String string4 = System.getProperty("user.dir");
            string2 = string3 != null ? string3 : string4;
        } else {
            string2 = string;
        }
        this.fc = new JFileChooser(string2);
        this.fc.addChoosableFileFilter(new X3DFileFilter());
        this.fc.addChoosableFileFilter(new VRMLFileFilter());
        this.fc.addChoosableFileFilter(new Web3DFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.fc.showDialog(this.parent, "Open File");
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                String string = file.getPath();
                int n2 = string.lastIndexOf(File.separator);
                if (n2 > 0) {
                    string = string.substring(0, n2);
                    Preferences preferences = Preferences.userNodeForPackage(OpenAction.class);
                    preferences.put(LASTDIR_PROPERTY, string);
                }
                if (file.exists()) {
                    this.fileHandler.loadURL(file.toURL().toString());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

