/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JTextField;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;

public class LoadURLAction
implements ActionListener,
Runnable {
    private FileHandler handler;
    private JTextField urlSourceA;
    private TextField urlSourceB;

    public LoadURLAction(FileHandler fileHandler, JTextField jTextField) {
        this.handler = fileHandler;
        this.urlSourceA = jTextField;
    }

    public LoadURLAction(FileHandler fileHandler, TextField textField) {
        this.handler = fileHandler;
        this.urlSourceB = textField;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new Thread(this).start();
    }

    public void run() {
        String string = this.urlSourceA != null ? this.urlSourceA.getText() : this.urlSourceB.getText();
        ErrorReporter errorReporter = this.handler.getErrorReporter();
        try {
            errorReporter.messageReport("Attempting to load:" + string);
            String string2 = null;
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory()) {
                    errorReporter.errorReport("File is a directory", null);
                } else {
                    string2 = file.toURL().toExternalForm();
                }
            } else {
                URL uRL = new URL(string);
                string2 = uRL.toExternalForm();
            }
            this.handler.loadURL(string2);
        }
        catch (IOException iOException) {
            errorReporter.errorReport("Unable to load " + string, (Exception)iOException);
        }
        catch (Exception exception) {
            errorReporter.errorReport("Unusual exception trying to load:" + string, exception);
        }
    }
}

