/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.web3d.util.ErrorReporter;

public class IconLoader {
    private static final String IMAGE_FAIL_MSG = "Unable to locate the required image file ";
    private static final int DEFAULT_SIZE = 70;
    private static WeakHashMap loadedIcons = new WeakHashMap(70);
    private static WeakHashMap loadedImages = new WeakHashMap(70);

    public static Image loadImage(String string, ErrorReporter errorReporter) {
        Image image = (Image)loadedImages.get(string);
        if (string == null) {
            return null;
        }
        URL uRL = ClassLoader.getSystemResource(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (uRL != null) {
            image = toolkit.createImage(uRL);
        }
        if (image == null && (uRL = IconLoader.class.getClassLoader().getResource(string)) != null) {
            image = toolkit.createImage(uRL);
        }
        if (image == null) {
            errorReporter.warningReport(IMAGE_FAIL_MSG + string, null);
        } else {
            loadedImages.put(string, image);
        }
        return image;
    }

    public static ImageIcon loadIcon(String string, ErrorReporter errorReporter) {
        Image image;
        ImageIcon imageIcon = (ImageIcon)loadedIcons.get(string);
        if (imageIcon == null && (image = IconLoader.loadImage(string, errorReporter)) != null) {
            imageIcon = new ImageIcon(image, string);
            loadedIcons.put(string, imageIcon);
        }
        return imageIcon;
    }
}

