/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.SimpleStack;
import org.xj3d.core.eventmodel.CursorFilter;
import org.xj3d.ui.awt.widgets.IconLoader;

public class CursorManager
implements org.xj3d.core.eventmodel.CursorManager,
SensorStatusListener,
NavigationStateListener,
KeyListener {
    private static final String NULL_CANVAS_MSG = "The canvas reference cannot be null";
    private static final String ANCHOR_CURSOR_PROPERTY = "anchor.cursor";
    private static final String DRAGSENSOR_CURSOR_PROPERTY = "dragSensor.cursor";
    private static final String EXAMINE_CURSOR_PROPERTY = "EXAMINE.cursor";
    private static final String LOOKAT_CURSOR_PROPERTY = "LOOKAT.cursor";
    private static final String FLY_CURSOR_PROPERTY = "FLY.cursor";
    private static final String PAN_CURSOR_PROPERTY = "PAN.cursor";
    private static final String TILT_CURSOR_PROPERTY = "TILT.cursor";
    private static final String TOUCHSENSOR_CURSOR_PROPERTY = "touchSensor.cursor";
    private static final String WALK_CURSOR_PROPERTY = "WALK.cursor";
    private static final String NONE_CURSOR_PROPERTY = "NONE.cursor";
    private static final String TRACK_EXAMINE_CURSOR_PROPERTY = "TEXAMINE.cursor";
    private static final String TRACK_PAN_CURSOR_PROPERTY = "TPAN.cursor";
    private static final String DEFAULT_ANCHOR_CURSOR_VALUE = "images/navigation/link.gif";
    private static final String DEFAULT_DRAGSENSOR_CURSOR_VALUE = "images/navigation/drag.gif";
    private static final String DEFAULT_EXAMINE_CURSOR_VALUE = "images/navigation/CursorExamine.gif";
    private static final String DEFAULT_LOOKAT_CURSOR_VALUE = "images/navigation/CursorLookat.gif";
    private static final String DEFAULT_FLY_CURSOR_VALUE = "images/navigation/CursorFly.gif";
    private static final String DEFAULT_PAN_CURSOR_VALUE = "images/navigation/CursorPan.gif";
    private static final String DEFAULT_TILT_CURSOR_VALUE = "images/navigation/CursorTilt.gif";
    private static final String DEFAULT_TOUCHSENSOR_CURSOR_VALUE = "images/navigation/CursorTarget.gif";
    private static final String DEFAULT_WALK_CURSOR_VALUE = "images/navigation/CursorWalk.gif";
    private static final String DEFAULT_NONE_CURSOR_VALUE = "images/navigation/CursorNone.gif";
    private static final String DEFAULT_TRACK_EXAMINE_CURSOR_VALUE = "images/navigation/CursorTExamine.gif";
    private static final String DEFAULT_TRACK_PAN_CURSOR_VALUE = "images/navigation/CursorTPan.gif";
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private ErrorReporter errorReporter;
    private NavigationStateListener navListener;
    private Component canvas;
    private Cursor tsCursor;
    private Cursor dsCursor;
    private Cursor anchorCursor;
    private Cursor navStateCursor;
    private SimpleStack sensorStack;
    private Hashtable navCursors;
    private String[] navModes;
    private String currentNavMode;
    private boolean trackNavMode;
    public boolean shiftModifier;
    public boolean altModifier;
    public boolean ctrlModifier;
    private CursorFilter filter;
    private HashMap<Cursor, String> cursorUrlMap;
    private HashMap<String, Cursor> urlCursorMap;
    private Cursor lastCursor;

    public CursorManager(Component component, ErrorReporter errorReporter) throws IllegalArgumentException {
        this(component, DEFAULT_PROPERTIES, errorReporter);
    }

    public CursorManager(Component component, Properties properties, ErrorReporter errorReporter) throws IllegalArgumentException {
        if (component == null) {
            throw new IllegalArgumentException(NULL_CANVAS_MSG);
        }
        this.canvas = component;
        component.addKeyListener(this);
        this.navCursors = new Hashtable();
        this.navModes = new String[0];
        this.sensorStack = new SimpleStack();
        this.navStateCursor = Cursor.getDefaultCursor();
        this.filter = null;
        this.cursorUrlMap = new HashMap();
        this.urlCursorMap = new HashMap();
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        this.loadCursors(properties);
    }

    public void setCursorFilter(CursorFilter cursorFilter) {
        this.filter = cursorFilter;
    }

    public CursorFilter getCursorFilter() {
        return this.filter;
    }

    public void setCursor(String string, int n, int n2) {
        if (string == null) {
            this.canvas.setCursor(this.lastCursor);
            return;
        }
        Cursor cursor = this.urlCursorMap.get(string);
        if (cursor == null) {
            if (string.startsWith("PREDEFINED.")) {
                int n3 = string.indexOf(".");
                int n4 = Integer.valueOf(string.substring(n3 + 1));
                cursor = Cursor.getPredefinedCursor(n4);
            } else {
                Point point = new Point();
                point.x = n;
                point.y = n2;
                Image image = IconLoader.loadImage(string, this.errorReporter);
                MediaTracker mediaTracker = new MediaTracker(this.canvas);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (image != null) {
                    point.x = image.getWidth(null) / 2;
                    point.y = image.getHeight(null) / 2;
                    cursor = toolkit.createCustomCursor(image, point, null);
                    this.cursorUrlMap.put(cursor, string);
                    this.urlCursorMap.put(string, cursor);
                } else {
                    this.errorReporter.warningReport("Unable to load cursor image: " + string, null);
                }
            }
            this.canvas.setCursor(cursor);
        }
    }

    public void deviceOver(int n, String string) {
        Cursor cursor = null;
        switch (n) {
            case 0: {
                cursor = this.anchorCursor;
                break;
            }
            case 1: {
                cursor = this.tsCursor;
                break;
            }
            case 2: {
                cursor = this.dsCursor;
            }
        }
        this.sensorStack.push((Object)cursor);
        if (!this.trackNavMode || !this.shiftModifier) {
            this.setCursor(cursor);
        }
    }

    public void deviceNotOver(int n) {
        if (!this.sensorStack.isEmpty()) {
            this.sensorStack.pop();
        }
        if (!this.trackNavMode || !this.shiftModifier) {
            if (!this.sensorStack.isEmpty()) {
                this.setCursor((Cursor)this.sensorStack.peek());
            } else {
                this.setCursor(this.navStateCursor);
            }
        }
    }

    public void deviceActivated(int n) {
    }

    public void linkActivated(String[] stringArray, String[] stringArray2, String string) {
    }

    public void navigationStateChanged(int n) {
        this.currentNavMode = this.navModes[n];
        this.trackNavMode = "xj3d_TRACK_EXAMINE".equals(this.currentNavMode) || "xj3d_TRACK_PAN".equals(this.currentNavMode);
        Cursor cursor = (Cursor)this.navCursors.get(this.navModes[n]);
        if (cursor == null) {
            System.out.println("Cursor node not found");
        } else {
            this.navStateCursor = cursor;
            this.setCursor(cursor);
        }
    }

    public void navigationListChanged(String[] stringArray, int n) {
        if (this.navModes.length != n) {
            this.navModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navModes, 0, n);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 18: {
                boolean bl;
                this.altModifier = true;
                if (!this.trackNavMode) break;
                this.navStateCursor = (Cursor)this.navCursors.get("xj3d_TRACK_PAN");
                boolean bl2 = bl = !this.sensorStack.isEmpty();
                if (bl && (!bl || !this.shiftModifier)) break;
                this.setCursor(this.navStateCursor);
                break;
            }
            case 17: {
                boolean bl;
                this.ctrlModifier = true;
                if (!this.trackNavMode) break;
                this.navStateCursor = (Cursor)this.navCursors.get("FLY");
                boolean bl3 = bl = !this.sensorStack.isEmpty();
                if (bl && (!bl || !this.shiftModifier)) break;
                this.setCursor(this.navStateCursor);
                break;
            }
            case 16: {
                this.shiftModifier = true;
                if (!this.trackNavMode || this.sensorStack.isEmpty()) break;
                this.setCursor(this.navStateCursor);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 18: {
                boolean bl;
                this.altModifier = false;
                if (!this.trackNavMode) break;
                this.navStateCursor = (Cursor)this.navCursors.get("xj3d_TRACK_EXAMINE");
                boolean bl2 = bl = !this.sensorStack.isEmpty();
                if (bl && (!bl || !this.shiftModifier)) break;
                this.setCursor(this.navStateCursor);
                break;
            }
            case 17: {
                boolean bl;
                this.ctrlModifier = false;
                if (!this.trackNavMode) break;
                this.navStateCursor = (Cursor)this.navCursors.get("xj3d_TRACK_EXAMINE");
                boolean bl3 = bl = !this.sensorStack.isEmpty();
                if (bl && (!bl || !this.shiftModifier)) break;
                this.setCursor(this.navStateCursor);
                break;
            }
            case 16: {
                this.shiftModifier = false;
                if (!this.trackNavMode || this.sensorStack.isEmpty()) break;
                this.setCursor((Cursor)this.sensorStack.peek());
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void loadCursors(Properties properties) {
        Cursor cursor;
        String string = properties.getProperty(TOUCHSENSOR_CURSOR_PROPERTY, DEFAULT_TOUCHSENSOR_CURSOR_VALUE);
        String string2 = properties.getProperty(DRAGSENSOR_CURSOR_PROPERTY, DEFAULT_DRAGSENSOR_CURSOR_VALUE);
        String string3 = properties.getProperty(ANCHOR_CURSOR_PROPERTY, DEFAULT_ANCHOR_CURSOR_VALUE);
        String string4 = properties.getProperty(WALK_CURSOR_PROPERTY, DEFAULT_WALK_CURSOR_VALUE);
        String string5 = properties.getProperty(FLY_CURSOR_PROPERTY, DEFAULT_FLY_CURSOR_VALUE);
        String string6 = properties.getProperty(PAN_CURSOR_PROPERTY, DEFAULT_PAN_CURSOR_VALUE);
        String string7 = properties.getProperty(TILT_CURSOR_PROPERTY, DEFAULT_TILT_CURSOR_VALUE);
        String string8 = properties.getProperty(EXAMINE_CURSOR_PROPERTY, DEFAULT_EXAMINE_CURSOR_VALUE);
        String string9 = properties.getProperty(LOOKAT_CURSOR_PROPERTY, DEFAULT_LOOKAT_CURSOR_VALUE);
        String string10 = properties.getProperty(NONE_CURSOR_PROPERTY, DEFAULT_NONE_CURSOR_VALUE);
        String string11 = properties.getProperty(TRACK_EXAMINE_CURSOR_PROPERTY, DEFAULT_TRACK_EXAMINE_CURSOR_VALUE);
        String string12 = properties.getProperty(TRACK_PAN_CURSOR_PROPERTY, DEFAULT_TRACK_PAN_CURSOR_VALUE);
        Image image = IconLoader.loadImage(string, this.errorReporter);
        Image image2 = IconLoader.loadImage(string2, this.errorReporter);
        Image image3 = IconLoader.loadImage(string3, this.errorReporter);
        Image image4 = IconLoader.loadImage(string4, this.errorReporter);
        Image image5 = IconLoader.loadImage(string5, this.errorReporter);
        Image image6 = IconLoader.loadImage(string8, this.errorReporter);
        Image image7 = IconLoader.loadImage(string6, this.errorReporter);
        Image image8 = IconLoader.loadImage(string7, this.errorReporter);
        Image image9 = IconLoader.loadImage(string9, this.errorReporter);
        Image image10 = IconLoader.loadImage(string10, this.errorReporter);
        Image image11 = IconLoader.loadImage(string11, this.errorReporter);
        Image image12 = IconLoader.loadImage(string12, this.errorReporter);
        MediaTracker mediaTracker = new MediaTracker(this.canvas);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        mediaTracker.addImage(image, 0);
        mediaTracker.addImage(image2, 0);
        mediaTracker.addImage(image3, 0);
        mediaTracker.addImage(image4, 0);
        mediaTracker.addImage(image5, 0);
        mediaTracker.addImage(image6, 0);
        mediaTracker.addImage(image7, 0);
        mediaTracker.addImage(image8, 0);
        mediaTracker.addImage(image9, 0);
        mediaTracker.addImage(image10, 0);
        mediaTracker.addImage(image11, 0);
        mediaTracker.addImage(image12, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Point point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.tsCursor = toolkit.createCustomCursor(image, point, null);
            this.cursorUrlMap.put(this.tsCursor, string);
            this.urlCursorMap.put(string, this.tsCursor);
        } else {
            this.errorReporter.warningReport("Unable to load touchSensor cursor image: " + string, null);
            this.tsCursor = Cursor.getPredefinedCursor(1);
        }
        if (image2 != null) {
            point.x = image2.getWidth(null) / 2;
            point.y = image2.getHeight(null) / 2;
            this.dsCursor = toolkit.createCustomCursor(image2, point, null);
            this.cursorUrlMap.put(this.dsCursor, string2);
            this.urlCursorMap.put(string2, this.dsCursor);
        } else {
            this.errorReporter.warningReport("Unable to load dragSensor cursor image: " + string2, null);
            this.dsCursor = Cursor.getPredefinedCursor(1);
        }
        if (image3 != null) {
            point.x = image3.getWidth(null) / 2;
            point.y = image3.getHeight(null) / 2;
            this.anchorCursor = toolkit.createCustomCursor(image3, point, null);
            this.cursorUrlMap.put(this.anchorCursor, string3);
            this.urlCursorMap.put(string3, this.anchorCursor);
        } else {
            this.errorReporter.warningReport("Unable to load anchor cursor image: " + string3, null);
            this.anchorCursor = Cursor.getPredefinedCursor(1);
        }
        if (image4 != null) {
            point.x = image4.getWidth(null) / 2;
            point.y = image4.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image4, point, null);
            this.navCursors.put("WALK", cursor);
            this.cursorUrlMap.put(cursor, string4);
            this.urlCursorMap.put(string4, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load WALK cursor image: " + string4, null);
            this.navCursors.put("WALK", Cursor.getPredefinedCursor(1));
        }
        if (image5 != null) {
            point.x = image5.getWidth(null) / 2;
            point.y = image5.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image5, point, null);
            this.navCursors.put("FLY", cursor);
            this.cursorUrlMap.put(cursor, string5);
            this.urlCursorMap.put(string5, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load FLY cursor image: " + string5, null);
            this.navCursors.put("FLY", Cursor.getPredefinedCursor(1));
        }
        if (image6 != null) {
            point.x = image6.getWidth(null) / 2;
            point.y = image6.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image6, point, null);
            this.navCursors.put("EXAMINE", cursor);
            this.cursorUrlMap.put(cursor, string8);
            this.urlCursorMap.put(string8, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load EXAMINE cursor image: " + string8, null);
            this.navCursors.put("EXAMINE", Cursor.getPredefinedCursor(1));
        }
        if (image7 != null) {
            point.x = image7.getWidth(null) / 2;
            point.y = image7.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image7, point, null);
            this.navCursors.put("xj3d_PAN", cursor);
            this.cursorUrlMap.put(cursor, string6);
            this.urlCursorMap.put(string6, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load xj3d_pan cursor image: " + string6, null);
            this.navCursors.put("xj3d_PAN", Cursor.getPredefinedCursor(1));
        }
        if (image8 != null) {
            point.x = image8.getWidth(null) / 2;
            point.y = image8.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image8, point, null);
            this.navCursors.put("xj3d_TILT", cursor);
            this.cursorUrlMap.put(cursor, string7);
            this.urlCursorMap.put(string7, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load xj3d_tilt cursor image: " + string7, null);
            this.navCursors.put("xj3d_TILT", Cursor.getPredefinedCursor(1));
        }
        if (image9 != null) {
            point.x = image9.getWidth(null) / 2;
            point.y = image9.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image9, point, null);
            this.navCursors.put("LOOKAT", cursor);
            this.cursorUrlMap.put(cursor, string9);
            this.urlCursorMap.put(string9, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load LOOKAT cursor image: " + string9, null);
            this.navCursors.put("LOOKAT", Cursor.getPredefinedCursor(1));
        }
        if (image10 != null) {
            point.x = image10.getWidth(null) / 2;
            point.y = image10.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image10, point, null);
            this.navCursors.put("NONE", cursor);
            this.cursorUrlMap.put(cursor, string10);
            this.urlCursorMap.put(string10, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load NONE cursor image: " + string10, null);
            this.navCursors.put("NONE", Cursor.getPredefinedCursor(1));
        }
        if (image11 != null) {
            point.x = image11.getWidth(null) / 2;
            point.y = image11.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image11, point, null);
            this.navCursors.put("xj3d_TRACK_EXAMINE", cursor);
            this.cursorUrlMap.put(cursor, string11);
            this.urlCursorMap.put(string11, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load TRACK EXAMINE cursor image: " + string11, null);
            this.navCursors.put("xj3d_TRACK_EXAMINE", Cursor.getPredefinedCursor(1));
        }
        if (image12 != null) {
            point.x = image12.getWidth(null) / 2;
            point.y = image12.getHeight(null) / 2;
            cursor = toolkit.createCustomCursor(image12, point, null);
            this.navCursors.put("xj3d_TRACK_PAN", cursor);
            this.cursorUrlMap.put(cursor, string12);
            this.urlCursorMap.put(string12, cursor);
        } else {
            this.errorReporter.warningReport("Unable to load TRACK PAN cursor image: " + string12, null);
            this.navCursors.put("xj3d_TRACK_PAN", Cursor.getPredefinedCursor(1));
        }
    }

    private void setCursor(Cursor cursor) {
        String string;
        this.lastCursor = cursor;
        if (this.filter == null) {
            this.canvas.setCursor(cursor);
            return;
        }
        String string2 = this.cursorUrlMap.get(cursor);
        if (string2.equals(string = this.filter.cursorChanged(string2))) {
            this.canvas.setCursor(cursor);
            return;
        }
        Cursor cursor2 = this.urlCursorMap.get(string);
        if (cursor2 == null) {
            if (string.startsWith("PREDEFINED.")) {
                int n = string.indexOf(".");
                int n2 = Integer.valueOf(string.substring(n + 1));
                cursor2 = Cursor.getPredefinedCursor(n2);
            } else {
                Point point = new Point();
                Image image = IconLoader.loadImage(string2, this.errorReporter);
                MediaTracker mediaTracker = new MediaTracker(this.canvas);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (image != null) {
                    point.x = image.getWidth(null) / 2;
                    point.y = image.getHeight(null) / 2;
                    cursor2 = toolkit.createCustomCursor(image, point, null);
                    this.cursorUrlMap.put(cursor2, string);
                    this.urlCursorMap.put(string, cursor2);
                } else {
                    this.errorReporter.warningReport("Unable to load cursor image: " + string, null);
                    cursor2 = cursor;
                }
            }
            this.canvas.setCursor(cursor2);
        }
    }
}

