/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.Label;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.util.ErrorReporter;

public class AWTProgressListener
implements ProgressListener {
    private Label statusLabel;
    private ErrorReporter reporter;

    public AWTProgressListener(Label label, ErrorReporter errorReporter) {
        this.statusLabel = label;
        this.reporter = errorReporter;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        URI uRI = resourceConnection.getURI();
        StringBuffer stringBuffer = new StringBuffer(uRI.toExternalForm());
        stringBuffer.append(" (");
        stringBuffer.append(progressEvent.getValue());
        stringBuffer.append(")");
        this.statusLabel.setText(stringBuffer.toString());
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        URI uRI = resourceConnection.getURI();
        String string = uRI.toExternalForm() + " complete.";
        this.statusLabel.setText(string);
        this.reporter.messageReport(string);
    }

    public void downloadError(ProgressEvent progressEvent) {
        this.statusLabel.setText(progressEvent.getMessage());
        this.reporter.errorReport(progressEvent.getMessage(), null);
    }
}

