/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.widgets;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;

public class AWTConsoleWindow
extends Frame
implements ActionListener,
ErrorHandler {
    private TextArea errorField;
    private Button clearButton;
    private Locator docLocator;

    public AWTConsoleWindow() {
        super("Xj3D Console");
        this.setLayout(new BorderLayout());
        this.errorField = new TextArea(20, 60);
        this.add((Component)this.errorField, "Center");
        Panel panel = new Panel(new FlowLayout());
        this.add((Component)panel, "South");
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this);
        panel.add(this.clearButton);
        this.setSize(600, 400);
        this.setLocation(80, 80);
        this.messageReport("Xj3D Version: 2_M1_DEV_2009-01-05\n");
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void partialReport(String string) {
        this.errorField.append(string);
    }

    public void messageReport(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\n');
        this.errorField.append(stringBuffer.toString());
    }

    public void warningReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null || string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("No message provided\n");
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void errorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null || string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("No message provided\n");
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void fatalErrorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        if (this.docLocator != null) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(this.docLocator.getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(this.docLocator.getColumnNumber());
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 != null || string2.length() != 0) {
                stringBuffer.append(exception.getMessage());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("No message provided\n");
            }
        }
        this.errorField.append(stringBuffer.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearButton) {
            this.errorField.setText("");
        }
    }
}

