/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.net.content;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.ietf.uri.ResourceConnection;
import org.j3d.util.ImageUtils;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.net.content.ImageContentHandler;
import org.web3d.util.MathUtils;

class AWTImageContentHandler
extends ImageContentHandler {
    AWTImageContentHandler() {
    }

    public Object getContent(ResourceConnection resourceConnection) throws IOException {
        try {
            NIOBufferImage nIOBufferImage;
            Object object;
            Object object2;
            String string = resourceConnection.getURI().toExternalForm();
            Class clazz = AWTImageContentHandler.getPreferedImageClass();
            if (clazz != null) {
                object2 = new Class[]{clazz};
                object = new URL(string).openConnection().getContent((Class<?>[])object2);
                if (clazz.isInstance(object) && (nIOBufferImage = AWTImageContentHandler.convert((Class)clazz, (Object)object)) != null) {
                    NIOBufferImage[] nIOBufferImageArray = this.preprocess(nIOBufferImage);
                    NIOBufferImage nIOBufferImage2 = this.consolidate(nIOBufferImageArray);
                    return nIOBufferImage2;
                }
            }
            object2 = null;
            object = new URL(string).openConnection().getContent();
            if (object instanceof BufferedImage) {
                object2 = (BufferedImage)object;
            } else if (object instanceof ImageProducer) {
                object2 = ImageUtils.createBufferedImage((ImageProducer)((ImageProducer)object));
            }
            if (object2 != null) {
                nIOBufferImage = this.preprocess((BufferedImage)object2);
                NIOBufferImage nIOBufferImage3 = this.consolidate((BufferedImage[])nIOBufferImage);
                return nIOBufferImage3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException.getMessage());
        }
        return null;
    }

    private NIOBufferImage toNIOBufferImage(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        ByteBuffer byteBuffer = null;
        NIOBufferImageType nIOBufferImageType = null;
        boolean bl = false;
        int n4 = bufferedImage.getType();
        block0 : switch (n4) {
            case 2: 
            case 6: {
                nIOBufferImageType = NIOBufferImageType.RGBA;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                nIOBufferImageType = NIOBufferImageType.RGB;
                break;
            }
            case 10: 
            case 11: {
                nIOBufferImageType = NIOBufferImageType.INTENSITY;
                bl = true;
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                n = bufferedImage.getColorModel().getNumComponents();
                switch (n) {
                    case 1: {
                        nIOBufferImageType = NIOBufferImageType.INTENSITY;
                        bl = true;
                        break block0;
                    }
                    case 2: {
                        nIOBufferImageType = NIOBufferImageType.INTENSITY_ALPHA;
                        bl = true;
                        break block0;
                    }
                    case 3: {
                        nIOBufferImageType = NIOBufferImageType.RGB;
                        bl = this.checkGrayScale(bufferedImage);
                        break block0;
                    }
                    case 4: {
                        nIOBufferImageType = NIOBufferImageType.RGBA;
                        bl = this.checkGrayScale(bufferedImage);
                    }
                }
            }
        }
        if (nIOBufferImageType != null) {
            n = nIOBufferImageType.size;
            byteBuffer = ByteBuffer.allocateDirect(n3 * n2 * n);
            byteBuffer.order(ByteOrder.nativeOrder());
            switch (n) {
                case 4: {
                    int[] nArray = new int[n3];
                    for (int i = n2 - 1; i >= 0; --i) {
                        bufferedImage.getRGB(0, i, n3, 1, nArray, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n5 = nArray[j];
                            byteBuffer.put((byte)(n5 >> 16));
                            byteBuffer.put((byte)(n5 >> 8));
                            byteBuffer.put((byte)n5);
                            byteBuffer.put((byte)(n5 >> 24));
                        }
                    }
                    break;
                }
                case 3: {
                    int[] nArray = new int[n3];
                    for (int i = n2 - 1; i >= 0; --i) {
                        bufferedImage.getRGB(0, i, n3, 1, nArray, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n6 = nArray[j];
                            byteBuffer.put((byte)(n6 >> 16));
                            byteBuffer.put((byte)(n6 >> 8));
                            byteBuffer.put((byte)n6);
                        }
                    }
                    break;
                }
                case 2: {
                    Raster raster = bufferedImage.getData();
                    ColorModel colorModel = bufferedImage.getColorModel();
                    Object object = null;
                    int[] nArray = null;
                    for (int i = n2 - 1; i >= 0; --i) {
                        for (int j = 0; j < n3; ++j) {
                            object = raster.getDataElements(j, i, object);
                            nArray = colorModel.getComponents(object, nArray, 0);
                            byteBuffer.put((byte)nArray[0]);
                            byteBuffer.put((byte)nArray[1]);
                        }
                    }
                    break;
                }
                case 1: {
                    Raster raster = bufferedImage.getData();
                    DataBuffer dataBuffer = raster.getDataBuffer();
                    for (int i = n2 - 1; i >= 0; --i) {
                        int n7 = i * n3;
                        for (int j = 0; j < n3; ++j) {
                            byteBuffer.put((byte)dataBuffer.getElem(n7++));
                        }
                    }
                    break;
                }
                default: {
                    System.out.println("Unhandled NIOBufferImageType: " + nIOBufferImageType);
                }
            }
        }
        return new NIOBufferImage(n3, n2, nIOBufferImageType, bl, byteBuffer);
    }

    private BufferedImage[] preprocess(BufferedImage bufferedImage) {
        BufferedImage[] bufferedImageArray;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = MathUtils.nearestPowerTwo((int)n, (boolean)imageScaleUp);
        int n4 = MathUtils.nearestPowerTwo((int)n2, (boolean)imageScaleUp);
        if (maxTextureSize > 0) {
            float f;
            if (n3 == n4) {
                if (n3 > maxTextureSize) {
                    f = (float)maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n3 > n4) {
                if (n3 > maxTextureSize) {
                    f = (float)maxTextureSize / (float)n3;
                    n3 = (int)(f * (float)n3);
                    n4 = (int)(f * (float)n4);
                }
            } else if (n4 > maxTextureSize) {
                f = (float)maxTextureSize / (float)n4;
                n3 = (int)(f * (float)n3);
                n4 = (int)(f * (float)n4);
            }
        }
        if (n != n3 || n2 != n4) {
            bufferedImage = this.scale(bufferedImage, n3, n4);
        }
        if (useMipMaps) {
            boolean bl = false;
            int n5 = Math.max(MathUtils.computeLog((int)n3), MathUtils.computeLog((int)n4)) + 1;
            bufferedImageArray = new BufferedImage[n5];
            bufferedImageArray[0] = bufferedImage;
            for (int i = 1; i < n5; ++i) {
                if (n3 > 1) {
                    n3 >>= 1;
                }
                if (n4 > 1) {
                    n4 >>= 1;
                }
                bufferedImageArray[i] = this.scale(bufferedImage, n3, n4);
            }
        } else {
            bufferedImageArray = new BufferedImage[]{bufferedImage};
        }
        return bufferedImageArray;
    }

    private NIOBufferImage consolidate(BufferedImage[] bufferedImageArray) {
        NIOBufferImage nIOBufferImage = null;
        if (bufferedImageArray != null && bufferedImageArray[0] != null) {
            nIOBufferImage = this.toNIOBufferImage(bufferedImageArray[0]);
            int n = bufferedImageArray.length;
            if (n > 1) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[n];
                byteBufferArray[0] = nIOBufferImage.getBuffer();
                for (int i = 1; i < n; ++i) {
                    NIOBufferImage nIOBufferImage2 = this.toNIOBufferImage(bufferedImageArray[i]);
                    byteBufferArray[i] = nIOBufferImage2.getBuffer();
                }
                nIOBufferImage.setBuffer(byteBufferArray);
            }
            for (int i = 0; i < n; ++i) {
                bufferedImageArray[i].flush();
                bufferedImageArray[i] = null;
            }
        }
        return nIOBufferImage;
    }

    private BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n3 == n && n4 == n2) {
            return bufferedImage;
        }
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        if (bl && n <= 64 && n2 <= 64) {
            return this.scalePretty(bufferedImage, n, n2);
        }
        double d = (float)n / (float)n3;
        double d2 = (float)n2 / (float)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, rescale);
        BufferedImage bufferedImage2 = null;
        if (bl) {
            bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        } else {
            bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
            affineTransformOp.filter(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }

    private BufferedImage scalePretty(BufferedImage bufferedImage, int n, int n2) {
        Image image = bufferedImage.getScaledInstance(n, n2, 16);
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = bl ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage2;
    }

    private boolean checkGrayScale(BufferedImage bufferedImage) {
        boolean bl = false;
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n = directColorModel.getRedMask();
            int n2 = directColorModel.getGreenMask();
            int n3 = directColorModel.getBlueMask();
            if (n == n2 && n2 == n3) {
                bl = true;
            }
        }
        return bl;
    }
}

